/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.obfuscation.jackson;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.Annotated;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.module.SimpleModule;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.gradle.obfuscation.ObfuscationControl;
import com.gradle.obfuscation.jackson.JacksonObfuscationVerificationException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class ObfuscationSafetyVerificationModule
extends SimpleModule {
    public ObfuscationSafetyVerificationModule() {
        this.setSerializerModifier(new BeanSerializerModifier(){

            @Override
            public List<BeanPropertyWriter> changeProperties(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
                List list2;
                Class<?> clazz = beanDescription.getBeanClass();
                if (!(ObfuscationControl.keepsAll(clazz) || ObfuscationSafetyVerificationModule.usesNonNameDependentFormat(clazz) || (list2 = list.stream().map(BeanPropertyWriter::getMember).filter(annotatedMember -> ObfuscationSafetyVerificationModule.isReflectivelyNamed(annotatedMember)).filter(annotatedMember -> !ObfuscationControl.isNameKept(annotatedMember.getAnnotated())).map(Annotated::getName).collect(Collectors.toList())).isEmpty())) {
                    throw new JacksonObfuscationVerificationException(clazz.getName() + " is not safe to serialize (members: " + list2 + ")");
                }
                return super.changeProperties(serializationConfig, beanDescription, list);
            }
        });
        this.setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public BeanDeserializerBuilder updateBuilder(DeserializationConfig deserializationConfig, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) {
                Class<?> clazz = beanDescription.getBeanClass();
                if (!ObfuscationControl.keepsAll(clazz) && !ObfuscationSafetyVerificationModule.usesNonNameDependentFormat(clazz) && ObfuscationSafetyVerificationModule.mightUsePropertyNameReflection(beanDeserializerBuilder)) {
                    ArrayList arrayList = new ArrayList();
                    beanDeserializerBuilder.getProperties().forEachRemaining(settableBeanProperty -> {
                        if (ObfuscationSafetyVerificationModule.isReflectivelyNamed(settableBeanProperty.getMember()) && !ObfuscationControl.isNameKept(settableBeanProperty.getMember().getAnnotated())) {
                            arrayList.add(settableBeanProperty.getMember().getName());
                        }
                    });
                    if (!arrayList.isEmpty()) {
                        throw new JacksonObfuscationVerificationException(clazz.getName() + " is not safe to deserialize (members: " + arrayList + ")");
                    }
                }
                return super.updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        });
    }

    private static boolean mightUsePropertyNameReflection(BeanDeserializerBuilder beanDeserializerBuilder) {
        ValueInstantiator valueInstantiator = beanDeserializerBuilder.getValueInstantiator();
        return valueInstantiator.canInstantiate() && valueInstantiator.canCreateUsingDefault() && !valueInstantiator.canCreateUsingDelegate() && !valueInstantiator.canCreateFromObjectWith();
    }

    private static boolean usesNonNameDependentFormat(Class<?> clazz) {
        JsonFormat jsonFormat = clazz.getAnnotation(JsonFormat.class);
        if (jsonFormat == null) {
            return false;
        }
        return jsonFormat.shape() != JsonFormat.Shape.OBJECT && jsonFormat.shape() != JsonFormat.Shape.ANY;
    }

    private static boolean isReflectivelyNamed(AnnotatedMember annotatedMember) {
        JsonProperty jsonProperty = annotatedMember.getAnnotation(JsonProperty.class);
        return jsonProperty == null || jsonProperty.value().equals("");
    }
}

