/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.internal.CacheCleanupExecutor;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheCleanupExecutor
implements CacheCleanupExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCacheCleanupExecutor.class);
    private final CleanableStore cleanableStore;
    private final File gcFile;
    private final CacheCleanupStrategy cacheCleanupStrategy;
    private final BuildOperationRunner buildOperationRunner;

    public DefaultCacheCleanupExecutor(CleanableStore cleanableStore, File file, CacheCleanupStrategy cacheCleanupStrategy, BuildOperationRunner buildOperationRunner) {
        this.cleanableStore = cleanableStore;
        this.gcFile = file;
        this.cacheCleanupStrategy = cacheCleanupStrategy;
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public void cleanup() {
        this.getLastCleanupTime().ifPresent(this::performCleanupIfNecessary);
    }

    private void performCleanupIfNecessary(final Instant instant) {
        if (LOGGER.isDebugEnabled()) {
            Duration duration = Duration.between(instant, Instant.now());
            LOGGER.debug("{} has last been fully cleaned up {} hours ago", (Object)this.cleanableStore.getDisplayName(), (Object)duration.toHours());
        }
        if (!this.cacheCleanupStrategy.getCleanupFrequency().requiresCleanup(instant)) {
            LOGGER.debug("Skipping cleanup for {} as it is not yet due", (Object)this.cleanableStore.getDisplayName());
            return;
        }
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            @Override
            public void run(BuildOperationContext buildOperationContext) {
                DefaultCleanupProgressMonitor defaultCleanupProgressMonitor = new DefaultCleanupProgressMonitor(buildOperationContext);
                Timer timer = Time.startTimer();
                try {
                    DefaultCacheCleanupExecutor.this.cacheCleanupStrategy.getCleanupAction().clean(DefaultCacheCleanupExecutor.this.cleanableStore, defaultCleanupProgressMonitor);
                    FileUtils.touch(DefaultCacheCleanupExecutor.this.gcFile);
                    LOGGER.info("{} cleaned up in {}.", (Object)DefaultCacheCleanupExecutor.this.cleanableStore.getDisplayName(), (Object)timer.getElapsed());
                    buildOperationContext.setResult(new CacheCleanupResult(defaultCleanupProgressMonitor.getDeleted(), instant));
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Clean up " + DefaultCacheCleanupExecutor.this.cleanableStore.getDisplayName()).details(new CacheCleanupDetails(DefaultCacheCleanupExecutor.this.cleanableStore.getBaseDir()));
            }
        });
    }

    private Optional<Instant> getLastCleanupTime() {
        if (this.cacheCleanupStrategy == CacheCleanupStrategy.NO_CLEANUP) {
            return Optional.empty();
        }
        File file = this.cleanableStore.getBaseDir();
        if (!file.exists()) {
            return Optional.empty();
        }
        if (!this.gcFile.exists()) {
            try {
                FileUtils.touch(this.gcFile);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochMilli(this.gcFile.lastModified()));
    }

    private static class CacheCleanupResult {
        private final long deletedEntriesCount;
        private final Instant previousCleanupTime;

        private CacheCleanupResult(long l2, Instant instant) {
            this.deletedEntriesCount = l2;
            this.previousCleanupTime = instant;
        }
    }

    private static class CacheCleanupDetails {
        private final File cacheLocation;

        public CacheCleanupDetails(File file) {
            this.cacheLocation = file;
        }
    }
}

