/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.linux;

import com.gradle.maven.extension.internal.dep.oshi.hardware.NetworkIF;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractNetworkIF;
import com.gradle.maven.extension.internal.dep.oshi.software.os.linux.LinuxOperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.util.FileUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.Util;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.linux.SysPath;
import com.sun.jna.platform.linux.Udev;
import java.io.File;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinuxNetworkIF
extends AbstractNetworkIF {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxNetworkIF.class);
    private int ifType;
    private boolean connectorPresent;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;
    private String ifAlias = "";
    private NetworkIF.IfOperStatus ifOperStatus = NetworkIF.IfOperStatus.UNKNOWN;

    public LinuxNetworkIF(NetworkInterface networkInterface) throws InstantiationException {
        super(networkInterface, LinuxNetworkIF.queryIfModel(networkInterface));
        this.updateAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryIfModel(NetworkInterface networkInterface) {
        String string;
        block13: {
            string = networkInterface.getName();
            if (!LinuxOperatingSystem.HAS_UDEV) {
                return LinuxNetworkIF.queryIfModelFromSysfs(string);
            }
            Udev.UdevContext udevContext = Udev.INSTANCE.udev_new();
            if (udevContext != null) {
                try {
                    Udev.UdevDevice udevDevice = udevContext.deviceNewFromSyspath(SysPath.NET + string);
                    if (udevDevice == null) break block13;
                    try {
                        String string2 = udevDevice.getPropertyValue("ID_VENDOR_FROM_DATABASE");
                        String string3 = udevDevice.getPropertyValue("ID_MODEL_FROM_DATABASE");
                        if (!Util.isBlank(string3)) {
                            if (!Util.isBlank(string2)) {
                                String string4 = string2 + " " + string3;
                                return string4;
                            }
                            String string5 = string3;
                            return string5;
                        }
                    }
                    finally {
                        udevDevice.unref();
                    }
                }
                finally {
                    udevContext.unref();
                }
            }
        }
        return string;
    }

    private static String queryIfModelFromSysfs(String string) {
        Map<String, String> map = FileUtil.getKeyValueMapFromFile(SysPath.NET + string + "/uevent", "=");
        String string2 = map.get("ID_VENDOR_FROM_DATABASE");
        String string3 = map.get("ID_MODEL_FROM_DATABASE");
        if (!Util.isBlank(string3)) {
            if (!Util.isBlank(string2)) {
                return string2 + " " + string3;
            }
            return string3;
        }
        return string;
    }

    public static List<NetworkIF> getNetworks(boolean bl2) {
        ArrayList<NetworkIF> arrayList = new ArrayList<NetworkIF>();
        for (NetworkInterface networkInterface : LinuxNetworkIF.getNetworkInterfaces(bl2)) {
            try {
                arrayList.add(new LinuxNetworkIF(networkInterface));
            }
            catch (InstantiationException instantiationException) {
                LOG.debug("Network Interface Instantiation failed: {}", (Object)instantiationException.getMessage());
            }
        }
        return arrayList;
    }

    @Override
    public long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public long getInErrors() {
        return this.inErrors;
    }

    @Override
    public long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public long getInDrops() {
        return this.inDrops;
    }

    @Override
    public long getCollisions() {
        return this.collisions;
    }

    @Override
    public long getSpeed() {
        return this.speed;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public String getIfAlias() {
        return this.ifAlias;
    }

    @Override
    public boolean updateAttributes() {
        String string = SysPath.NET + this.getName();
        try {
            File file = new File(string + "/statistics");
            if (!file.isDirectory()) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        this.timeStamp = System.currentTimeMillis();
        this.ifType = FileUtil.getIntFromFile(string + "/type");
        this.connectorPresent = FileUtil.getIntFromFile(string + "/carrier") > 0;
        this.bytesSent = FileUtil.getUnsignedLongFromFile(string + "/statistics/tx_bytes");
        this.bytesRecv = FileUtil.getUnsignedLongFromFile(string + "/statistics/rx_bytes");
        this.packetsSent = FileUtil.getUnsignedLongFromFile(string + "/statistics/tx_packets");
        this.packetsRecv = FileUtil.getUnsignedLongFromFile(string + "/statistics/rx_packets");
        this.outErrors = FileUtil.getUnsignedLongFromFile(string + "/statistics/tx_errors");
        this.inErrors = FileUtil.getUnsignedLongFromFile(string + "/statistics/rx_errors");
        this.collisions = FileUtil.getUnsignedLongFromFile(string + "/statistics/collisions");
        this.inDrops = FileUtil.getUnsignedLongFromFile(string + "/statistics/rx_dropped");
        long l2 = FileUtil.getUnsignedLongFromFile(string + "/speed");
        this.speed = l2 < 0L ? 0L : l2 << 20;
        this.ifAlias = FileUtil.getStringFromFile(string + "/ifalias");
        this.ifOperStatus = LinuxNetworkIF.parseIfOperStatus(FileUtil.getStringFromFile(string + "/operstate"));
        return true;
    }

    private static NetworkIF.IfOperStatus parseIfOperStatus(String string) {
        switch (string) {
            case "up": {
                return NetworkIF.IfOperStatus.UP;
            }
            case "down": {
                return NetworkIF.IfOperStatus.DOWN;
            }
            case "testing": {
                return NetworkIF.IfOperStatus.TESTING;
            }
            case "dormant": {
                return NetworkIF.IfOperStatus.DORMANT;
            }
            case "notpresent": {
                return NetworkIF.IfOperStatus.NOT_PRESENT;
            }
            case "lowerlayerdown": {
                return NetworkIF.IfOperStatus.LOWER_LAYER_DOWN;
            }
        }
        return NetworkIF.IfOperStatus.UNKNOWN;
    }
}

