/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.gradle.cache.FileLockReleasedSignal;
import org.gradle.cache.internal.locklistener.FileLockCommunicator;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.cache.internal.locklistener.FileLockPacketPayload;
import org.gradle.cache.internal.locklistener.FileLockPacketType;
import org.gradle.cache.internal.locklistener.GracefullyStoppedException;
import org.gradle.cache.internal.locklistener.InetAddressProvider;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileLockContentionHandler
implements FileLockContentionHandler,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockContentionHandler.class);
    private final Lock lock = new ReentrantLock();
    private final Map<Long, ContendedAction> contendedActions = new HashMap<Long, ContendedAction>();
    private final Map<Long, FileLockReleasedSignal> lockReleasedSignals = new HashMap<Long, FileLockReleasedSignal>();
    private final Map<Long, Integer> unlocksRequestedFrom = new HashMap<Long, Integer>();
    private final Map<Long, Integer> unlocksConfirmedFrom = new HashMap<Long, Integer>();
    private final ExecutorFactory executorFactory;
    private final InetAddressProvider inetAddressProvider;
    private FileLockCommunicator communicator;
    private ManagedExecutor fileLockRequestListener;
    private ManagedExecutor unlockActionExecutor;
    private boolean stopped;

    public DefaultFileLockContentionHandler(ExecutorFactory executorFactory, InetAddressProvider inetAddressProvider) {
        this.executorFactory = executorFactory;
        this.inetAddressProvider = inetAddressProvider;
    }

    private Runnable listener() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    LOGGER.debug("Starting file lock listener thread.");
                    this.doRun();
                }
                catch (Throwable throwable) {
                    LOGGER.error("Problems handling incoming cache access requests.", throwable);
                }
                finally {
                    LOGGER.debug("File lock listener thread completed.");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doRun() {
                while (true) {
                    FileLockPacketPayload fileLockPacketPayload;
                    DatagramPacket datagramPacket;
                    try {
                        datagramPacket = DefaultFileLockContentionHandler.this.communicator.receive();
                        fileLockPacketPayload = DefaultFileLockContentionHandler.this.communicator.decode(datagramPacket);
                    }
                    catch (GracefullyStoppedException gracefullyStoppedException) {
                        return;
                    }
                    DefaultFileLockContentionHandler.this.lock.lock();
                    try {
                        ContendedAction contendedAction = (ContendedAction)DefaultFileLockContentionHandler.this.contendedActions.get(fileLockPacketPayload.getLockId());
                        if (contendedAction == null) {
                            DefaultFileLockContentionHandler.this.acceptConfirmationAsLockRequester(fileLockPacketPayload, datagramPacket.getPort());
                            continue;
                        }
                        contendedAction.addRequester(datagramPacket.getSocketAddress());
                        if (!contendedAction.running) {
                            DefaultFileLockContentionHandler.this.startLockReleaseAsLockHolder(contendedAction);
                        }
                        DefaultFileLockContentionHandler.this.communicator.confirmUnlockRequest(datagramPacket.getSocketAddress(), fileLockPacketPayload.getLockId());
                        continue;
                    }
                    finally {
                        DefaultFileLockContentionHandler.this.lock.unlock();
                        continue;
                    }
                    break;
                }
            }
        };
    }

    private void startLockReleaseAsLockHolder(ContendedAction contendedAction) {
        contendedAction.running = true;
        this.unlockActionExecutor.execute(contendedAction);
    }

    private void acceptConfirmationAsLockRequester(FileLockPacketPayload fileLockPacketPayload, Integer n2) {
        long l2 = fileLockPacketPayload.getLockId();
        if (fileLockPacketPayload.getType() == FileLockPacketType.LOCK_RELEASE_CONFIRMATION) {
            LOGGER.debug("Gradle process at port {} confirmed lock release for lock with id {}.", (Object)n2, (Object)l2);
            FileLockReleasedSignal fileLockReleasedSignal = this.lockReleasedSignals.get(l2);
            if (fileLockReleasedSignal != null) {
                LOGGER.debug("Triggering lock release signal for lock with id {}.", (Object)l2);
                fileLockReleasedSignal.trigger();
            }
        } else {
            LOGGER.debug("Gradle process at port {} confirmed unlock request for lock with id {}.", (Object)n2, (Object)l2);
            this.unlocksConfirmedFrom.put(l2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(long l2, Consumer<FileLockReleasedSignal> consumer) {
        this.lock.lock();
        try {
            this.lockReleasedSignals.remove(l2);
            this.unlocksRequestedFrom.remove(l2);
            this.unlocksConfirmedFrom.remove(l2);
            this.assertNotStopped();
            if (this.communicator == null) {
                throw new IllegalStateException("Must initialize the handler by reserving the port first.");
            }
            if (this.fileLockRequestListener == null) {
                this.fileLockRequestListener = this.executorFactory.create("File lock request listener");
                this.fileLockRequestListener.execute(this.listener());
            }
            if (this.unlockActionExecutor == null) {
                this.unlockActionExecutor = this.executorFactory.create("File lock release action executor");
            }
            if (this.contendedActions.containsKey(l2)) {
                throw new UnsupportedOperationException("Multiple contention actions for a given lock are currently not supported.");
            }
            this.contendedActions.put(l2, new ContendedAction(l2, consumer));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean maybePingOwner(int n2, long l2, String string, long l3, FileLockReleasedSignal fileLockReleasedSignal) {
        if (Integer.valueOf(n2).equals(this.unlocksConfirmedFrom.get(l2))) {
            return false;
        }
        if (Integer.valueOf(n2).equals(this.unlocksRequestedFrom.get(l2)) && l3 < 1000L) {
            return false;
        }
        boolean bl2 = this.getCommunicator().pingOwner(n2, l2, string);
        if (bl2) {
            this.lock.lock();
            try {
                this.unlocksRequestedFrom.put(l2, n2);
                this.lockReleasedSignals.put(l2, fileLockReleasedSignal);
            }
            finally {
                this.lock.unlock();
            }
        }
        return bl2;
    }

    private void assertNotStopped() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot start managing file contention because this handler has been closed.");
        }
    }

    @Override
    public void stop(long l2) {
        this.lock.lock();
        try {
            this.contendedActions.remove(l2);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            this.contendedActions.clear();
            if (this.communicator != null) {
                this.communicator.stop();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.fileLockRequestListener != null) {
            this.fileLockRequestListener.stop();
        }
        if (this.unlockActionExecutor != null) {
            this.unlockActionExecutor.stop();
        }
    }

    @Override
    public int reservePort() {
        return this.getCommunicator().getPort();
    }

    private FileLockCommunicator getCommunicator() {
        this.lock.lock();
        try {
            this.assertNotStopped();
            if (this.communicator == null) {
                this.communicator = new FileLockCommunicator(this.inetAddressProvider);
            }
            FileLockCommunicator fileLockCommunicator = this.communicator;
            return fileLockCommunicator;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class ContendedAction
    implements Runnable {
        private final Lock lock = new ReentrantLock();
        private final long lockId;
        private final Consumer<FileLockReleasedSignal> action;
        private Set<SocketAddress> requesters = new LinkedHashSet<SocketAddress>();
        private boolean running;

        private ContendedAction(long l2, Consumer<FileLockReleasedSignal> consumer) {
            this.lockId = l2;
            this.action = consumer;
        }

        @Override
        public void run() {
            this.action.accept(() -> {
                Set<SocketAddress> set = this.consumeRequesters();
                if (set == null) {
                    throw new IllegalStateException("trigger() has already been called and must at most be called once");
                }
                DefaultFileLockContentionHandler.this.communicator.confirmLockRelease(set, this.lockId);
            });
        }

        private void addRequester(SocketAddress socketAddress) {
            this.lock.lock();
            try {
                if (this.requesters != null) {
                    this.requesters.add(socketAddress);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private Set<SocketAddress> consumeRequesters() {
            this.lock.lock();
            try {
                Set<SocketAddress> set = this.requesters;
                return set;
            }
            finally {
                this.requesters = null;
                this.lock.unlock();
            }
        }
    }
}

