/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;

final class DTDWriter {
    final Writer mWriter;
    final boolean mIncludeComments;
    final boolean mIncludeConditionals;
    final boolean mIncludePEs;
    int mIsFlattening = 0;
    int mFlattenStart = 0;

    public DTDWriter(Writer writer, boolean bl2, boolean bl3, boolean bl4) {
        this.mWriter = writer;
        this.mIncludeComments = bl2;
        this.mIncludeConditionals = bl3;
        this.mIncludePEs = bl4;
        this.mIsFlattening = 1;
    }

    public boolean includeComments() {
        return this.mIncludeComments;
    }

    public boolean includeConditionals() {
        return this.mIncludeConditionals;
    }

    public boolean includeParamEntities() {
        return this.mIncludePEs;
    }

    public void disableOutput() {
        --this.mIsFlattening;
    }

    public void enableOutput(int n2) {
        ++this.mIsFlattening;
        this.mFlattenStart = n2;
    }

    public void setFlattenStart(int n2) {
        this.mFlattenStart = n2;
    }

    public int getFlattenStart() {
        return this.mFlattenStart;
    }

    public void flush(char[] cArray, int n2) throws XMLStreamException {
        if (this.mFlattenStart < n2) {
            if (this.mIsFlattening > 0) {
                try {
                    this.mWriter.write(cArray, this.mFlattenStart, n2 - this.mFlattenStart);
                }
                catch (IOException iOException) {
                    throw new WstxIOException(iOException);
                }
            }
            this.mFlattenStart = n2;
        }
    }

    public void output(String string) throws XMLStreamException {
        if (this.mIsFlattening > 0) {
            try {
                this.mWriter.write(string);
            }
            catch (IOException iOException) {
                throw new WstxIOException(iOException);
            }
        }
    }

    public void output(char c2) throws XMLStreamException {
        if (this.mIsFlattening > 0) {
            try {
                this.mWriter.write(c2);
            }
            catch (IOException iOException) {
                throw new WstxIOException(iOException);
            }
        }
    }
}

