/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.ObjectMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityObjectIntMap<K> {
    public int size;
    K[] keyTable;
    int[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;

    public IdentityObjectIntMap() {
        this(32, 0.8f);
    }

    public IdentityObjectIntMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if (this.capacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = ObjectMap.nextPowerOfTwo(n2);
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new int[this.keyTable.length];
    }

    public void put(K k2, int n2) {
        int n3;
        if (k2 == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.keyTable;
        int n4 = System.identityHashCode(k2);
        int n5 = n4 & this.mask;
        K k3 = KArray[n5];
        if (k2 == k3) {
            this.valueTable[n5] = n2;
            return;
        }
        int n6 = this.hash2(n4);
        K k4 = KArray[n6];
        if (k2 == k4) {
            this.valueTable[n6] = n2;
            return;
        }
        int n7 = this.hash3(n4);
        K k5 = KArray[n7];
        if (k2 == k5) {
            this.valueTable[n7] = n2;
            return;
        }
        int n8 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n8; ++n3) {
            if (KArray[n3] != k2) continue;
            this.valueTable[n3] = n2;
            return;
        }
        if (k3 == null) {
            KArray[n5] = k2;
            this.valueTable[n5] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k4 == null) {
            KArray[n6] = k2;
            this.valueTable[n6] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k5 == null) {
            KArray[n7] = k2;
            this.valueTable[n7] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k2, n2, n5, k3, n6, k4, n7, k5);
    }

    private void putResize(K k2, int n2) {
        int n3 = System.identityHashCode(k2);
        int n4 = n3 & this.mask;
        K k3 = this.keyTable[n4];
        if (k3 == null) {
            this.keyTable[n4] = k2;
            this.valueTable[n4] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash2(n3);
        K k4 = this.keyTable[n5];
        if (k4 == null) {
            this.keyTable[n5] = k2;
            this.valueTable[n5] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n6 = this.hash3(n3);
        K k5 = this.keyTable[n6];
        if (k5 == null) {
            this.keyTable[n6] = k2;
            this.valueTable[n6] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k2, n2, n4, k3, n5, k4, n6, k5);
    }

    private void push(K k2, int n2, int n3, K k3, int n4, K k4, int n5, K k5) {
        int n6;
        K k6;
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n7 = this.mask;
        int n8 = 0;
        int n9 = this.pushIterations;
        while (true) {
            switch (ObjectMap.random.nextInt(3)) {
                case 0: {
                    k6 = k3;
                    n6 = nArray[n3];
                    KArray[n3] = k2;
                    nArray[n3] = n2;
                    break;
                }
                case 1: {
                    k6 = k4;
                    n6 = nArray[n4];
                    KArray[n4] = k2;
                    nArray[n4] = n2;
                    break;
                }
                default: {
                    k6 = k5;
                    n6 = nArray[n5];
                    KArray[n5] = k2;
                    nArray[n5] = n2;
                }
            }
            int n10 = System.identityHashCode(k6);
            n3 = n10 & n7;
            k3 = KArray[n3];
            if (k3 == null) {
                KArray[n3] = k6;
                nArray[n3] = n6;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash2(n10);
            k4 = KArray[n4];
            if (k4 == null) {
                KArray[n4] = k6;
                nArray[n4] = n6;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n5 = this.hash3(n10);
            k5 = KArray[n5];
            if (k5 == null) {
                KArray[n5] = k6;
                nArray[n5] = n6;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n8 == n9) break;
            k2 = k6;
            n2 = n6;
        }
        this.putStash(k6, n6);
    }

    private void putStash(K k2, int n2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(k2, n2);
            return;
        }
        int n3 = this.capacity + this.stashSize;
        this.keyTable[n3] = k2;
        this.valueTable[n3] = n2;
        ++this.stashSize;
        ++this.size;
    }

    public int get(K k2, int n2) {
        int n3 = System.identityHashCode(k2);
        int n4 = n3 & this.mask;
        if (k2 != this.keyTable[n4] && k2 != this.keyTable[n4 = this.hash2(n3)] && k2 != this.keyTable[n4 = this.hash3(n3)]) {
            return this.getStash(k2, n2);
        }
        return this.valueTable[n4];
    }

    private int getStash(K k2, int n2) {
        int n3;
        K[] KArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (k2 != KArray[n3]) continue;
            return this.valueTable[n3];
        }
        return n2;
    }

    public void clear() {
        K[] KArray = this.keyTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            KArray[n2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        this.keyTable = new Object[n2 + this.stashCapacity];
        this.valueTable = new int[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                K k2 = KArray[i2];
                if (k2 == null) continue;
                this.putResize(k2, nArray[i2]);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public String toString() {
        K k2;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = KArray.length;
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n2]);
            break;
        }
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(", ");
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

