/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Joiner {
    private final String separator;

    public static Joiner on(String string) {
        return new Joiner(string);
    }

    public static Joiner on(char c2) {
        return new Joiner(String.valueOf(c2));
    }

    private Joiner(String string) {
        this.separator = Preconditions.checkNotNull(string);
    }

    private Joiner(Joiner joiner) {
        this.separator = joiner.separator;
    }

    public <A extends Appendable> A appendTo(A a2, Iterator<? extends Object> iterator) throws IOException {
        Preconditions.checkNotNull(a2);
        if (iterator.hasNext()) {
            a2.append(this.toString(iterator.next()));
            while (iterator.hasNext()) {
                a2.append(this.separator);
                a2.append(this.toString(iterator.next()));
            }
        }
        return a2;
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Iterator<? extends Object> iterator) {
        try {
            this.appendTo((Appendable)stringBuilder, iterator);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder;
    }

    public final String join(Iterable<? extends Object> iterable) {
        return this.join(iterable.iterator());
    }

    public final String join(Iterator<? extends Object> iterator) {
        return this.appendTo(new StringBuilder(), iterator).toString();
    }

    public final String join(Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return this.join(list);
    }

    public Joiner useForNull(final String string) {
        Preconditions.checkNotNull(string);
        return new Joiner(this, this){
            final /* synthetic */ Joiner this$0;
            {
                this.this$0 = joiner;
                super(joiner2);
            }

            @Override
            CharSequence toString(Object object) {
                return object == null ? string : this.this$0.toString(object);
            }

            @Override
            public Joiner useForNull(String string2) {
                throw new UnsupportedOperationException("already specified useForNull");
            }
        };
    }

    CharSequence toString(Object object) {
        Objects.requireNonNull(object);
        return object instanceof CharSequence ? (CharSequence)object : object.toString();
    }
}

