/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.NullnessCasts;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Objects;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Supplier;
import java.io.Serializable;

public final class Suppliers {
    public static <T> Supplier<T> memoize(Supplier<T> supplier) {
        if (supplier instanceof NonSerializableMemoizingSupplier || supplier instanceof MemoizingSupplier) {
            return supplier;
        }
        return supplier instanceof Serializable ? new MemoizingSupplier<T>(supplier) : new NonSerializableMemoizingSupplier<T>(supplier);
    }

    public static <T> Supplier<T> ofInstance(T t2) {
        return new SupplierOfInstance<T>(t2);
    }

    static class NonSerializableMemoizingSupplier<T>
    implements Supplier<T> {
        private final Object lock = new Object();
        private static final Supplier<Void> SUCCESSFULLY_COMPUTED = () -> {
            throw new IllegalStateException();
        };
        private volatile Supplier<T> delegate;
        private T value;

        NonSerializableMemoizingSupplier(Supplier<T> supplier) {
            this.delegate = Preconditions.checkNotNull(supplier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.delegate != SUCCESSFULLY_COMPUTED) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.delegate != SUCCESSFULLY_COMPUTED) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        this.delegate = SUCCESSFULLY_COMPUTED;
                        return t2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            Supplier<T> supplier = this.delegate;
            return "Suppliers.memoize(" + (supplier == SUCCESSFULLY_COMPUTED ? "<supplier that returned " + this.value + ">" : supplier) + ")";
        }
    }

    static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        private transient Object lock = new Object();
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;

        MemoizingSupplier(Supplier<T> supplier) {
            this.delegate = Preconditions.checkNotNull(supplier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.initialized) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        this.initialized = true;
                        return t2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            return "Suppliers.memoize(" + (this.initialized ? "<supplier that returned " + this.value + ">" : this.delegate) + ")";
        }
    }

    private static class SupplierOfInstance<T>
    implements Supplier<T>,
    Serializable {
        final T instance;

        SupplierOfInstance(T t2) {
            this.instance = t2;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public boolean equals(Object object) {
            if (object instanceof SupplierOfInstance) {
                SupplierOfInstance supplierOfInstance = (SupplierOfInstance)object;
                return Objects.equal(this.instance, supplierOfInstance.instance);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }

        public String toString() {
            return "Suppliers.ofInstance(" + this.instance + ")";
        }
    }
}

