/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterators;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import org.gradle.cache.internal.FilesFinder;

public class SingleDepthFilesFinder
implements FilesFinder {
    private final int depth;

    public SingleDepthFilesFinder(int n2) {
        Preconditions.checkArgument(n2 > 0, "depth must be > 0: %s", n2);
        this.depth = n2;
    }

    @Override
    public Iterable<File> find(final File file, final FileFilter fileFilter) {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new SingleDepthFileIterator(file, fileFilter);
            }
        };
    }

    private class SingleDepthFileIterator
    extends AbstractIterator<File> {
        private final Deque<Iterator<File>> stack = new ArrayDeque<Iterator<File>>();
        private final int targetSize;
        private final FileFilter filter;

        SingleDepthFileIterator(File file, FileFilter fileFilter) {
            this.stack.push(Iterators.singletonIterator(file));
            this.filter = fileFilter;
            this.targetSize = SingleDepthFilesFinder.this.depth + 1;
        }

        @Override
        protected File computeNext() {
            this.advanceIfNecessary();
            if (this.stack.isEmpty()) {
                return (File)this.endOfData();
            }
            return this.stack.getLast().next();
        }

        private void advanceIfNecessary() {
            while (!this.stack.isEmpty() && !this.hasNextWithCorrectDepth()) {
                if (this.stack.getLast().hasNext()) {
                    File file = this.stack.getLast().next();
                    this.stack.addLast(this.listFiles(file));
                    continue;
                }
                this.stack.removeLast();
            }
        }

        private boolean hasNextWithCorrectDepth() {
            return this.stack.size() == this.targetSize && this.stack.getLast().hasNext();
        }

        private Iterator<File> listFiles(File file) {
            File[] fileArray = file.listFiles(this.filter);
            return fileArray == null ? Collections.emptyIterator() : Iterators.forArray(fileArray);
        }
    }
}

