/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.maven.scan.extension.internal.api;

import com.gradle.develocity.DevelocityException;
import com.gradle.develocity.agent.maven.api.scan.BuildResult;
import com.gradle.develocity.agent.maven.api.scan.BuildScanApi;
import com.gradle.develocity.agent.maven.api.scan.BuildScanCaptureSettings;
import com.gradle.develocity.agent.maven.api.scan.BuildScanDataObfuscation;
import com.gradle.develocity.agent.maven.api.scan.BuildScanPublishing;
import com.gradle.develocity.agent.maven.api.scan.PublishedBuildScan;
import com.gradle.develocity.agent.maven.scan.extension.internal.a.a;
import com.gradle.develocity.agent.maven.scan.extension.internal.api.BuildScanApiInternal;
import com.gradle.maven.common.configuration.k;
import com.gradle.maven.common.configuration.model.PublishMode;
import com.gradle.maven.common.configuration.x;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.scan.plugin.internal.b.h.e;
import com.gradle.scan.plugin.internal.b.h.j;
import com.gradle.scan.plugin.internal.i.c;
import com.gradle.scan.plugin.internal.o.b;
import java.net.InetAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class DefaultBuildScanApi
implements BuildScanApiInternal {
    private static final String BACKGROUND_ERROR_MESSAGE = "Build scan background action failed";
    private final com.gradle.scan.plugin.internal.n.a.a backgroundExecController;
    private final e userDataCapturer;
    private final com.gradle.scan.plugin.internal.f.a.b eventClock;
    private final Consumer<Throwable> onBackgroundError;
    private final a userCallbacks;
    private final x.b configuration;
    private final BuildScanDataObfuscation buildScanDataObfuscation;
    private final BuildScanCaptureSettings buildScanCaptureSettings;
    private final DefaultBuildScanPublishing buildScanPublishing;
    private final Set<String> executedOnceIdentifiers = ConcurrentHashMap.newKeySet();
    private final com.gradle.scan.plugin.internal.i.a feedbackReporter;
    private volatile boolean locked;
    private volatile boolean buildFinished;

    public DefaultBuildScanApi(com.gradle.scan.plugin.internal.n.a.a a2, e e2, c c2, com.gradle.scan.plugin.internal.f.a.b b2, b b3, a a3, x.b b4, com.gradle.scan.plugin.internal.i.a a4) {
        this.backgroundExecController = a2;
        this.userDataCapturer = e2;
        this.eventClock = b2;
        this.onBackgroundError = throwable -> b3.a(() -> c2.c(BACKGROUND_ERROR_MESSAGE, (Throwable)throwable));
        this.userCallbacks = a3;
        this.configuration = b4;
        this.feedbackReporter = a4;
        this.buildScanDataObfuscation = new DefaultBuildScanDataObfuscation(a4, b4.getObfuscation());
        this.buildScanCaptureSettings = new DefaultBuildScanCaptureSettings(b4.getCapture());
        this.buildScanPublishing = new DefaultBuildScanPublishing(b4.getPublishing());
    }

    @Override
    public void tag(String string) {
        this.ifNotBuildFinished("BuildScanApi#tag()", () -> this.userDataCapturer.a(this.eventClock.b(), j.a(string)));
    }

    @Override
    public void value(String string, String string2) {
        this.ifNotBuildFinished("BuildScanApi#value()", () -> this.userDataCapturer.a(this.eventClock.b(), j.a(string, string2)));
    }

    @Override
    public void link(String string, String string2) {
        this.ifNotBuildFinished("BuildScanApi#link()", () -> this.userDataCapturer.a(this.eventClock.b(), j.b(string, string2)));
    }

    @Override
    public void background(Consumer<? super BuildScanApi> consumer) {
        this.ifNotBuildFinished("BuildScanApi#background()", () -> {
            if (!this.backgroundExecController.a(() -> consumer.accept(this), this.onBackgroundError)) {
                throw new DevelocityException("Could not use BuildScanApi#background() after the build has finished.");
            }
        });
    }

    @Override
    public void buildFinished(Consumer<? super BuildResult> consumer) {
        this.ifNotBuildFinished("BuildScanApi#buildFinished()", () -> this.userCallbacks.a.a((BuildResult)((Object)consumer)));
    }

    @Override
    public void buildScanPublished(Consumer<? super PublishedBuildScan> consumer) {
        this.ifNotBuildFinished("BuildScanApi#buildScanPublished()", () -> this.userCallbacks.b.a((PublishedBuildScan)((Object)consumer)));
    }

    @Override
    public void setTermsOfUseUrl(String string) {
        this.ifNotBuildFinished("BuildScanApi#setTermsOfUseUrl()", () -> this.configuration.getTermsOfUse().setUrl(URI.create(string)));
    }

    @Override
    public String getTermsOfUseUrl() {
        return DefaultBuildScanApi.nullSafeToString((URI)this.configuration.getTermsOfUse().getUrl().a);
    }

    @Override
    public void setTermsOfUseAgree(String string) {
        this.ifNotBuildFinished("BuildScanApi#setTermsOfUseAgree()", () -> this.configuration.getTermsOfUse().setAccept(string));
    }

    @Override
    public String getTermsOfUseAgree() {
        return (String)this.configuration.getTermsOfUse().getAccept().a;
    }

    @Override
    public void setServer(URI uRI) {
        this.ifNotLocked("BuildScanApi#setServer()", () -> this.configuration.getServer().setUrl(uRI));
    }

    @Override
    public String getServer() {
        return DefaultBuildScanApi.nullSafeToString(this.configuration.getServer().getUrl());
    }

    @Override
    public void setAllowUntrustedServer(boolean bl2) {
        this.ifNotBuildFinished("BuildScanApi#setAllowUntrustedServer()", () -> this.configuration.getServer().setAllowUntrusted(bl2));
    }

    @Override
    public boolean getAllowUntrustedServer() {
        return this.configuration.getServer().isAllowUntrusted();
    }

    public void publishAlways() {
        this.ifNotBuildFinished("BuildScanApi#publishAlways()", () -> this.setPublishMode(PublishMode.ALWAYS));
    }

    public void publishAlwaysIf(boolean bl2) {
        this.ifNotBuildFinished("BuildScanApi#publishAlwaysIf()", () -> {
            if (bl2) {
                this.setPublishMode(PublishMode.ALWAYS);
            } else {
                this.setPublishMode(PublishMode.ON_DEMAND);
            }
        });
    }

    public void publishOnFailure() {
        this.ifNotBuildFinished("BuildScanApi#publishOnFailure()", () -> this.setPublishMode(PublishMode.ON_FAILURE));
    }

    public void publishOnFailureIf(boolean bl2) {
        this.ifNotBuildFinished("BuildScanApi#publishOnFailureIf()", () -> {
            if (bl2) {
                this.setPublishMode(PublishMode.ON_FAILURE);
            } else {
                this.setPublishMode(PublishMode.ON_DEMAND);
            }
        });
    }

    public void publishOnDemand() {
        this.ifNotBuildFinished("BuildScanApi#publishOnDemand()", () -> this.setPublishMode(PublishMode.ON_DEMAND));
    }

    @Override
    public void setUploadInBackground(boolean bl2) {
        this.ifNotLocked("BuildScanApi#setUploadInBackground()", () -> this.configuration.setBackgroundBuildScanUpload(bl2));
    }

    @Override
    public boolean isUploadInBackground() {
        return this.configuration.isBackgroundBuildScanUpload();
    }

    public void publishIfAuthenticated() {
        this.ifNotBuildFinished("BuildScanApi#publishIfAuthenticated()", () -> this.configuration.setPublishIfAuthenticated(true));
    }

    public boolean isPublishIfAuthenticated() {
        return this.configuration.isPublishIfAuthenticated();
    }

    public void warnIfMissingAuthenticationRequired() {
        this.ifNotBuildFinished("BuildScanApi#warnIfMissingAuthenticationRequired()", () -> this.configuration.setWarnIfMissingAuthenticationRequired(true));
    }

    public boolean isWarnIfMissingAuthenticationRequired() {
        return this.configuration.isWarnIfMissingAuthenticationRequired();
    }

    @Override
    public void executeOnce(String string, Consumer<? super BuildScanApi> consumer) {
        this.ifNotBuildFinished("BuildScanApi#executeOnce()", () -> {
            if (this.executedOnceIdentifiers.add(string)) {
                consumer.accept(this);
            }
        });
    }

    @Override
    public BuildScanDataObfuscation getObfuscation() {
        return this.buildScanDataObfuscation;
    }

    @Override
    public void obfuscation(Consumer<? super BuildScanDataObfuscation> consumer) {
        this.ifNotBuildFinished("BuildScanApi#obfuscation()", () -> consumer.accept(this.getObfuscation()));
    }

    @Override
    public BuildScanCaptureSettings getCapture() {
        return this.buildScanCaptureSettings;
    }

    @Override
    public void capture(Consumer<? super BuildScanCaptureSettings> consumer) {
        this.ifNotBuildFinished("BuildScanApi#capture()", () -> consumer.accept(this.getCapture()));
    }

    @Override
    public BuildScanPublishing getPublishing() {
        return this.buildScanPublishing;
    }

    @Override
    public void publishing(Consumer<? super BuildScanPublishing> consumer) {
        this.ifNotBuildFinished("BuildScanApi#publishing()", () -> consumer.accept(this.getPublishing()));
    }

    @Override
    public void onError(Consumer<? super String> consumer) {
        this.ifNotBuildFinished("BuildScanApi#onError()", () -> this.userCallbacks.c.a((String)((Object)consumer)));
    }

    private void setPublishMode(PublishMode publishMode) {
        this.configuration.setPublishMode(publishMode);
    }

    private static String nullSafeToString(URI uRI) {
        return Optional.ofNullable(uRI).map(Object::toString).orElse(null);
    }

    public void lock() {
        this.locked = true;
    }

    public void buildFinished() {
        this.backgroundExecController.close();
        this.buildFinished = true;
    }

    private void ifNotLocked(String string, Runnable runnable) {
        if (this.locked) {
            throw new RuntimeException("'" + string + "' called after the Maven session has started.");
        }
        runnable.run();
    }

    private void ifNotBuildFinished(String string, Runnable runnable) {
        if (this.buildFinished) {
            this.feedbackReporter.c("\n" + string + " called after the build has finished.\nThe Develocity Maven extension cannot be used after the build has finished.\nThis method call will be ignored.");
        } else {
            runnable.run();
        }
    }

    private static class DefaultBuildScanDataObfuscation
    implements BuildScanDataObfuscation {
        private final com.gradle.scan.plugin.internal.n.c.e obfuscators;
        private final x.b.b configuration;

        DefaultBuildScanDataObfuscation(com.gradle.scan.plugin.internal.i.a a2, x.b.b b2) {
            this.obfuscators = new com.gradle.scan.plugin.internal.n.c.e(a2, false);
            this.configuration = b2;
        }

        @Override
        public void username(Function<? super String, ? extends String> function) {
            if (this.obfuscators.a().a((String)((Object)function)) != false) {
                this.configuration.setUsernameObfuscator(function);
            }
        }

        @Override
        public void hostname(Function<? super String, ? extends String> function) {
            if (this.obfuscators.b().a((String)((Object)function)) != false) {
                this.configuration.setHostnameObfuscator(function);
            }
        }

        @Override
        public void ipAddresses(Function<? super List<InetAddress>, ? extends List<String>> function) {
            if (this.obfuscators.c().a((List<InetAddress>)((Object)function)) != false) {
                this.configuration.setIpAddressesObfuscator(function);
            }
        }

        @Override
        public void externalProcessName(Function<? super String, ? extends String> function) {
            if (this.obfuscators.d().a((String)((Object)function)) != false) {
                this.configuration.setExternalProcessNameObfuscator(function);
            }
        }
    }

    private class DefaultBuildScanCaptureSettings
    implements BuildScanCaptureSettings {
        private final x.b.a configuration;

        DefaultBuildScanCaptureSettings(x.b.a a2) {
            this.configuration = a2;
        }

        @Override
        public void setFileFingerprints(boolean bl2) {
            DefaultBuildScanApi.this.ifNotLocked("BuildScanCaptureSettings#setFileFingerprints()", () -> this.configuration.setFileFingerprints(bl2));
        }

        @Override
        public boolean isFileFingerprints() {
            return this.configuration.isFileFingerprints();
        }

        @Override
        public void setBuildLogging(boolean bl2) {
            DefaultBuildScanApi.this.ifNotLocked("BuildScanCaptureSettings#setBuildLogging()", () -> this.configuration.setBuildLogging(bl2));
        }

        @Override
        public boolean isBuildLogging() {
            return this.configuration.isBuildLogging();
        }

        @Override
        public void setTestLogging(boolean bl2) {
            DefaultBuildScanApi.this.ifNotLocked("BuildScanCaptureSettings#setTestLogging()", () -> this.configuration.setTestLogging(bl2));
        }

        @Override
        public boolean isTestLogging() {
            return this.configuration.isTestLogging();
        }

        @Override
        public void setResourceUsage(boolean bl2) {
            DefaultBuildScanApi.this.ifNotLocked("BuildScanCaptureSettings#setResourceUsage()", () -> this.configuration.setResourceUsage(bl2));
        }

        @Override
        public boolean isResourceUsage() {
            return this.configuration.isResourceUsage();
        }
    }

    public class DefaultBuildScanPublishing
    implements BuildScanPublishing {
        private final x.b.c configuration;

        DefaultBuildScanPublishing(x.b.c c2) {
            this.configuration = c2;
        }

        @Override
        public BuildScanPublishing onlyIf(Predicate<BuildScanPublishing.PublishingContext> predicate) {
            DefaultBuildScanApi.this.ifNotBuildFinished("BuildScanPublishing#onlyIf()", () -> Optional.ofNullable(this.configuration).ifPresent(c2 -> c2.setOnlyIf(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.getOnlyIf())).add(predicate)).build())));
            return this;
        }

        private List<Predicate<BuildScanPublishing.PublishingContext>> getOnlyIf() {
            return Optional.ofNullable(this.configuration).map(k.b.c::getOnlyIf).orElse(Collections.emptyList());
        }
    }
}

