/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.KryoException;
import java.io.IOException;
import java.io.OutputStream;

public class Output
extends OutputStream {
    protected int maxCapacity;
    protected long total;
    protected int position;
    protected int capacity;
    protected byte[] buffer;
    protected OutputStream outputStream;

    public final int position() {
        return this.position;
    }

    protected boolean require(int n2) throws KryoException {
        if (this.capacity - this.position >= n2) {
            return false;
        }
        if (n2 > this.maxCapacity) {
            throw new KryoException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + n2);
        }
        this.flush();
        while (this.capacity - this.position < n2) {
            if (this.capacity == this.maxCapacity) {
                throw new KryoException("Buffer overflow. Available: " + (this.capacity - this.position) + ", required: " + n2);
            }
            if (this.capacity == 0) {
                this.capacity = 1;
            }
            this.capacity = Math.min(this.capacity * 2, this.maxCapacity);
            if (this.capacity < 0) {
                this.capacity = this.maxCapacity;
            }
            byte[] byArray = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, byArray, 0, this.position);
            this.buffer = byArray;
        }
        return true;
    }

    public void flush() throws KryoException {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.write(this.buffer, 0, this.position);
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
        this.total += (long)this.position;
        this.position = 0;
    }

    public void close() throws KryoException {
        this.flush();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void write(int n2) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)n2;
    }

    public void write(byte[] byArray) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws KryoException {
        this.writeBytes(byArray, n2, n3);
    }

    public void writeByte(byte by2) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = by2;
    }

    public void writeByte(int n2) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)n2;
    }

    public void writeBytes(byte[] byArray) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n2, int n3) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n4 = Math.min(this.capacity - this.position, n3);
        while (true) {
            System.arraycopy(byArray, n2, this.buffer, this.position, n4);
            this.position += n4;
            if ((n3 -= n4) == 0) {
                return;
            }
            n2 += n4;
            n4 = Math.min(this.capacity, n3);
            this.require(n4);
        }
    }

    public void writeInt(int n2) throws KryoException {
        this.require(4);
        byte[] byArray = this.buffer;
        byArray[this.position++] = (byte)(n2 >> 24);
        byArray[this.position++] = (byte)(n2 >> 16);
        byArray[this.position++] = (byte)(n2 >> 8);
        byArray[this.position++] = (byte)n2;
    }

    public int writeInt(int n2, boolean bl2) throws KryoException {
        return this.writeVarInt(n2, bl2);
    }

    public int writeVarInt(int n2, boolean bl2) throws KryoException {
        if (!bl2) {
            n2 = n2 << 1 ^ n2 >> 31;
        }
        if (n2 >>> 7 == 0) {
            this.require(1);
            this.buffer[this.position++] = (byte)n2;
            return 1;
        }
        if (n2 >>> 14 == 0) {
            this.require(2);
            this.buffer[this.position++] = (byte)(n2 & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(n2 >>> 7);
            return 2;
        }
        if (n2 >>> 21 == 0) {
            this.require(3);
            this.buffer[this.position++] = (byte)(n2 & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(n2 >>> 7 | 0x80);
            this.buffer[this.position++] = (byte)(n2 >>> 14);
            return 3;
        }
        if (n2 >>> 28 == 0) {
            this.require(4);
            this.buffer[this.position++] = (byte)(n2 & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(n2 >>> 7 | 0x80);
            this.buffer[this.position++] = (byte)(n2 >>> 14 | 0x80);
            this.buffer[this.position++] = (byte)(n2 >>> 21);
            return 4;
        }
        this.require(5);
        this.buffer[this.position++] = (byte)(n2 & 0x7F | 0x80);
        this.buffer[this.position++] = (byte)(n2 >>> 7 | 0x80);
        this.buffer[this.position++] = (byte)(n2 >>> 14 | 0x80);
        this.buffer[this.position++] = (byte)(n2 >>> 21 | 0x80);
        this.buffer[this.position++] = (byte)(n2 >>> 28);
        return 5;
    }

    public void writeString(String string) throws KryoException {
        int n2;
        if (string == null) {
            this.writeByte(128);
            return;
        }
        int n3 = string.length();
        if (n3 == 0) {
            this.writeByte(129);
            return;
        }
        boolean bl2 = false;
        if (n3 > 1 && n3 < 64) {
            bl2 = true;
            for (n2 = 0; n2 < n3; ++n2) {
                char c2 = string.charAt(n2);
                if (c2 <= '\u007f') continue;
                bl2 = false;
                break;
            }
        }
        if (bl2) {
            if (this.capacity - this.position < n3) {
                this.writeAscii_slow(string, n3);
            } else {
                string.getBytes(0, n3, this.buffer, this.position);
                this.position += n3;
            }
            int n4 = this.position - 1;
            this.buffer[n4] = (byte)(this.buffer[n4] | 0x80);
        } else {
            this.writeUtf8Length(n3 + 1);
            if (this.capacity - this.position >= n3) {
                char c3;
                byte[] byArray = this.buffer;
                int n5 = this.position;
                for (n2 = 0; n2 < n3 && (c3 = string.charAt(n2)) <= '\u007f'; ++n2) {
                    byArray[n5++] = (byte)c3;
                }
                this.position = n5;
            }
            if (n2 < n3) {
                this.writeString_slow(string, n3, n2);
            }
        }
    }

    public void writeString(CharSequence charSequence) throws KryoException {
        int n2;
        if (charSequence == null) {
            this.writeByte(128);
            return;
        }
        int n3 = charSequence.length();
        if (n3 == 0) {
            this.writeByte(129);
            return;
        }
        this.writeUtf8Length(n3 + 1);
        if (this.capacity - this.position >= n3) {
            char c2;
            byte[] byArray = this.buffer;
            int n4 = this.position;
            for (n2 = 0; n2 < n3 && (c2 = charSequence.charAt(n2)) <= '\u007f'; ++n2) {
                byArray[n4++] = (byte)c2;
            }
            this.position = n4;
        }
        if (n2 < n3) {
            this.writeString_slow(charSequence, n3, n2);
        }
    }

    private void writeUtf8Length(int n2) {
        if (n2 >>> 6 == 0) {
            this.require(1);
            this.buffer[this.position++] = (byte)(n2 | 0x80);
        } else if (n2 >>> 13 == 0) {
            this.require(2);
            byte[] byArray = this.buffer;
            byArray[this.position++] = (byte)(n2 | 0x40 | 0x80);
            byArray[this.position++] = (byte)(n2 >>> 6);
        } else if (n2 >>> 20 == 0) {
            this.require(3);
            byte[] byArray = this.buffer;
            byArray[this.position++] = (byte)(n2 | 0x40 | 0x80);
            byArray[this.position++] = (byte)(n2 >>> 6 | 0x80);
            byArray[this.position++] = (byte)(n2 >>> 13);
        } else if (n2 >>> 27 == 0) {
            this.require(4);
            byte[] byArray = this.buffer;
            byArray[this.position++] = (byte)(n2 | 0x40 | 0x80);
            byArray[this.position++] = (byte)(n2 >>> 6 | 0x80);
            byArray[this.position++] = (byte)(n2 >>> 13 | 0x80);
            byArray[this.position++] = (byte)(n2 >>> 20);
        } else {
            this.require(5);
            byte[] byArray = this.buffer;
            byArray[this.position++] = (byte)(n2 | 0x40 | 0x80);
            byArray[this.position++] = (byte)(n2 >>> 6 | 0x80);
            byArray[this.position++] = (byte)(n2 >>> 13 | 0x80);
            byArray[this.position++] = (byte)(n2 >>> 20 | 0x80);
            byArray[this.position++] = (byte)(n2 >>> 27);
        }
    }

    private void writeString_slow(CharSequence charSequence, int n2, int n3) {
        while (n3 < n2) {
            char c2;
            if (this.position == this.capacity) {
                this.require(Math.min(this.capacity, n2 - n3));
            }
            if ((c2 = charSequence.charAt(n3)) <= '\u007f') {
                this.buffer[this.position++] = (byte)c2;
            } else if (c2 > '\u07ff') {
                this.buffer[this.position++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                this.require(2);
                this.buffer[this.position++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                this.buffer[this.position++] = (byte)(0x80 | c2 & 0x3F);
            } else {
                this.buffer[this.position++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                this.require(1);
                this.buffer[this.position++] = (byte)(0x80 | c2 & 0x3F);
            }
            ++n3;
        }
    }

    private void writeAscii_slow(String string, int n2) throws KryoException {
        byte[] byArray = this.buffer;
        int n3 = 0;
        int n4 = Math.min(n2, this.capacity - this.position);
        while (n3 < n2) {
            string.getBytes(n3, n3 + n4, byArray, this.position);
            this.position += n4;
            if (!this.require(n4 = Math.min(n2 - (n3 += n4), this.capacity))) continue;
            byArray = this.buffer;
        }
    }

    public void writeFloat(float f2) throws KryoException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public void writeShort(int n2) throws KryoException {
        this.require(2);
        this.buffer[this.position++] = (byte)(n2 >>> 8);
        this.buffer[this.position++] = (byte)n2;
    }

    public void writeLong(long l2) throws KryoException {
        this.require(8);
        byte[] byArray = this.buffer;
        byArray[this.position++] = (byte)(l2 >>> 56);
        byArray[this.position++] = (byte)(l2 >>> 48);
        byArray[this.position++] = (byte)(l2 >>> 40);
        byArray[this.position++] = (byte)(l2 >>> 32);
        byArray[this.position++] = (byte)(l2 >>> 24);
        byArray[this.position++] = (byte)(l2 >>> 16);
        byArray[this.position++] = (byte)(l2 >>> 8);
        byArray[this.position++] = (byte)l2;
    }

    public int writeLong(long l2, boolean bl2) throws KryoException {
        return this.writeVarLong(l2, bl2);
    }

    public int writeVarLong(long l2, boolean bl2) throws KryoException {
        if (!bl2) {
            l2 = l2 << 1 ^ l2 >> 63;
        }
        if (l2 >>> 7 == 0L) {
            this.require(1);
            this.buffer[this.position++] = (byte)l2;
            return 1;
        }
        if (l2 >>> 14 == 0L) {
            this.require(2);
            this.buffer[this.position++] = (byte)(l2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 7);
            return 2;
        }
        if (l2 >>> 21 == 0L) {
            this.require(3);
            this.buffer[this.position++] = (byte)(l2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 14);
            return 3;
        }
        if (l2 >>> 28 == 0L) {
            this.require(4);
            this.buffer[this.position++] = (byte)(l2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 21);
            return 4;
        }
        if (l2 >>> 35 == 0L) {
            this.require(5);
            this.buffer[this.position++] = (byte)(l2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 28);
            return 5;
        }
        if (l2 >>> 42 == 0L) {
            this.require(6);
            this.buffer[this.position++] = (byte)(l2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 35);
            return 6;
        }
        if (l2 >>> 49 == 0L) {
            this.require(7);
            this.buffer[this.position++] = (byte)(l2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 35 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 42);
            return 7;
        }
        if (l2 >>> 56 == 0L) {
            this.require(8);
            this.buffer[this.position++] = (byte)(l2 & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 35 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 42 | 0x80L);
            this.buffer[this.position++] = (byte)(l2 >>> 49);
            return 8;
        }
        this.require(9);
        this.buffer[this.position++] = (byte)(l2 & 0x7FL | 0x80L);
        this.buffer[this.position++] = (byte)(l2 >>> 7 | 0x80L);
        this.buffer[this.position++] = (byte)(l2 >>> 14 | 0x80L);
        this.buffer[this.position++] = (byte)(l2 >>> 21 | 0x80L);
        this.buffer[this.position++] = (byte)(l2 >>> 28 | 0x80L);
        this.buffer[this.position++] = (byte)(l2 >>> 35 | 0x80L);
        this.buffer[this.position++] = (byte)(l2 >>> 42 | 0x80L);
        this.buffer[this.position++] = (byte)(l2 >>> 49 | 0x80L);
        this.buffer[this.position++] = (byte)(l2 >>> 56);
        return 9;
    }

    public void writeBoolean(boolean bl2) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)(bl2 ? 1 : 0);
    }

    public void writeChar(char c2) throws KryoException {
        this.require(2);
        this.buffer[this.position++] = (byte)(c2 >>> 8);
        this.buffer[this.position++] = (byte)c2;
    }

    public void writeDouble(double d2) throws KryoException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public void writeInts(int[] nArray, boolean bl2) throws KryoException {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeInt(nArray[i2], bl2);
        }
    }

    public void writeLongs(long[] lArray, boolean bl2) throws KryoException {
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeLong(lArray[i2], bl2);
        }
    }

    public void writeFloats(float[] fArray) throws KryoException {
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeFloat(fArray[i2]);
        }
    }

    public void writeShorts(short[] sArray) throws KryoException {
        int n2 = sArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeShort(sArray[i2]);
        }
    }

    public void writeChars(char[] cArray) throws KryoException {
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeChar(cArray[i2]);
        }
    }

    public void writeDoubles(double[] dArray) throws KryoException {
        int n2 = dArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeDouble(dArray[i2]);
        }
    }
}

