/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInboundHandlerAdapter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.Utf8Validator;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class Utf8FrameValidator
extends ChannelInboundHandlerAdapter {
    private final boolean closeOnProtocolViolation;
    private int fragmentedFramesCount;
    private Utf8Validator utf8Validator;

    public Utf8FrameValidator() {
        this(true);
    }

    public Utf8FrameValidator(boolean bl2) {
        this.closeOnProtocolViolation = bl2;
    }

    private static boolean isControlFrame(WebSocketFrame webSocketFrame) {
        return webSocketFrame instanceof CloseWebSocketFrame || webSocketFrame instanceof PingWebSocketFrame || webSocketFrame instanceof PongWebSocketFrame;
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof WebSocketFrame) {
            WebSocketFrame webSocketFrame = (WebSocketFrame)object;
            try {
                if (webSocketFrame.isFinalFragment()) {
                    if (!Utf8FrameValidator.isControlFrame(webSocketFrame)) {
                        this.fragmentedFramesCount = 0;
                        if (webSocketFrame instanceof TextWebSocketFrame || this.utf8Validator != null && this.utf8Validator.isChecking()) {
                            this.checkUTF8String(webSocketFrame.content());
                            this.utf8Validator.finish();
                        }
                    }
                } else {
                    if (this.fragmentedFramesCount == 0) {
                        if (webSocketFrame instanceof TextWebSocketFrame) {
                            this.checkUTF8String(webSocketFrame.content());
                        }
                    } else if (this.utf8Validator != null && this.utf8Validator.isChecking()) {
                        this.checkUTF8String(webSocketFrame.content());
                    }
                    ++this.fragmentedFramesCount;
                }
            }
            catch (CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
                this.protocolViolation(channelHandlerContext, webSocketFrame, corruptedWebSocketFrameException);
            }
        }
        super.channelRead(channelHandlerContext, object);
    }

    private void checkUTF8String(ByteBuf byteBuf) {
        if (this.utf8Validator == null) {
            this.utf8Validator = new Utf8Validator();
        }
        this.utf8Validator.check(byteBuf);
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
        webSocketFrame.release();
        if (this.closeOnProtocolViolation && channelHandlerContext.channel().isOpen()) {
            WebSocketCloseStatus webSocketCloseStatus = corruptedWebSocketFrameException.closeStatus();
            String string = corruptedWebSocketFrameException.getMessage();
            if (string == null) {
                string = webSocketCloseStatus.reasonText();
            }
            CloseWebSocketFrame closeWebSocketFrame = new CloseWebSocketFrame(webSocketCloseStatus.code(), string);
            channelHandlerContext.writeAndFlush(closeWebSocketFrame).addListener(ChannelFutureListener.CLOSE);
        }
        throw corruptedWebSocketFrameException;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        super.exceptionCaught(channelHandlerContext, throwable);
    }
}

