/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteIterators;
import java.util.AbstractCollection;
import java.util.Collection;

public abstract class AbstractByteCollection
extends AbstractCollection<Byte>
implements ByteCollection {
    protected AbstractByteCollection() {
    }

    @Override
    public abstract ByteIterator iterator();

    @Override
    public boolean add(byte by2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(byte by2) {
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            if (by2 != byteIterator.nextByte()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(byte by2) {
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            if (by2 != byteIterator.nextByte()) continue;
            byteIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Byte by2) {
        return ByteCollection.super.add(by2);
    }

    @Override
    @Deprecated
    public boolean contains(Object object) {
        return ByteCollection.super.contains(object);
    }

    @Override
    @Deprecated
    public boolean remove(Object object) {
        return ByteCollection.super.remove(object);
    }

    @Override
    public byte[] toByteArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return ByteArrays.EMPTY_ARRAY;
        }
        byte[] byArray = new byte[n2];
        ByteIterators.unwrap(this.iterator(), byArray);
        return byArray;
    }

    public boolean addAll(ByteCollection byteCollection) {
        boolean bl2 = false;
        ByteIterator byteIterator = byteCollection.iterator();
        while (byteIterator.hasNext()) {
            if (!this.add(byteIterator.nextByte())) continue;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Byte> collection) {
        if (collection instanceof ByteCollection) {
            return this.addAll((ByteCollection)collection);
        }
        return super.addAll(collection);
    }

    public boolean containsAll(ByteCollection byteCollection) {
        ByteIterator byteIterator = byteCollection.iterator();
        while (byteIterator.hasNext()) {
            if (this.contains(byteIterator.nextByte())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof ByteCollection) {
            return this.containsAll((ByteCollection)collection);
        }
        return super.containsAll(collection);
    }

    public boolean removeAll(ByteCollection byteCollection) {
        boolean bl2 = false;
        ByteIterator byteIterator = byteCollection.iterator();
        while (byteIterator.hasNext()) {
            if (!this.rem(byteIterator.nextByte())) continue;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection instanceof ByteCollection) {
            return this.removeAll((ByteCollection)collection);
        }
        return super.removeAll(collection);
    }

    public boolean retainAll(ByteCollection byteCollection) {
        boolean bl2 = false;
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            if (byteCollection.contains(byteIterator.nextByte())) continue;
            byteIterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection instanceof ByteCollection) {
            return this.retainAll((ByteCollection)collection);
        }
        return super.retainAll(collection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ByteIterator byteIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("{");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            byte by2 = byteIterator.nextByte();
            stringBuilder.append(String.valueOf(by2));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

