/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware;

import com.gradle.maven.extension.internal.dep.oshi.util.FileUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.Util;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface CentralProcessor {
    public List<LogicalProcessor> getLogicalProcessors();

    public double getSystemCpuLoadBetweenTicks(long[] var1);

    public long[] getSystemCpuLoadTicks();

    public static final class ProcessorIdentifier {
        private final String cpuVendor;
        private final String cpuName;
        private final String cpuFamily;
        private final String cpuModel;
        private final String cpuStepping;
        private final String processorID;
        private final String cpuIdentifier;
        private final boolean cpu64bit;
        private final long cpuVendorFreq;
        private final Supplier<String> microArchictecture = Memoizer.memoize(this::queryMicroarchitecture);

        public ProcessorIdentifier(String string, String string2, String string3, String string4, String string5, String string6, boolean bl2, long l2) {
            this.cpuVendor = string.startsWith("0x") ? this.queryVendorFromImplementer(string) : string;
            this.cpuName = string2;
            this.cpuFamily = string3;
            this.cpuModel = string4;
            this.cpuStepping = string5;
            this.processorID = string6;
            this.cpu64bit = bl2;
            StringBuilder stringBuilder = new StringBuilder();
            if (string.contentEquals("GenuineIntel")) {
                stringBuilder.append(bl2 ? "Intel64" : "x86");
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(" Family ").append(string3);
            stringBuilder.append(" Model ").append(string4);
            stringBuilder.append(" Stepping ").append(string5);
            this.cpuIdentifier = stringBuilder.toString();
            if (l2 > 0L) {
                this.cpuVendorFreq = l2;
            } else {
                Pattern pattern = Pattern.compile("@ (.*)$");
                Matcher matcher = pattern.matcher(string2);
                if (matcher.find()) {
                    String string7 = matcher.group(1);
                    this.cpuVendorFreq = ParseUtil.parseHertz(string7);
                } else {
                    this.cpuVendorFreq = -1L;
                }
            }
        }

        public String getName() {
            return this.cpuName;
        }

        public String getProcessorID() {
            return this.processorID;
        }

        public String getIdentifier() {
            return this.cpuIdentifier;
        }

        public long getVendorFreq() {
            return this.cpuVendorFreq;
        }

        public String getMicroarchitecture() {
            return this.microArchictecture.get();
        }

        private String queryMicroarchitecture() {
            String string = null;
            Properties properties = FileUtil.readPropertiesFromFilename("oshi.architecture.properties");
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = this.cpuVendor.toUpperCase(Locale.ROOT);
            if (string2.contains("AMD")) {
                stringBuilder.append("amd.");
            } else if (string2.contains("ARM")) {
                stringBuilder.append("arm.");
            } else if (string2.contains("IBM")) {
                int n2 = this.cpuName.indexOf("_POWER");
                if (n2 > 0) {
                    string = this.cpuName.substring(n2 + 1);
                }
            } else if (string2.contains("APPLE")) {
                stringBuilder.append("apple.");
            }
            if (Util.isBlank(string) && !stringBuilder.toString().equals("arm.")) {
                stringBuilder.append(this.cpuFamily);
                string = properties.getProperty(stringBuilder.toString());
            }
            if (Util.isBlank(string)) {
                stringBuilder.append('.').append(this.cpuModel);
                string = properties.getProperty(stringBuilder.toString());
            }
            if (Util.isBlank(string)) {
                stringBuilder.append('.').append(this.cpuStepping);
                string = properties.getProperty(stringBuilder.toString());
            }
            return Util.isBlank(string) ? "unknown" : string;
        }

        private String queryVendorFromImplementer(String string) {
            Properties properties = FileUtil.readPropertiesFromFilename("oshi.architecture.properties");
            return properties.getProperty("hw_impl." + string, string);
        }

        public String toString() {
            return this.getIdentifier();
        }
    }

    public static class ProcessorCache {
        private final byte level;
        private final byte associativity;
        private final short lineSize;
        private final int cacheSize;
        private final Type type;

        public ProcessorCache(byte by2, byte by3, short s2, int n2, Type type) {
            this.level = by2;
            this.associativity = by3;
            this.lineSize = s2;
            this.cacheSize = n2;
            this.type = type;
        }

        public ProcessorCache(int n2, int n3, int n4, long l2, Type type) {
            this((byte)n2, (byte)n3, (short)n4, (int)l2, type);
        }

        public byte getLevel() {
            return this.level;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "ProcessorCache [L" + this.level + " " + (Object)((Object)this.type) + ", cacheSize=" + this.cacheSize + ", " + (this.associativity > 0 ? this.associativity + "-way" : "unknown") + " associativity, lineSize=" + this.lineSize + "]";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof ProcessorCache)) {
                return false;
            }
            ProcessorCache processorCache = (ProcessorCache)object;
            return this.associativity == processorCache.associativity && this.cacheSize == processorCache.cacheSize && this.level == processorCache.level && this.lineSize == processorCache.lineSize && this.type == processorCache.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.associativity, this.cacheSize, this.level, this.lineSize, this.type});
        }

        public static enum Type {
            UNIFIED,
            INSTRUCTION,
            DATA,
            TRACE;


            public String toString() {
                return this.name().substring(0, 1) + this.name().substring(1).toLowerCase(Locale.ROOT);
            }
        }
    }

    public static class PhysicalProcessor {
        private final int physicalPackageNumber;
        private final int physicalProcessorNumber;
        private final int efficiency;
        private final String idString;

        public PhysicalProcessor(int n2, int n3) {
            this(n2, n3, 0, "");
        }

        public PhysicalProcessor(int n2, int n3, int n4, String string) {
            this.physicalPackageNumber = n2;
            this.physicalProcessorNumber = n3;
            this.efficiency = n4;
            this.idString = string;
        }

        public int getPhysicalPackageNumber() {
            return this.physicalPackageNumber;
        }

        public int getPhysicalProcessorNumber() {
            return this.physicalProcessorNumber;
        }

        public int getEfficiency() {
            return this.efficiency;
        }

        public String getIdString() {
            return this.idString;
        }

        public String toString() {
            return "PhysicalProcessor [package/core=" + this.physicalPackageNumber + "/" + this.physicalProcessorNumber + ", efficiency=" + this.efficiency + ", idString=" + this.idString + "]";
        }
    }

    public static class LogicalProcessor {
        private final int processorNumber;
        private final int physicalProcessorNumber;
        private final int physicalPackageNumber;
        private final int numaNode;
        private final int processorGroup;

        public LogicalProcessor(int n2, int n3, int n4) {
            this(n2, n3, n4, 0, 0);
        }

        public LogicalProcessor(int n2, int n3, int n4, int n5) {
            this(n2, n3, n4, n5, 0);
        }

        public LogicalProcessor(int n2, int n3, int n4, int n5, int n6) {
            this.processorNumber = n2;
            this.physicalProcessorNumber = n3;
            this.physicalPackageNumber = n4;
            this.numaNode = n5;
            this.processorGroup = n6;
        }

        public int getProcessorNumber() {
            return this.processorNumber;
        }

        public int getPhysicalProcessorNumber() {
            return this.physicalProcessorNumber;
        }

        public int getPhysicalPackageNumber() {
            return this.physicalPackageNumber;
        }

        public int getNumaNode() {
            return this.numaNode;
        }

        public String toString() {
            return "LogicalProcessor [processorNumber=" + this.processorNumber + ", coreNumber=" + this.physicalProcessorNumber + ", packageNumber=" + this.physicalPackageNumber + ", numaNode=" + this.numaNode + ", processorGroup=" + this.processorGroup + "]";
        }
    }

    public static enum TickType {
        USER(0),
        NICE(1),
        SYSTEM(2),
        IDLE(3),
        IOWAIT(4),
        IRQ(5),
        SOFTIRQ(6),
        STEAL(7);

        private final int index;

        private TickType(int n3) {
            this.index = n3;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

