/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.DefaultPersistentDirectoryCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;

public class DefaultCacheFactory
implements Closeable,
CacheFactory {
    private final Map<File, DirCacheReference> dirCaches = new HashMap<File, DirCacheReference>();
    private final FileLockManager lockManager;
    private final ExecutorFactory executorFactory;
    private final Lock lock = new ReentrantLock();

    public DefaultCacheFactory(FileLockManager fileLockManager, ExecutorFactory executorFactory) {
        this.lockManager = fileLockManager;
        this.executorFactory = executorFactory;
    }

    void onOpen(Object object) {
    }

    void onClose(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentCache open(File file, String string, Map<String, ?> map, LockOptions lockOptions, Consumer<? super PersistentCache> consumer, CacheCleanupStrategy cacheCleanupStrategy) throws CacheOpenException {
        this.lock.lock();
        try {
            PersistentCache persistentCache = this.doOpen(file, string, map, lockOptions, consumer, cacheCleanupStrategy);
            return persistentCache;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            CompositeStoppable.stoppable(this.dirCaches.values()).stop();
        }
        finally {
            this.dirCaches.clear();
            this.lock.unlock();
        }
    }

    private PersistentCache doOpen(File file, String string, Map<String, ?> map, LockOptions lockOptions, Consumer<? super PersistentCache> consumer, CacheCleanupStrategy cacheCleanupStrategy) {
        DirCacheReference dirCacheReference = this.dirCaches.get(file);
        if (dirCacheReference == null) {
            DefaultPersistentDirectoryStore defaultPersistentDirectoryStore;
            if (!map.isEmpty() || consumer != null) {
                Consumer<? super PersistentCache> consumer2 = consumer != null ? consumer : persistentCache -> {};
                defaultPersistentDirectoryStore = new DefaultPersistentDirectoryCache(file, string, map, lockOptions, consumer2, cacheCleanupStrategy, this.lockManager, this.executorFactory);
            } else {
                defaultPersistentDirectoryStore = new DefaultPersistentDirectoryStore(file, string, lockOptions, cacheCleanupStrategy, this.lockManager, this.executorFactory);
            }
            defaultPersistentDirectoryStore.open();
            dirCacheReference = new DirCacheReference(defaultPersistentDirectoryStore, map, lockOptions);
            this.dirCaches.put(file, dirCacheReference);
        } else {
            if (!lockOptions.equals(dirCacheReference.lockOptions)) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different lock options.", file));
            }
            if (!map.equals(dirCacheReference.properties)) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different properties.", file));
            }
        }
        return new ReferenceTrackingCache(dirCacheReference);
    }

    private class DirCacheReference
    implements Closeable {
        private final Map<String, ?> properties;
        private final LockOptions lockOptions;
        private final ReferencablePersistentCache cache;
        private final Set<ReferenceTrackingCache> references = new HashSet<ReferenceTrackingCache>();

        DirCacheReference(ReferencablePersistentCache referencablePersistentCache, Map<String, ?> map, LockOptions lockOptions) {
            this.cache = referencablePersistentCache;
            this.properties = map;
            this.lockOptions = lockOptions;
            DefaultCacheFactory.this.onOpen(referencablePersistentCache);
        }

        public void addReference(ReferenceTrackingCache referenceTrackingCache) {
            this.references.add(referenceTrackingCache);
        }

        public void release(ReferenceTrackingCache referenceTrackingCache) {
            DefaultCacheFactory.this.lock.lock();
            try {
                if (this.references.remove(referenceTrackingCache) && this.references.isEmpty()) {
                    this.close();
                }
            }
            finally {
                DefaultCacheFactory.this.lock.unlock();
            }
        }

        @Override
        public void close() {
            DefaultCacheFactory.this.onClose(this.cache);
            DefaultCacheFactory.this.dirCaches.values().remove(this);
            this.references.clear();
            this.cache.close();
        }
    }

    private static class ReferenceTrackingCache
    implements PersistentCache {
        private final DirCacheReference reference;

        private ReferenceTrackingCache(DirCacheReference dirCacheReference) {
            this.reference = dirCacheReference;
            dirCacheReference.addReference(this);
        }

        public String toString() {
            return this.reference.cache.toString();
        }

        @Override
        public void close() {
            this.reference.release(this);
        }

        @Override
        public String getDisplayName() {
            return this.reference.cache.toString();
        }

        @Override
        public File getBaseDir() {
            return this.reference.cache.getBaseDir();
        }

        @Override
        public Collection<File> getReservedCacheFiles() {
            return this.reference.cache.getReservedCacheFiles();
        }

        @Override
        public void withFileLock(Runnable runnable) {
            this.reference.cache.withFileLock(runnable);
        }

        @Override
        public void useCache(Runnable runnable) {
            this.reference.cache.useCache(runnable);
        }
    }
}

