/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ConcatModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ContentSpec;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ModelNode;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.OptionalModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.StarModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.StructValidator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.TokenModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;

public class TokenContentSpec
extends ContentSpec {
    static final TokenContentSpec sDummy = new TokenContentSpec(' ', new PrefixedName("*", "*"));
    final PrefixedName mElemName;

    public TokenContentSpec(char c2, PrefixedName prefixedName) {
        super(c2);
        this.mElemName = prefixedName;
    }

    public static TokenContentSpec construct(char c2, PrefixedName prefixedName) {
        return new TokenContentSpec(c2, prefixedName);
    }

    public static TokenContentSpec getDummySpec() {
        return sDummy;
    }

    @Override
    public boolean isLeaf() {
        return this.mArity == ' ';
    }

    public PrefixedName getName() {
        return this.mElemName;
    }

    @Override
    public StructValidator getSimpleValidator() {
        return new Validator(this.mArity, this.mElemName);
    }

    @Override
    public ModelNode rewrite() {
        TokenModel tokenModel = new TokenModel(this.mElemName);
        if (this.mArity == '*') {
            return new StarModel(tokenModel);
        }
        if (this.mArity == '?') {
            return new OptionalModel(tokenModel);
        }
        if (this.mArity == '+') {
            return new ConcatModel(tokenModel, new StarModel(new TokenModel(this.mElemName)));
        }
        return tokenModel;
    }

    public String toString() {
        return this.mArity == ' ' ? this.mElemName.toString() : this.mElemName.toString() + this.mArity;
    }

    static final class Validator
    extends StructValidator {
        final char mArity;
        final PrefixedName mElemName;
        int mCount = 0;

        public Validator(char c2, PrefixedName prefixedName) {
            this.mArity = c2;
            this.mElemName = prefixedName;
        }

        @Override
        public StructValidator newInstance() {
            return this.mArity == '*' ? this : new Validator(this.mArity, this.mElemName);
        }

        @Override
        public String tryToValidate(PrefixedName prefixedName) {
            if (!prefixedName.equals(this.mElemName)) {
                return "Expected element <" + this.mElemName + ">";
            }
            if (++this.mCount > 1 && (this.mArity == '?' || this.mArity == ' ')) {
                return "More than one instance of element <" + this.mElemName + ">";
            }
            return null;
        }

        @Override
        public String fullyValid() {
            switch (this.mArity) {
                case '*': 
                case '?': {
                    return null;
                }
                case ' ': 
                case '+': {
                    if (this.mCount > 0) {
                        return null;
                    }
                    return "Expected " + (this.mArity == '+' ? "at least one" : "") + " element <" + this.mElemName + ">";
                }
            }
            throw new IllegalStateException(ErrorConsts.ERR_INTERNAL);
        }
    }
}

