/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelNode;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Literal;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;

public class InlineList
extends SpelNodeImpl {
    private TypedValue constant;

    public InlineList(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super(n2, n3, spelNodeImplArray);
        this.checkIfConstant();
    }

    private void checkIfConstant() {
        SpelNode spelNode;
        boolean bl2 = true;
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            SpelNode spelNode2 = this.getChild(i2);
            if (spelNode2 instanceof Literal) continue;
            if (spelNode2 instanceof InlineList) {
                spelNode = (InlineList)spelNode2;
                if (((InlineList)spelNode).isConstant()) continue;
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            n2 = this.getChildCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                spelNode = this.getChild(i3);
                if (spelNode instanceof Literal) {
                    arrayList.add(((Literal)spelNode).getLiteralValue().getValue());
                    continue;
                }
                if (!(spelNode instanceof InlineList)) continue;
                arrayList.add(((InlineList)spelNode).getConstantValue());
            }
            this.constant = new TypedValue(Collections.unmodifiableList(arrayList));
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.constant != null) {
            return this.constant;
        }
        int n2 = this.getChildCount();
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(this.getChild(i2).getValue(expressionState));
        }
        return new TypedValue(arrayList);
    }

    @Override
    public String toStringAST() {
        StringJoiner stringJoiner = new StringJoiner(",", "{", "}");
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringJoiner.add(this.getChild(i2).toStringAST());
        }
        return stringJoiner.toString();
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    public List<Object> getConstantValue() {
        Assert.state(this.constant != null, "No constant");
        return (List)this.constant.getValue();
    }

    @Override
    public boolean isCompilable() {
        return this.isConstant();
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor2, CodeFlow codeFlow2) {
        String string = "inlineList$" + codeFlow2.nextFieldId();
        String string2 = codeFlow2.getClassName();
        codeFlow2.registerNewField((classWriter, codeFlow) -> classWriter.visitField(26, string, "Ljava/util/List;", null, null));
        codeFlow2.registerNewClinit((methodVisitor, codeFlow) -> this.generateClinitCode(string2, string, methodVisitor, codeFlow, false));
        methodVisitor2.visitFieldInsn(178, string2, string, "Ljava/util/List;");
        codeFlow2.pushDescriptor("Ljava/util/List");
    }

    void generateClinitCode(String string, String string2, MethodVisitor methodVisitor, CodeFlow codeFlow, boolean bl2) {
        methodVisitor.visitTypeInsn(187, "java/util/ArrayList");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        if (!bl2) {
            methodVisitor.visitFieldInsn(179, string, string2, "Ljava/util/List;");
        }
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!bl2) {
                methodVisitor.visitFieldInsn(178, string, string2, "Ljava/util/List;");
            } else {
                methodVisitor.visitInsn(89);
            }
            if (this.children[i2] instanceof InlineList) {
                ((InlineList)this.children[i2]).generateClinitCode(string, string2, methodVisitor, codeFlow, true);
            } else {
                this.children[i2].generateCode(methodVisitor, codeFlow);
                String string3 = codeFlow.lastDescriptor();
                if (CodeFlow.isPrimitive(string3)) {
                    CodeFlow.insertBoxIfNecessary(methodVisitor, string3.charAt(0));
                }
            }
            methodVisitor.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
            methodVisitor.visitInsn(87);
        }
    }
}

