/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.software.os.linux;

import com.gradle.maven.extension.internal.dep.oshi.driver.linux.proc.Auxv;
import com.gradle.maven.extension.internal.dep.oshi.driver.linux.proc.CpuStat;
import com.gradle.maven.extension.internal.dep.oshi.driver.linux.proc.ProcessStat;
import com.gradle.maven.extension.internal.dep.oshi.driver.linux.proc.UpTime;
import com.gradle.maven.extension.internal.dep.oshi.jna.platform.linux.LinuxLibc;
import com.gradle.maven.extension.internal.dep.oshi.software.common.AbstractOperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.software.os.OSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.OperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.software.os.linux.LinuxOSProcess;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.FileUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.GlobalConfig;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.linux.ProcPath;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Pair;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Triplet;
import com.sun.jna.platform.linux.Udev;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxOperatingSystem.class);
    public static final boolean HAS_UDEV;
    public static final boolean HAS_GETTID;
    public static final boolean HAS_SYSCALL_GETTID;
    private static final long USER_HZ;
    private static final long PAGE_SIZE;
    private static final String OS_NAME;
    static final long BOOTTIME;
    private static final int[] PPID_INDEX;

    @Override
    public String queryManufacturer() {
        return OS_NAME;
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        Object object;
        Triplet<String, String, String> triplet = LinuxOperatingSystem.queryFamilyVersionCodenameFromReleaseFiles();
        String string = null;
        List<String> list = FileUtil.readFile(ProcPath.VERSION);
        if (!list.isEmpty()) {
            for (String string2 : object = ParseUtil.whitespaces.split(list.get(0))) {
                if ("Linux".equals(string2) || "version".equals(string2)) continue;
                string = string2;
                break;
            }
        }
        object = new OperatingSystem.OSVersionInfo(triplet.getB(), triplet.getC(), string);
        return new Pair<String, String[]>(triplet.getA(), (String[])object);
    }

    @Override
    protected int queryBitness(int n2) {
        if (n2 < 64 && !ExecutingCommand.getFirstAnswer("uname -m").contains("64")) {
            return n2;
        }
        return 64;
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.queryChildProcesses(-1);
    }

    public List<OSProcess> queryChildProcesses(int n2) {
        File[] fileArray = ProcessStat.getPidFiles();
        if (n2 >= 0) {
            return this.queryProcessList(LinuxOperatingSystem.getChildrenOrDescendants(LinuxOperatingSystem.getParentPidsFromProcFiles(fileArray), n2, false));
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (File file : fileArray) {
            int n3 = ParseUtil.parseIntOrDefault(file.getName(), -2);
            if (n3 == -2) continue;
            hashSet.add(n3);
        }
        return this.queryProcessList(hashSet);
    }

    private List<OSProcess> queryProcessList(Set<Integer> set) {
        ArrayList<OSProcess> arrayList = new ArrayList<OSProcess>();
        for (int n2 : set) {
            LinuxOSProcess linuxOSProcess = new LinuxOSProcess(n2, this);
            if (linuxOSProcess.getState().equals((Object)OSProcess.State.INVALID)) continue;
            arrayList.add(linuxOSProcess);
        }
        return arrayList;
    }

    private static Map<Integer, Integer> getParentPidsFromProcFiles(File[] fileArray) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (File file : fileArray) {
            int n2 = ParseUtil.parseIntOrDefault(file.getName(), 0);
            hashMap.put(n2, LinuxOperatingSystem.getParentPidFromProcFile(n2));
        }
        return hashMap;
    }

    private static int getParentPidFromProcFile(int n2) {
        String string = FileUtil.getStringFromFile(String.format(Locale.ROOT, "/proc/%d/stat", n2));
        if (string.isEmpty()) {
            return 0;
        }
        long[] lArray = ParseUtil.parseStringToLongArray(string, PPID_INDEX, ProcessStat.PROC_PID_STAT_LENGTH, ' ');
        return (int)lArray[0];
    }

    @Override
    public int getProcessId() {
        return LinuxLibc.INSTANCE.getpid();
    }

    private static Triplet<String, String, String> queryFamilyVersionCodenameFromReleaseFiles() {
        Triplet<String, String, String> triplet = LinuxOperatingSystem.readDistribRelease("/etc/system-release");
        if (triplet != null) {
            return triplet;
        }
        triplet = LinuxOperatingSystem.readOsRelease();
        if (triplet != null) {
            return triplet;
        }
        triplet = LinuxOperatingSystem.execLsbRelease();
        if (triplet != null) {
            return triplet;
        }
        triplet = LinuxOperatingSystem.readLsbRelease();
        if (triplet != null) {
            return triplet;
        }
        String string = LinuxOperatingSystem.getReleaseFilename();
        triplet = LinuxOperatingSystem.readDistribRelease(string);
        if (triplet != null) {
            return triplet;
        }
        String string2 = LinuxOperatingSystem.filenameToFamily(string.replace("/etc/", "").replace("release", "").replace("version", "").replace("-", "").replace("_", ""));
        return new Triplet<String, String, String>(string2, "unknown", "unknown");
    }

    private static Triplet<String, String, String> readOsRelease() {
        String string = null;
        String string2 = "unknown";
        String string3 = "unknown";
        List<String> list = FileUtil.readFile("/etc/os-release");
        for (String string4 : list) {
            if (string4.startsWith("VERSION=")) {
                LOG.debug("os-release: {}", (Object)string4);
                string4 = string4.replace("VERSION=", "").replaceAll("(?:^\")|(?:\"$)", "").trim();
                String[] stringArray = string4.split("[()]");
                if (stringArray.length <= 1) {
                    stringArray = string4.split(", ");
                }
                if (stringArray.length > 0) {
                    string2 = stringArray[0].trim();
                }
                if (stringArray.length <= 1) continue;
                string3 = stringArray[1].trim();
                continue;
            }
            if (string4.startsWith("NAME=") && string == null) {
                LOG.debug("os-release: {}", (Object)string4);
                string = string4.replace("NAME=", "").replaceAll("(?:^\")|(?:\"$)", "").trim();
                continue;
            }
            if (!string4.startsWith("VERSION_ID=") || !string2.equals("unknown")) continue;
            LOG.debug("os-release: {}", (Object)string4);
            string2 = string4.replace("VERSION_ID=", "").replaceAll("(?:^\")|(?:\"$)", "").trim();
        }
        return string == null ? null : new Triplet<Object, String, String>(string, string2, string3);
    }

    private static Triplet<String, String, String> execLsbRelease() {
        String string = null;
        String string2 = "unknown";
        String string3 = "unknown";
        for (String string4 : ExecutingCommand.runNative("lsb_release -a")) {
            if (string4.startsWith("Description:")) {
                LOG.debug("lsb_release -a: {}", (Object)string4);
                if (!(string4 = string4.replace("Description:", "").trim()).contains(" release ")) continue;
                Triplet<String, String, String> triplet = LinuxOperatingSystem.parseRelease(string4, " release ");
                string = triplet.getA();
                if (string2.equals("unknown")) {
                    string2 = triplet.getB();
                }
                if (!string3.equals("unknown")) continue;
                string3 = triplet.getC();
                continue;
            }
            if (string4.startsWith("Distributor ID:") && string == null) {
                LOG.debug("lsb_release -a: {}", (Object)string4);
                string = string4.replace("Distributor ID:", "").trim();
                continue;
            }
            if (string4.startsWith("Release:") && string2.equals("unknown")) {
                LOG.debug("lsb_release -a: {}", (Object)string4);
                string2 = string4.replace("Release:", "").trim();
                continue;
            }
            if (!string4.startsWith("Codename:") || !string3.equals("unknown")) continue;
            LOG.debug("lsb_release -a: {}", (Object)string4);
            string3 = string4.replace("Codename:", "").trim();
        }
        return string == null ? null : new Triplet<Object, String, String>(string, string2, string3);
    }

    private static Triplet<String, String, String> readLsbRelease() {
        String string = null;
        String string2 = "unknown";
        String string3 = "unknown";
        List<String> list = FileUtil.readFile("/etc/lsb-release");
        for (String string4 : list) {
            if (string4.startsWith("DISTRIB_DESCRIPTION=")) {
                LOG.debug("lsb-release: {}", (Object)string4);
                if (!(string4 = string4.replace("DISTRIB_DESCRIPTION=", "").replaceAll("(?:^\")|(?:\"$)", "").trim()).contains(" release ")) continue;
                Triplet<String, String, String> triplet = LinuxOperatingSystem.parseRelease(string4, " release ");
                string = triplet.getA();
                if (string2.equals("unknown")) {
                    string2 = triplet.getB();
                }
                if (!string3.equals("unknown")) continue;
                string3 = triplet.getC();
                continue;
            }
            if (string4.startsWith("DISTRIB_ID=") && string == null) {
                LOG.debug("lsb-release: {}", (Object)string4);
                string = string4.replace("DISTRIB_ID=", "").replaceAll("(?:^\")|(?:\"$)", "").trim();
                continue;
            }
            if (string4.startsWith("DISTRIB_RELEASE=") && string2.equals("unknown")) {
                LOG.debug("lsb-release: {}", (Object)string4);
                string2 = string4.replace("DISTRIB_RELEASE=", "").replaceAll("(?:^\")|(?:\"$)", "").trim();
                continue;
            }
            if (!string4.startsWith("DISTRIB_CODENAME=") || !string3.equals("unknown")) continue;
            LOG.debug("lsb-release: {}", (Object)string4);
            string3 = string4.replace("DISTRIB_CODENAME=", "").replaceAll("(?:^\")|(?:\"$)", "").trim();
        }
        return string == null ? null : new Triplet<Object, String, String>(string, string2, string3);
    }

    private static Triplet<String, String, String> readDistribRelease(String string) {
        if (new File(string).exists()) {
            List<String> list = FileUtil.readFile(string);
            for (String string2 : list) {
                LOG.debug("{}: {}", (Object)string, (Object)string2);
                if (string2.contains(" release ")) {
                    return LinuxOperatingSystem.parseRelease(string2, " release ");
                }
                if (!string2.contains(" VERSION ")) continue;
                return LinuxOperatingSystem.parseRelease(string2, " VERSION ");
            }
        }
        return null;
    }

    private static Triplet<String, String, String> parseRelease(String string, String string2) {
        String[] stringArray = string.split(string2);
        String string3 = stringArray[0].trim();
        String string4 = "unknown";
        String string5 = "unknown";
        if (stringArray.length > 1) {
            if ((stringArray = stringArray[1].split("[()]")).length > 0) {
                string4 = stringArray[0].trim();
            }
            if (stringArray.length > 1) {
                string5 = stringArray[1].trim();
            }
        }
        return new Triplet<String, String, String>(string3, string4, string5);
    }

    protected static String getReleaseFilename() {
        File file2 = new File("/etc");
        File[] fileArray = file2.listFiles(file -> (file.getName().endsWith("-release") || file.getName().endsWith("-version") || file.getName().endsWith("_release") || file.getName().endsWith("_version")) && !file.getName().endsWith("os-release") && !file.getName().endsWith("lsb-release") && !file.getName().endsWith("system-release"));
        if (fileArray != null && fileArray.length > 0) {
            return fileArray[0].getPath();
        }
        if (new File("/etc/release").exists()) {
            return "/etc/release";
        }
        return "/etc/issue";
    }

    private static String filenameToFamily(String string) {
        if (string.isEmpty()) {
            return "Solaris";
        }
        if ("issue".equalsIgnoreCase(string)) {
            return "Unknown";
        }
        Properties properties = FileUtil.readPropertiesFromFilename("oshi.linux.filename.properties");
        String string2 = properties.getProperty(string.toLowerCase(Locale.ROOT));
        return string2 != null ? string2 : string.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1);
    }

    public static long getHz() {
        return USER_HZ;
    }

    public static long getPageSize() {
        return PAGE_SIZE;
    }

    static {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            if (GlobalConfig.get("com.gradle.maven.extension.internal.dep.oshi.os.linux.allowudev", true)) {
                try {
                    Udev udev = Udev.INSTANCE;
                    bl2 = true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    LOG.warn("Did not find udev library in operating system. Some features may not work.");
                }
            } else {
                LOG.info("Loading of udev not allowed by configuration. Some features may not work.");
            }
            try {
                LinuxLibc.INSTANCE.gettid();
                bl3 = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                LOG.debug("Did not find gettid function in operating system. Using fallbacks.");
            }
            bl4 = bl3;
            if (!bl3) {
                try {
                    bl4 = LinuxLibc.INSTANCE.syscall(LinuxLibc.SYS_GETTID, new Object[0]).intValue() > 0;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    LOG.debug("Did not find working syscall gettid function in operating system. Using procfs");
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LOG.error("Did not JNA classes. Investigate incompatible version or missing native dll.");
        }
        HAS_UDEV = bl2;
        HAS_GETTID = bl3;
        HAS_SYSCALL_GETTID = bl4;
        Map<Integer, Long> map = Auxv.queryAuxv();
        long l2 = map.getOrDefault(17, 0L);
        USER_HZ = l2 > 0L ? l2 : ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf CLK_TCK"), 100L);
        long l3 = Auxv.queryAuxv().getOrDefault(6, 0L);
        PAGE_SIZE = l3 > 0L ? l3 : ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf PAGE_SIZE"), 4096L);
        OS_NAME = ExecutingCommand.getFirstAnswer("uname -o");
        long l4 = CpuStat.getBootTime();
        if (l4 == 0L) {
            l4 = System.currentTimeMillis() / 1000L - (long)UpTime.getSystemUptimeSeconds();
        }
        BOOTTIME = l4;
        PPID_INDEX = new int[]{3};
    }
}

