/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.PayloadImpl;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Payload;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.TypeReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class PayloadDeserializer
extends StdDeserializer<Payload> {
    PayloadDeserializer() {
        super(Payload.class);
    }

    @Override
    public Payload deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Map<String, JsonNode> map = jsonParser.getCodec().readValue(jsonParser, new TypeReference<Map<String, JsonNode>>(){});
        if (map == null) {
            throw new JWTDecodeException("Parsing the Payload's JSON resulted on a Null map");
        }
        String string = this.getString(map, "iss");
        String string2 = this.getString(map, "sub");
        List<String> list = this.getStringOrArray(jsonParser.getCodec(), map, "aud");
        Instant instant = this.getInstantFromSeconds(map, "exp");
        Instant instant2 = this.getInstantFromSeconds(map, "nbf");
        Instant instant3 = this.getInstantFromSeconds(map, "iat");
        String string3 = this.getString(map, "jti");
        return new PayloadImpl(string, string2, list, instant, instant2, instant3, string3, map, jsonParser.getCodec());
    }

    List<String> getStringOrArray(ObjectCodec objectCodec, Map<String, JsonNode> map, String string) throws JWTDecodeException {
        JsonNode jsonNode = map.get(string);
        if (jsonNode == null || jsonNode.isNull() || !jsonNode.isArray() && !jsonNode.isTextual()) {
            return null;
        }
        if (jsonNode.isTextual()) {
            return Collections.singletonList(jsonNode.asText());
        }
        ArrayList<String> arrayList = new ArrayList<String>(jsonNode.size());
        for (int i2 = 0; i2 < jsonNode.size(); ++i2) {
            try {
                arrayList.add(objectCodec.treeToValue(jsonNode.get(i2), String.class));
                continue;
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to String", jsonProcessingException);
            }
        }
        return arrayList;
    }

    Instant getInstantFromSeconds(Map<String, JsonNode> map, String string) {
        JsonNode jsonNode = map.get(string);
        if (jsonNode == null || jsonNode.isNull()) {
            return null;
        }
        if (!jsonNode.canConvertToLong()) {
            throw new JWTDecodeException(String.format("The claim '%s' contained a non-numeric date value.", string));
        }
        return Instant.ofEpochSecond(jsonNode.asLong());
    }

    String getString(Map<String, JsonNode> map, String string) {
        JsonNode jsonNode = map.get(string);
        if (jsonNode == null || jsonNode.isNull()) {
            return null;
        }
        return jsonNode.asText(null);
    }
}

