/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sax;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sax.SAXFeature;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sax.WstxSAXParser;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.stax.WstxInputFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class WstxSAXParserFactory
extends SAXParserFactory {
    protected final WstxInputFactory mStaxFactory;
    protected boolean mFeatNsPrefixes = false;

    public WstxSAXParserFactory() {
        this(new WstxInputFactory());
        this.mStaxFactory.getConfig().doReplaceEntityRefs(false);
    }

    public WstxSAXParserFactory(WstxInputFactory wstxInputFactory) {
        this.mStaxFactory = wstxInputFactory;
        this.setNamespaceAware(true);
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXFeature sAXFeature = SAXFeature.findByUri(string);
        if (sAXFeature == SAXFeature.EXTERNAL_GENERAL_ENTITIES) {
            return this.mStaxFactory.getConfig().willSupportExternalEntities();
        }
        if (sAXFeature == SAXFeature.EXTERNAL_PARAMETER_ENTITIES) {
            return this.mStaxFactory.getConfig().willSupportExternalEntities();
        }
        if (sAXFeature == SAXFeature.IS_STANDALONE) {
            return false;
        }
        if (sAXFeature == SAXFeature.LEXICAL_HANDLER_PARAMETER_ENTITIES) {
            return false;
        }
        if (sAXFeature == SAXFeature.NAMESPACES) {
            return this.mStaxFactory.getConfig().willSupportNamespaces();
        }
        if (sAXFeature == SAXFeature.NAMESPACE_PREFIXES) {
            return this.mFeatNsPrefixes;
        }
        if (sAXFeature == SAXFeature.RESOLVE_DTD_URIS) {
            return false;
        }
        if (sAXFeature == SAXFeature.STRING_INTERNING) {
            return this.mStaxFactory.getConfig().willInternNames();
        }
        if (sAXFeature == SAXFeature.UNICODE_NORMALIZATION_CHECKING) {
            return false;
        }
        if (sAXFeature == SAXFeature.USE_ATTRIBUTES2) {
            return true;
        }
        if (sAXFeature == SAXFeature.USE_LOCATOR2) {
            return true;
        }
        if (sAXFeature == SAXFeature.USE_ENTITY_RESOLVER2) {
            return true;
        }
        if (sAXFeature == SAXFeature.VALIDATION) {
            return this.mStaxFactory.getConfig().willValidateWithDTD();
        }
        if (sAXFeature == SAXFeature.XMLNS_URIS) {
            return true;
        }
        if (sAXFeature == SAXFeature.XML_1_1) {
            return true;
        }
        if (sAXFeature == SAXFeature.JDK_SECURE_PROCESSING) {
            return this.mStaxFactory.getConfig().willProcessSecurely();
        }
        throw new SAXNotRecognizedException("Feature '" + string + "' not recognized");
    }

    @Override
    public SAXParser newSAXParser() {
        return new WstxSAXParser(this.mStaxFactory, this.mFeatNsPrefixes);
    }

    @Override
    public void setFeature(String string, boolean bl2) throws SAXNotRecognizedException, SAXNotSupportedException {
        boolean bl3 = false;
        boolean bl4 = false;
        SAXFeature sAXFeature = SAXFeature.findByUri(string);
        if (sAXFeature == SAXFeature.EXTERNAL_GENERAL_ENTITIES) {
            this.mStaxFactory.getConfig().doSupportExternalEntities(bl2);
        } else if (sAXFeature != SAXFeature.EXTERNAL_PARAMETER_ENTITIES) {
            if (sAXFeature == SAXFeature.IS_STANDALONE) {
                bl4 = true;
            } else if (sAXFeature != SAXFeature.LEXICAL_HANDLER_PARAMETER_ENTITIES) {
                if (sAXFeature == SAXFeature.NAMESPACES) {
                    this.mStaxFactory.getConfig().doSupportNamespaces(bl2);
                } else if (sAXFeature == SAXFeature.NAMESPACE_PREFIXES) {
                    this.mFeatNsPrefixes = bl2;
                } else if (sAXFeature != SAXFeature.RESOLVE_DTD_URIS) {
                    if (sAXFeature == SAXFeature.STRING_INTERNING) {
                        bl3 = !bl2;
                    } else if (sAXFeature == SAXFeature.UNICODE_NORMALIZATION_CHECKING) {
                        bl3 = bl2;
                    } else if (sAXFeature == SAXFeature.USE_ATTRIBUTES2) {
                        bl4 = true;
                    } else if (sAXFeature == SAXFeature.USE_LOCATOR2) {
                        bl4 = true;
                    } else if (sAXFeature == SAXFeature.USE_ENTITY_RESOLVER2) {
                        bl4 = true;
                    } else if (sAXFeature == SAXFeature.VALIDATION) {
                        this.mStaxFactory.getConfig().doValidateWithDTD(bl2);
                    } else if (sAXFeature == SAXFeature.XMLNS_URIS) {
                        bl3 = !bl2;
                    } else if (sAXFeature == SAXFeature.XML_1_1) {
                        bl4 = true;
                    } else if (sAXFeature == SAXFeature.JDK_SECURE_PROCESSING) {
                        this.mStaxFactory.getConfig().doProcessSecurely(bl2);
                    } else {
                        throw new SAXNotRecognizedException("Feature '" + string + "' not recognized");
                    }
                }
            }
        }
        if (bl4) {
            throw new SAXNotSupportedException("Feature '" + string + "' is read-only, can not be modified");
        }
        if (bl3) {
            throw new SAXNotSupportedException("Trying to set invalid value for feature '" + string + "', '" + bl2 + "'");
        }
    }
}

