/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.AbstractBooleanSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;

public final class BooleanSpliterators {
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    public static BooleanSpliterator wrap(boolean[] blArray, int n2, int n3, int n4) {
        BooleanArrays.ensureOffsetLength(blArray, n2, n3);
        return new ArraySpliterator(blArray, n2, n3, n4);
    }

    public static BooleanSpliterator asSpliterator(BooleanIterator booleanIterator, long l2, int n2) {
        return new SpliteratorFromIterator(booleanIterator, l2, n2);
    }

    public static BooleanSpliterator asSpliteratorUnknownSize(BooleanIterator booleanIterator, int n2) {
        return new SpliteratorFromIterator(booleanIterator, n2);
    }

    private static class ArraySpliterator
    implements BooleanSpliterator {
        final boolean[] array;
        private final int offset;
        private int length;
        private int curr;
        final int characteristics;

        public ArraySpliterator(boolean[] blArray, int n2, int n3, int n4) {
            this.array = blArray;
            this.offset = n2;
            this.length = n3;
            this.characteristics = 0x4150 | n4;
        }

        @Override
        public boolean tryAdvance(BooleanConsumer booleanConsumer) {
            if (this.curr >= this.length) {
                return false;
            }
            Objects.requireNonNull(booleanConsumer);
            booleanConsumer.accept(this.array[this.offset + this.curr++]);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.length - this.curr;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ArraySpliterator makeForSplit(int n2, int n3) {
            return new ArraySpliterator(this.array, n2, n3, this.characteristics);
        }

        @Override
        public BooleanSpliterator trySplit() {
            int n2 = this.length - this.curr >> 1;
            if (n2 <= 1) {
                return null;
            }
            int n3 = this.curr + n2;
            int n4 = this.offset + this.curr;
            this.curr = n3;
            return this.makeForSplit(n4, n2);
        }

        @Override
        public void forEachRemaining(BooleanConsumer booleanConsumer) {
            Objects.requireNonNull(booleanConsumer);
            boolean[] blArray = this.array;
            while (this.curr < this.length) {
                booleanConsumer.accept(blArray[this.offset + this.curr]);
                ++this.curr;
            }
        }
    }

    private static class SpliteratorFromIterator
    implements BooleanSpliterator {
        private final BooleanIterator iter;
        final int characteristics;
        private final boolean knownSize;
        private long size = Long.MAX_VALUE;
        private int nextBatchSize = 1024;
        private BooleanSpliterator delegate = null;

        SpliteratorFromIterator(BooleanIterator booleanIterator, int n2) {
            this.iter = booleanIterator;
            this.characteristics = 0x100 | n2;
            this.knownSize = false;
        }

        SpliteratorFromIterator(BooleanIterator booleanIterator, long l2, int n2) {
            this.iter = booleanIterator;
            this.knownSize = true;
            this.size = l2;
            this.characteristics = (n2 & 0x1000) != 0 ? 0x100 | n2 : 0x4140 | n2;
        }

        @Override
        public boolean tryAdvance(BooleanConsumer booleanConsumer) {
            if (this.delegate != null) {
                boolean bl2 = this.delegate.tryAdvance(booleanConsumer);
                if (!bl2) {
                    this.delegate = null;
                }
                return bl2;
            }
            if (!this.iter.hasNext()) {
                return false;
            }
            --this.size;
            booleanConsumer.accept(this.iter.nextBoolean());
            return true;
        }

        @Override
        public void forEachRemaining(BooleanConsumer booleanConsumer) {
            if (this.delegate != null) {
                this.delegate.forEachRemaining(booleanConsumer);
                this.delegate = null;
            }
            this.iter.forEachRemaining(booleanConsumer);
            this.size = 0L;
        }

        @Override
        public long estimateSize() {
            if (this.delegate != null) {
                return this.delegate.estimateSize();
            }
            if (!this.iter.hasNext()) {
                return 0L;
            }
            return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected BooleanSpliterator makeForSplit(boolean[] blArray, int n2) {
            return BooleanSpliterators.wrap(blArray, 0, n2, this.characteristics);
        }

        @Override
        public BooleanSpliterator trySplit() {
            if (!this.iter.hasNext()) {
                return null;
            }
            int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
            boolean[] blArray = new boolean[n2];
            int n3 = 0;
            while (n3 < n2 && this.iter.hasNext()) {
                blArray[n3++] = this.iter.nextBoolean();
                --this.size;
            }
            if (n2 < this.nextBatchSize && this.iter.hasNext()) {
                blArray = Arrays.copyOf(blArray, this.nextBatchSize);
                while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                    blArray[n3++] = this.iter.nextBoolean();
                    --this.size;
                }
            }
            this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
            BooleanSpliterator booleanSpliterator = this.makeForSplit(blArray, n3);
            if (!this.iter.hasNext()) {
                this.delegate = booleanSpliterator;
                return booleanSpliterator.trySplit();
            }
            return booleanSpliterator;
        }
    }

    public static class EmptySpliterator
    implements BooleanSpliterator,
    Serializable,
    Cloneable {
        protected EmptySpliterator() {
        }

        @Override
        public boolean tryAdvance(BooleanConsumer booleanConsumer) {
            return false;
        }

        @Override
        @Deprecated
        public boolean tryAdvance(Consumer<? super Boolean> consumer) {
            return false;
        }

        @Override
        public BooleanSpliterator trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 16448;
        }

        @Override
        public void forEachRemaining(BooleanConsumer booleanConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Boolean> consumer) {
        }

        public Object clone() {
            return EMPTY_SPLITERATOR;
        }
    }

    public static abstract class LateBindingSizeIndexBasedSpliterator
    extends AbstractIndexBasedSpliterator {
        protected int maxPos = -1;
        private boolean maxPosFixed;

        protected LateBindingSizeIndexBasedSpliterator(int n2) {
            super(n2);
            this.maxPosFixed = false;
        }

        protected LateBindingSizeIndexBasedSpliterator(int n2, int n3) {
            super(n2);
            this.maxPos = n3;
            this.maxPosFixed = true;
        }

        protected abstract int getMaxPosFromBackingStore();

        @Override
        protected final int getMaxPos() {
            return this.maxPosFixed ? this.maxPos : this.getMaxPosFromBackingStore();
        }

        @Override
        public BooleanSpliterator trySplit() {
            BooleanSpliterator booleanSpliterator = super.trySplit();
            if (!this.maxPosFixed && booleanSpliterator != null) {
                this.maxPos = this.getMaxPosFromBackingStore();
                this.maxPosFixed = true;
            }
            return booleanSpliterator;
        }
    }

    public static abstract class AbstractIndexBasedSpliterator
    extends AbstractBooleanSpliterator {
        protected int pos;

        protected AbstractIndexBasedSpliterator(int n2) {
            this.pos = n2;
        }

        protected abstract boolean get(int var1);

        protected abstract int getMaxPos();

        protected abstract BooleanSpliterator makeForSplit(int var1, int var2);

        protected int computeSplitPoint() {
            return this.pos + (this.getMaxPos() - this.pos) / 2;
        }

        private void splitPointCheck(int n2, int n3) {
            if (n2 < this.pos || n2 > n3) {
                throw new IndexOutOfBoundsException("splitPoint " + n2 + " outside of range of current position " + this.pos + " and range end " + n3);
            }
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return (long)this.getMaxPos() - (long)this.pos;
        }

        @Override
        public boolean tryAdvance(BooleanConsumer booleanConsumer) {
            if (this.pos >= this.getMaxPos()) {
                return false;
            }
            booleanConsumer.accept(this.get(this.pos++));
            return true;
        }

        @Override
        public void forEachRemaining(BooleanConsumer booleanConsumer) {
            int n2 = this.getMaxPos();
            while (this.pos < n2) {
                booleanConsumer.accept(this.get(this.pos));
                ++this.pos;
            }
        }

        @Override
        public BooleanSpliterator trySplit() {
            int n2 = this.getMaxPos();
            int n3 = this.computeSplitPoint();
            if (n3 == this.pos || n3 == n2) {
                return null;
            }
            this.splitPointCheck(n3, n2);
            int n4 = this.pos;
            BooleanSpliterator booleanSpliterator = this.makeForSplit(n4, n3);
            if (booleanSpliterator != null) {
                this.pos = n3;
            }
            return booleanSpliterator;
        }
    }
}

