/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.file;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.Counters;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.DeleteOption;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.DeletingPathVisitor;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.StandardDeleteOption;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.attribute.FileTimes;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public final class PathUtils {
    private static final OpenOption[] OPEN_OPTIONS_TRUNCATE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] OPEN_OPTIONS_APPEND = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileAttribute<?>[] EMPTY_FILE_ATTRIBUTE_ARRAY = new FileAttribute[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    @Deprecated
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    static final LinkOption NULL_LINK_OPTION = null;
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];
    public static final Path[] EMPTY_PATH_ARRAY = new Path[0];

    public static Path createParentDirectories(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return PathUtils.createParentDirectories(path, LinkOption.NOFOLLOW_LINKS, fileAttributeArray);
    }

    public static Path createParentDirectories(Path path, LinkOption linkOption, FileAttribute<?> ... fileAttributeArray) throws IOException {
        Path path2 = PathUtils.getParent(path);
        Path path3 = path2 = linkOption == LinkOption.NOFOLLOW_LINKS ? path2 : PathUtils.readIfSymbolicLink(path2);
        if (path2 == null) {
            return null;
        }
        boolean bl2 = linkOption == null ? Files.exists(path2, new LinkOption[0]) : Files.exists(path2, linkOption);
        return bl2 ? path2 : Files.createDirectories(path2, fileAttributeArray);
    }

    public static Counters.PathCounters delete(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) throws IOException {
        return Files.isDirectory(path, linkOptionArray) ? PathUtils.deleteDirectory(path, linkOptionArray, deleteOptionArray) : PathUtils.deleteFile(path, linkOptionArray, deleteOptionArray);
    }

    public static Counters.PathCounters deleteDirectory(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) throws IOException {
        return PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), linkOptionArray, deleteOptionArray, new String[0]), path).getPathCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counters.PathCounters deleteFile(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) throws NoSuchFileException, IOException {
        if (Files.isDirectory(path, linkOptionArray)) {
            throw new NoSuchFileException(path.toString());
        }
        Counters.PathCounters pathCounters = Counters.longPathCounters();
        boolean bl2 = PathUtils.exists(path, linkOptionArray);
        long l2 = bl2 && !Files.isSymbolicLink(path) ? Files.size(path) : 0L;
        try {
            if (Files.deleteIfExists(path)) {
                pathCounters.getFileCounter().increment();
                pathCounters.getByteCounter().add(l2);
                return pathCounters;
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        Path path2 = PathUtils.getParent(path);
        PosixFileAttributes posixFileAttributes = null;
        try {
            if (PathUtils.overrideReadOnly(deleteOptionArray)) {
                posixFileAttributes = PathUtils.readPosixFileAttributes(path2, linkOptionArray);
                PathUtils.setReadOnly(path, false, linkOptionArray);
            }
            long l3 = l2 = (bl2 = PathUtils.exists(path, linkOptionArray)) && !Files.isSymbolicLink(path) ? Files.size(path) : 0L;
            if (Files.deleteIfExists(path)) {
                pathCounters.getFileCounter().increment();
                pathCounters.getByteCounter().add(l2);
            }
        }
        finally {
            if (posixFileAttributes != null) {
                Files.setPosixFilePermissions(path2, posixFileAttributes.permissions());
            }
        }
        return pathCounters;
    }

    private static boolean exists(Path path, LinkOption ... linkOptionArray) {
        return path != null && (linkOptionArray != null ? Files.exists(path, linkOptionArray) : Files.exists(path, new LinkOption[0]));
    }

    public static DosFileAttributeView getDosFileAttributeView(Path path, LinkOption ... linkOptionArray) {
        return Files.getFileAttributeView(path, DosFileAttributeView.class, linkOptionArray);
    }

    public static <R> R getFileName(Path path, Function<Path, R> function) {
        Path path2 = path != null ? path.getFileName() : null;
        return path2 != null ? (R)function.apply(path2) : null;
    }

    public static String getFileNameString(Path path) {
        return PathUtils.getFileName(path, Path::toString);
    }

    private static Path getParent(Path path) {
        return path == null ? null : path.getParent();
    }

    public static boolean isEmptyDirectory(Path path) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            boolean bl2 = !directoryStream.iterator().hasNext();
            return bl2;
        }
    }

    public static boolean isPosix(Path path, LinkOption ... linkOptionArray) {
        return PathUtils.exists(path, linkOptionArray) && PathUtils.readPosixFileAttributes(path, linkOptionArray) != null;
    }

    public static LinkOption[] noFollowLinkOptionArray() {
        return (LinkOption[])NOFOLLOW_LINK_OPTION_ARRAY.clone();
    }

    private static boolean overrideReadOnly(DeleteOption ... deleteOptionArray) {
        if (deleteOptionArray == null) {
            return false;
        }
        return Stream.of(deleteOptionArray).anyMatch(deleteOption -> deleteOption == StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) {
        try {
            return path == null ? null : (A)Files.readAttributes(path, clazz, linkOptionArray);
        }
        catch (IOException | UnsupportedOperationException exception) {
            return null;
        }
    }

    private static Path readIfSymbolicLink(Path path) throws IOException {
        return path != null ? (Files.isSymbolicLink(path) ? Files.readSymbolicLink(path) : path) : null;
    }

    public static PosixFileAttributes readPosixFileAttributes(Path path, LinkOption ... linkOptionArray) {
        return PathUtils.readAttributes(path, PosixFileAttributes.class, linkOptionArray);
    }

    private static boolean setDosReadOnly(Path path, boolean bl2, LinkOption ... linkOptionArray) throws IOException {
        DosFileAttributeView dosFileAttributeView = PathUtils.getDosFileAttributeView(path, linkOptionArray);
        if (dosFileAttributeView != null) {
            dosFileAttributeView.setReadOnly(bl2);
            return true;
        }
        return false;
    }

    private static boolean setPosixDeletePermissions(Path path, boolean bl2, LinkOption ... linkOptionArray) throws IOException {
        return PathUtils.setPosixPermissions(path, bl2, Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), linkOptionArray);
    }

    private static boolean setPosixPermissions(Path path, boolean bl2, List<PosixFilePermission> list, LinkOption ... linkOptionArray) throws IOException {
        if (path != null) {
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, linkOptionArray);
            HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>(set);
            if (bl2) {
                hashSet.addAll(list);
            } else {
                hashSet.removeAll(list);
            }
            if (!hashSet.equals(set)) {
                Files.setPosixFilePermissions(path, hashSet);
            }
            return true;
        }
        return false;
    }

    private static void setPosixReadOnlyFile(Path path, boolean bl2, LinkOption ... linkOptionArray) throws IOException {
        Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, linkOptionArray);
        List<PosixFilePermission> list = Arrays.asList(PosixFilePermission.OWNER_READ);
        List<PosixFilePermission> list2 = Arrays.asList(PosixFilePermission.OWNER_WRITE);
        if (bl2) {
            set.addAll(list);
            set.removeAll(list2);
        } else {
            set.addAll(list);
            set.addAll(list2);
        }
        Files.setPosixFilePermissions(path, set);
    }

    public static Path setReadOnly(Path path, boolean bl2, LinkOption ... linkOptionArray) throws IOException {
        try {
            if (PathUtils.setDosReadOnly(path, bl2, linkOptionArray)) {
                return path;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path path2 = PathUtils.getParent(path);
        if (!PathUtils.isPosix(path2, linkOptionArray)) {
            throw new IOException(String.format("DOS or POSIX file operations not available for '%s', linkOptions %s", path, Arrays.toString(linkOptionArray)));
        }
        if (bl2) {
            PathUtils.setPosixReadOnlyFile(path, bl2, linkOptionArray);
            PathUtils.setPosixDeletePermissions(path2, false, linkOptionArray);
        } else {
            PathUtils.setPosixDeletePermissions(path2, true, linkOptionArray);
        }
        return path;
    }

    public static Path touch(Path path) throws IOException {
        Objects.requireNonNull(path, "file");
        if (!Files.exists(path, new LinkOption[0])) {
            PathUtils.createParentDirectories(path, new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        } else {
            FileTimes.setLastModifiedTime(path);
        }
        return path;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t2, Path path) throws IOException {
        Files.walkFileTree(path, t2);
        return t2;
    }
}

