/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.ConversionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Set;

final class StringToArrayConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public StringToArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Object[].class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor, typeDescriptor2.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        String string = (String)object;
        String[] stringArray = StringUtils.commaDelimitedListToStringArray(string);
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getElementTypeDescriptor();
        Assert.state(typeDescriptor3 != null, "No target element type");
        Object object2 = Array.newInstance(typeDescriptor3.getType(), stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            Object object3 = this.conversionService.convert(string2.trim(), typeDescriptor, typeDescriptor3);
            Array.set(object2, i2, object3);
        }
        return object2;
    }
}

