/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.linux;

import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractSensors;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.FileUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.GlobalConfig;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.linux.SysPath;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class LinuxSensors
extends AbstractSensors {
    private static final List<String> THERMAL_ZONE_TYPE_PRIORITY = Stream.of(GlobalConfig.get("com.gradle.maven.extension.internal.dep.oshi.os.linux.sensors.cpuTemperature.types", "").split(",")).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    private static final String[] SENSORS = new String[]{"temp", "fan", "in"};
    private static final String HWMON_PATH = SysPath.HWMON + "hwmon";
    private static final String THERMAL_ZONE_PATH = SysPath.THERMAL + "thermal_zone";
    private static final boolean IS_PI = LinuxSensors.queryCpuTemperatureFromVcGenCmd() > 0.0;
    private final Map<String, String> sensorsMap = new HashMap<String, String>();

    LinuxSensors() {
        if (!IS_PI) {
            this.populateSensorsMapFromHwmon();
            if (!this.sensorsMap.containsKey("temp")) {
                this.populateSensorsMapFromThermalZone();
            }
        }
    }

    private void populateSensorsMapFromHwmon() {
        String[] stringArray = SENSORS;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            String string2 = string = stringArray[i2];
            this.getSensorFilesFromPath(HWMON_PATH, string, file -> {
                try {
                    return file.getName().startsWith(string2) && file.getName().endsWith("_input") && FileUtil.getIntFromFile(file.getCanonicalPath()) > 0;
                }
                catch (IOException iOException) {
                    return false;
                }
            });
        }
    }

    private void populateSensorsMapFromThermalZone() {
        this.getSensorFilesFromPath(THERMAL_ZONE_PATH, "temp", file -> file.getName().equals("type") || file.getName().equals("temp"), fileArray -> Stream.of(fileArray).filter(file -> "type".equals(file.getName())).findFirst().map(File::getPath).map(FileUtil::getStringFromFile).map(THERMAL_ZONE_TYPE_PRIORITY::indexOf).filter(n2 -> n2 >= 0).orElse(THERMAL_ZONE_TYPE_PRIORITY.size()));
    }

    private void getSensorFilesFromPath(String string, String string2, FileFilter fileFilter) {
        this.getSensorFilesFromPath(string, string2, fileFilter, fileArray -> 0);
    }

    private void getSensorFilesFromPath(String string, String string2, FileFilter fileFilter, ToIntFunction<File[]> toIntFunction) {
        String string3 = null;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (Paths.get(string + n3, new String[0]).toFile().isDirectory()) {
            int n4;
            String string4 = string + n3;
            File file = new File(string4);
            File[] fileArray = file.listFiles(fileFilter);
            if (fileArray != null && fileArray.length > 0 && (n4 = toIntFunction.applyAsInt(fileArray)) < n2) {
                n2 = n4;
                string3 = string4;
            }
            ++n3;
        }
        if (string3 != null) {
            this.sensorsMap.put(string2, String.format(Locale.ROOT, "%s/%s", string3, string2));
        }
    }

    @Override
    public double queryCpuTemperature() {
        if (IS_PI) {
            return LinuxSensors.queryCpuTemperatureFromVcGenCmd();
        }
        String string = this.sensorsMap.get("temp");
        if (string != null) {
            long l2 = 0L;
            if (string.contains("hwmon")) {
                l2 = FileUtil.getLongFromFile(String.format(Locale.ROOT, "%s1_input", string));
                if (l2 > 0L) {
                    return (double)l2 / 1000.0;
                }
                long l3 = 0L;
                int n2 = 0;
                for (int i2 = 2; i2 <= 6; ++i2) {
                    l2 = FileUtil.getLongFromFile(String.format(Locale.ROOT, "%s%d_input", string, i2));
                    if (l2 <= 0L) continue;
                    l3 += l2;
                    ++n2;
                }
                if (n2 > 0) {
                    return (double)l3 / ((double)n2 * 1000.0);
                }
            } else if (string.contains("thermal_zone") && (l2 = FileUtil.getLongFromFile(string)) > 0L) {
                return (double)l2 / 1000.0;
            }
        }
        return 0.0;
    }

    private static double queryCpuTemperatureFromVcGenCmd() {
        String string = ExecutingCommand.getFirstAnswer("vcgencmd measure_temp");
        if (string.startsWith("temp=")) {
            return ParseUtil.parseDoubleOrDefault(string.replaceAll("[^\\d|\\.]+", ""), 0.0);
        }
        return 0.0;
    }

    @Override
    public int[] queryFanSpeeds() {
        String string;
        if (!IS_PI && (string = this.sensorsMap.get("fan")) != null) {
            Object object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n2 = 1;
            while (new File((String)(object = String.format(Locale.ROOT, "%s%d_input", string, n2))).exists()) {
                arrayList.add(FileUtil.getIntFromFile((String)object));
                ++n2;
            }
            object = new int[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                object[i2] = (Integer)arrayList.get(i2);
            }
            return object;
        }
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        if (IS_PI) {
            return LinuxSensors.queryCpuVoltageFromVcGenCmd();
        }
        String string = this.sensorsMap.get("in");
        if (string != null) {
            return (double)FileUtil.getIntFromFile(String.format(Locale.ROOT, "%s1_input", string)) / 1000.0;
        }
        return 0.0;
    }

    private static double queryCpuVoltageFromVcGenCmd() {
        String string = ExecutingCommand.getFirstAnswer("vcgencmd measure_volts core");
        if (string.startsWith("volt=")) {
            return ParseUtil.parseDoubleOrDefault(string.replaceAll("[^\\d|\\.]+", ""), 0.0);
        }
        return 0.0;
    }
}

