/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.FloatingNumberType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.SimpleURType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;

public class DoubleType
extends FloatingNumberType {
    public static final DoubleType theInstance = new DoubleType();
    private static final long serialVersionUID = 1L;

    private DoubleType() {
        super("double");
    }

    @Override
    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    @Override
    public Object _createValue(String string, ValidationContext validationContext) {
        return DoubleType.load(string);
    }

    public static Double load(String string) {
        try {
            if (string.equals("NaN")) {
                return new Double(Double.NaN);
            }
            if (string.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            if (string.length() == 0 || !DoubleType.isDigitOrPeriodOrSign(string.charAt(0)) || !DoubleType.isDigitOrPeriodOrSign(string.charAt(string.length() - 1))) {
                return null;
            }
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (!(object instanceof Double)) {
            throw new IllegalArgumentException();
        }
        return DoubleType.save((Double)object);
    }

    public static String save(Double d2) {
        double d3 = d2;
        if (Double.isNaN(d3)) {
            return "NaN";
        }
        if (d3 == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return d2.toString();
    }

    @Override
    public Class getJavaObjectType() {
        return Double.class;
    }
}

