/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.JavaTimeFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateDeserializer
extends JSR310DateTimeDeserializerBase<LocalDate> {
    private static final boolean DEFAULT_USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING = JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING.enabledByDefault();
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final LocalDateDeserializer INSTANCE = new LocalDateDeserializer();
    protected final boolean _useTimeZoneForLenientDateParsing;

    protected LocalDateDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateDeserializer(DateTimeFormatter dateTimeFormatter) {
        super(LocalDate.class, dateTimeFormatter);
        this._useTimeZoneForLenientDateParsing = DEFAULT_USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING;
    }

    public LocalDateDeserializer(LocalDateDeserializer localDateDeserializer, DateTimeFormatter dateTimeFormatter) {
        super(localDateDeserializer, dateTimeFormatter);
        this._useTimeZoneForLenientDateParsing = localDateDeserializer._useTimeZoneForLenientDateParsing;
    }

    protected LocalDateDeserializer(LocalDateDeserializer localDateDeserializer, Boolean bl2) {
        super(localDateDeserializer, bl2);
        this._useTimeZoneForLenientDateParsing = localDateDeserializer._useTimeZoneForLenientDateParsing;
    }

    protected LocalDateDeserializer(LocalDateDeserializer localDateDeserializer, JsonFormat.Shape shape) {
        super(localDateDeserializer, shape);
        this._useTimeZoneForLenientDateParsing = localDateDeserializer._useTimeZoneForLenientDateParsing;
    }

    protected LocalDateDeserializer(LocalDateDeserializer localDateDeserializer, JacksonFeatureSet<JavaTimeFeature> jacksonFeatureSet) {
        super(LocalDate.class, localDateDeserializer._formatter);
        this._useTimeZoneForLenientDateParsing = jacksonFeatureSet.isEnabled(JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING);
    }

    protected LocalDateDeserializer withDateFormat(DateTimeFormatter dateTimeFormatter) {
        return new LocalDateDeserializer(this, dateTimeFormatter);
    }

    protected LocalDateDeserializer withLeniency(Boolean bl2) {
        return new LocalDateDeserializer(this, bl2);
    }

    protected LocalDateDeserializer withShape(JsonFormat.Shape shape) {
        return new LocalDateDeserializer(this, shape);
    }

    public LocalDateDeserializer withFeatures(JacksonFeatureSet<JavaTimeFeature> jacksonFeatureSet) {
        if (this._useTimeZoneForLenientDateParsing == jacksonFeatureSet.isEnabled(JavaTimeFeature.USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING)) {
            return this;
        }
        return new LocalDateDeserializer(this, jacksonFeatureSet);
    }

    @Override
    public LocalDate deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Enum enum_;
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            String string = deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType());
            if (string != null) {
                return this._fromString(jsonParser, deserializationContext, string);
            }
            return (LocalDate)this._handleUnexpectedToken(deserializationContext, jsonParser, "Expected array or string", new Object[0]);
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            enum_ = jsonParser.nextToken();
            if (enum_ == JsonToken.END_ARRAY) {
                return null;
            }
            if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS) && (enum_ == JsonToken.VALUE_STRING || enum_ == JsonToken.VALUE_EMBEDDED_OBJECT)) {
                LocalDate localDate = this.deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return localDate;
            }
            if (enum_ == JsonToken.VALUE_NUMBER_INT) {
                int n2 = jsonParser.getIntValue();
                int n3 = jsonParser.nextIntValue(-1);
                int n4 = jsonParser.nextIntValue(-1);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                }
                return LocalDate.of(n2, n3, n4);
            }
            deserializationContext.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", enum_);
        }
        if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDate)jsonParser.getEmbeddedObject();
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            enum_ = deserializationContext.findCoercionAction(this.logicalType(), this._valueClass, CoercionInputShape.Integer);
            this._checkCoercionFail(deserializationContext, (CoercionAction)enum_, this.handledType(), jsonParser.getLongValue(), "Integer value (" + jsonParser.getLongValue() + ")");
            if (this._shape == JsonFormat.Shape.NUMBER_INT || this.isLenient()) {
                return LocalDate.ofEpochDay(jsonParser.getLongValue());
            }
            return (LocalDate)this._failForNotLenient(jsonParser, deserializationContext, JsonToken.VALUE_STRING);
        }
        return (LocalDate)this._handleUnexpectedToken(deserializationContext, jsonParser, "Expected array or string", new Object[0]);
    }

    protected LocalDate _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (LocalDate)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        try {
            DateTimeFormatter dateTimeFormatter = this._formatter;
            if (dateTimeFormatter == DEFAULT_FORMATTER && string2.length() > 10 && string2.charAt(10) == 'T') {
                if (this.isLenient()) {
                    if (string2.endsWith("Z")) {
                        if (this._useTimeZoneForLenientDateParsing) {
                            return Instant.parse(string2).atZone(deserializationContext.getTimeZone().toZoneId()).toLocalDate();
                        }
                        return LocalDate.parse(string2.substring(0, string2.length() - 1), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                    }
                    return LocalDate.parse(string2, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                }
                JavaType javaType = this.getValueType(deserializationContext);
                return (LocalDate)deserializationContext.handleWeirdStringValue(javaType.getRawClass(), string2, "Should not contain time component when 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[0]);
            }
            return LocalDate.parse(string2, dateTimeFormatter);
        }
        catch (DateTimeException dateTimeException) {
            return (LocalDate)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }
}

