/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.AtomicReferenceCountUpdater;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ReferenceCountUpdater;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.UnsafeReferenceCountUpdater;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.VarHandleReferenceCountUpdater;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class AbstractReferenceCountedByteBuf
extends AbstractByteBuf {
    private static final long REFCNT_FIELD_OFFSET;
    private static final AtomicIntegerFieldUpdater<AbstractReferenceCountedByteBuf> AIF_UPDATER;
    private static final Object REFCNT_FIELD_VH;
    private static final ReferenceCountUpdater<AbstractReferenceCountedByteBuf> updater;
    private volatile int refCnt;

    protected AbstractReferenceCountedByteBuf(int n2) {
        super(n2);
        updater.setInitialValue(this);
    }

    @Override
    boolean isAccessible() {
        return updater.isLiveNonVolatile(this);
    }

    @Override
    public int refCnt() {
        return updater.refCnt(this);
    }

    protected final void resetRefCnt() {
        updater.resetRefCnt(this);
    }

    @Override
    public ByteBuf retain() {
        return updater.retain(this);
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        return this;
    }

    @Override
    public boolean release() {
        return this.handleRelease(updater.release(this));
    }

    private boolean handleRelease(boolean bl2) {
        if (bl2) {
            this.deallocate();
        }
        return bl2;
    }

    protected abstract void deallocate();

    static {
        ReferenceCountUpdater.UpdaterType updaterType = ReferenceCountUpdater.updaterTypeOf(AbstractReferenceCountedByteBuf.class, "refCnt");
        switch (updaterType) {
            case Atomic: {
                AIF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractReferenceCountedByteBuf.class, "refCnt");
                REFCNT_FIELD_OFFSET = -1L;
                REFCNT_FIELD_VH = null;
                updater = new AtomicReferenceCountUpdater<AbstractReferenceCountedByteBuf>(){

                    @Override
                    protected AtomicIntegerFieldUpdater<AbstractReferenceCountedByteBuf> updater() {
                        return AIF_UPDATER;
                    }
                };
                break;
            }
            case Unsafe: {
                AIF_UPDATER = null;
                REFCNT_FIELD_OFFSET = ReferenceCountUpdater.getUnsafeOffset(AbstractReferenceCountedByteBuf.class, "refCnt");
                REFCNT_FIELD_VH = null;
                updater = new UnsafeReferenceCountUpdater<AbstractReferenceCountedByteBuf>(){

                    @Override
                    protected long refCntFieldOffset() {
                        return REFCNT_FIELD_OFFSET;
                    }
                };
                break;
            }
            case VarHandle: {
                AIF_UPDATER = null;
                REFCNT_FIELD_OFFSET = -1L;
                REFCNT_FIELD_VH = PlatformDependent.findVarHandleOfIntField(MethodHandles.lookup(), AbstractReferenceCountedByteBuf.class, "refCnt");
                updater = new VarHandleReferenceCountUpdater<AbstractReferenceCountedByteBuf>(){

                    @Override
                    protected VarHandle varHandle() {
                        return (VarHandle)REFCNT_FIELD_VH;
                    }
                };
                break;
            }
            default: {
                throw new Error("Unexpected updater type for AbstractReferenceCountedByteBuf: " + (Object)((Object)updaterType));
            }
        }
    }
}

