/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundInvoker;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DelegatingChannelPromiseNotifier;
import com.gradle.maven.extension.internal.dep.io.netty.channel.PendingBytesTracker;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;

public abstract class AbstractCoalescingBufferQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractCoalescingBufferQueue.class);
    private final ArrayDeque<Object> bufAndListenerPairs;
    private final PendingBytesTracker tracker;
    private int readableBytes;

    protected AbstractCoalescingBufferQueue(Channel channel, int n2) {
        this.bufAndListenerPairs = new ArrayDeque(n2);
        this.tracker = channel == null ? null : PendingBytesTracker.newTracker(channel);
    }

    public final void addFirst(ByteBuf byteBuf, ChannelPromise channelPromise) {
        this.addFirst(byteBuf, AbstractCoalescingBufferQueue.toChannelFutureListener(channelPromise));
    }

    private void addFirst(ByteBuf byteBuf, ChannelFutureListener channelFutureListener) {
        byteBuf.touch();
        if (channelFutureListener != null) {
            this.bufAndListenerPairs.addFirst(channelFutureListener);
        }
        this.bufAndListenerPairs.addFirst(byteBuf);
        this.incrementReadableBytes(byteBuf.readableBytes());
    }

    public final void add(ByteBuf byteBuf) {
        this.add(byteBuf, (ChannelFutureListener)null);
    }

    public final void add(ByteBuf byteBuf, ChannelPromise channelPromise) {
        this.add(byteBuf, AbstractCoalescingBufferQueue.toChannelFutureListener(channelPromise));
    }

    public final void add(ByteBuf byteBuf, ChannelFutureListener channelFutureListener) {
        byteBuf.touch();
        this.bufAndListenerPairs.add(byteBuf);
        if (channelFutureListener != null) {
            this.bufAndListenerPairs.add(channelFutureListener);
        }
        this.incrementReadableBytes(byteBuf.readableBytes());
    }

    public final ByteBuf removeFirst(ChannelPromise channelPromise) {
        Object object = this.bufAndListenerPairs.poll();
        if (object == null) {
            return null;
        }
        assert (object instanceof ByteBuf);
        ByteBuf byteBuf = (ByteBuf)object;
        this.decrementReadableBytes(byteBuf.readableBytes());
        object = this.bufAndListenerPairs.peek();
        if (object instanceof ChannelFutureListener) {
            channelPromise.addListener((GenericFutureListener)((ChannelFutureListener)object));
            this.bufAndListenerPairs.poll();
        }
        return byteBuf;
    }

    public final ByteBuf remove(ByteBufAllocator byteBufAllocator, int n2, ChannelPromise channelPromise) {
        ObjectUtil.checkPositiveOrZero(n2, "bytes");
        ObjectUtil.checkNotNull(channelPromise, "aggregatePromise");
        if (this.bufAndListenerPairs.isEmpty()) {
            assert (this.readableBytes == 0);
            return this.removeEmptyValue();
        }
        n2 = Math.min(n2, this.readableBytes);
        ByteBuf byteBuf = null;
        ByteBuf byteBuf2 = null;
        int n3 = n2;
        Object object = null;
        try {
            while ((object = this.bufAndListenerPairs.poll()) != null) {
                if (object instanceof ByteBuf) {
                    byteBuf2 = (ByteBuf)object;
                    int n4 = byteBuf2.readableBytes();
                    if (n4 > n2) {
                        this.bufAndListenerPairs.addFirst(byteBuf2);
                        if (n2 > 0) {
                            byteBuf2 = byteBuf2.readRetainedSlice(n2);
                            byteBuf = byteBuf == null ? byteBuf2 : this.compose(byteBufAllocator, byteBuf, byteBuf2);
                            n2 = 0;
                        }
                        break;
                    }
                    byteBuf = byteBuf == null ? (n2 == 0 ? byteBuf2 : this.composeFirst(byteBufAllocator, byteBuf2, n4 + (n2 -= n4))) : this.compose(byteBufAllocator, byteBuf, byteBuf2);
                    byteBuf2 = null;
                    continue;
                }
                if (object instanceof DelegatingChannelPromiseNotifier) {
                    channelPromise.addListener((GenericFutureListener)((DelegatingChannelPromiseNotifier)object));
                    continue;
                }
                if (!(object instanceof ChannelFutureListener)) continue;
                channelPromise.addListener((GenericFutureListener)((ChannelFutureListener)object));
            }
        }
        catch (Throwable throwable) {
            this.decrementReadableBytes(n3 - n2);
            object = this.bufAndListenerPairs.peek();
            if (object instanceof ChannelFutureListener) {
                channelPromise.addListener((GenericFutureListener)((ChannelFutureListener)object));
                this.bufAndListenerPairs.poll();
            }
            ReferenceCountUtil.safeRelease(byteBuf2);
            ReferenceCountUtil.safeRelease(byteBuf);
            channelPromise.setFailure(throwable);
            PlatformDependent.throwException(throwable);
        }
        this.decrementReadableBytes(n3 - n2);
        return byteBuf;
    }

    public final boolean isEmpty() {
        return this.bufAndListenerPairs.isEmpty();
    }

    public final void releaseAndFailAll(ChannelOutboundInvoker channelOutboundInvoker, Throwable throwable) {
        this.releaseAndCompleteAll(channelOutboundInvoker.newFailedFuture(throwable));
    }

    public final void writeAndRemoveAll(ChannelHandlerContext channelHandlerContext) {
        Throwable throwable = null;
        ByteBuf byteBuf = null;
        while (true) {
            Object object = this.bufAndListenerPairs.poll();
            try {
                if (object == null) {
                    if (byteBuf == null) break;
                    this.decrementReadableBytes(byteBuf.readableBytes());
                    channelHandlerContext.write(byteBuf, channelHandlerContext.voidPromise());
                    break;
                }
                if (object instanceof ByteBuf) {
                    if (byteBuf != null) {
                        this.decrementReadableBytes(byteBuf.readableBytes());
                        channelHandlerContext.write(byteBuf, channelHandlerContext.voidPromise());
                    }
                    byteBuf = (ByteBuf)object;
                    continue;
                }
                if (object instanceof ChannelPromise) {
                    this.decrementReadableBytes(byteBuf.readableBytes());
                    channelHandlerContext.write(byteBuf, (ChannelPromise)object);
                    byteBuf = null;
                    continue;
                }
                this.decrementReadableBytes(byteBuf.readableBytes());
                channelHandlerContext.write(byteBuf).addListener((GenericFutureListener)((ChannelFutureListener)object));
                byteBuf = null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)throwable, (Object)throwable2);
            }
        }
        if (throwable != null) {
            throw new IllegalStateException(throwable);
        }
    }

    public String toString() {
        return "bytes: " + this.readableBytes + " buffers: " + (this.size() >> 1);
    }

    protected abstract ByteBuf compose(ByteBufAllocator var1, ByteBuf var2, ByteBuf var3);

    protected final ByteBuf copyAndCompose(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, ByteBuf byteBuf2) {
        ByteBuf byteBuf3 = byteBufAllocator.ioBuffer(byteBuf.readableBytes() + byteBuf2.readableBytes());
        try {
            byteBuf3.writeBytes(byteBuf).writeBytes(byteBuf2);
        }
        catch (Throwable throwable) {
            byteBuf3.release();
            ReferenceCountUtil.safeRelease(byteBuf2);
            PlatformDependent.throwException(throwable);
        }
        byteBuf.release();
        byteBuf2.release();
        return byteBuf3;
    }

    protected ByteBuf composeFirst(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n2) {
        return this.composeFirst(byteBufAllocator, byteBuf);
    }

    @Deprecated
    protected ByteBuf composeFirst(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf) {
        return byteBuf;
    }

    protected abstract ByteBuf removeEmptyValue();

    protected final int size() {
        return this.bufAndListenerPairs.size();
    }

    private void releaseAndCompleteAll(ChannelFuture channelFuture) {
        Object object;
        Throwable throwable = null;
        while ((object = this.bufAndListenerPairs.poll()) != null) {
            try {
                if (object instanceof ByteBuf) {
                    ByteBuf byteBuf = (ByteBuf)object;
                    this.decrementReadableBytes(byteBuf.readableBytes());
                    ReferenceCountUtil.safeRelease(byteBuf);
                    continue;
                }
                ((ChannelFutureListener)object).operationComplete(channelFuture);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)throwable, (Object)throwable2);
            }
        }
        if (throwable != null) {
            throw new IllegalStateException(throwable);
        }
    }

    private void incrementReadableBytes(int n2) {
        int n3 = this.readableBytes + n2;
        if (n3 < this.readableBytes) {
            throw new IllegalStateException("buffer queue length overflow: " + this.readableBytes + " + " + n2);
        }
        this.readableBytes = n3;
        if (this.tracker != null) {
            this.tracker.incrementPendingOutboundBytes(n2);
        }
    }

    private void decrementReadableBytes(int n2) {
        this.readableBytes -= n2;
        assert (this.readableBytes >= 0);
        if (this.tracker != null) {
            this.tracker.decrementPendingOutboundBytes(n2);
        }
    }

    private static ChannelFutureListener toChannelFutureListener(ChannelPromise channelPromise) {
        return channelPromise.isVoid() ? null : new DelegatingChannelPromiseNotifier(channelPromise);
    }
}

