/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInboundHandlerAdapter;
import com.gradle.maven.extension.internal.dep.io.netty.channel.embedded.EmbeddedChannel;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.CodecException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.DecoderResult;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.MessageToMessageDecoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.ComposedLastHttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpMessage;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpRequest;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpResponse;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaderNames;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaderValues;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpMessage;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpObject;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpResponse;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.LastHttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import java.util.List;

public abstract class HttpContentDecoder
extends MessageToMessageDecoder<HttpObject> {
    static final String IDENTITY = HttpHeaderValues.IDENTITY.toString();
    protected ChannelHandlerContext ctx;
    private EmbeddedChannel decoder;
    private boolean continueResponse;
    private boolean needRead = true;
    private ByteBufForwarder forwarder;

    public HttpContentDecoder() {
        super(HttpObject.class);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) throws Exception {
        Object object;
        Object object2;
        HttpObject httpObject2;
        this.needRead = true;
        if (httpObject instanceof HttpResponse && ((HttpResponse)httpObject).status().code() == 100) {
            if (!(httpObject instanceof LastHttpContent)) {
                this.continueResponse = true;
            }
            this.needRead = false;
            channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain(httpObject));
            return;
        }
        if (this.continueResponse) {
            if (httpObject instanceof LastHttpContent) {
                this.continueResponse = false;
            }
            this.needRead = false;
            channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain(httpObject));
            return;
        }
        if (httpObject instanceof HttpMessage) {
            int n2;
            this.cleanup();
            httpObject2 = (HttpMessage)httpObject;
            HttpHeaders httpHeaders = httpObject2.headers();
            object2 = httpHeaders.get(HttpHeaderNames.CONTENT_ENCODING);
            object2 = object2 != null ? ((String)object2).trim() : ((object = httpHeaders.get(HttpHeaderNames.TRANSFER_ENCODING)) != null ? ((n2 = ((String)object).indexOf(44)) != -1 ? ((String)object).substring(0, n2).trim() : ((String)object).trim()) : IDENTITY);
            this.decoder = this.newContentDecoder((String)object2);
            if (this.decoder == null) {
                if (httpObject2 instanceof HttpContent) {
                    ((HttpContent)httpObject2).retain();
                }
                this.needRead = false;
                channelHandlerContext.fireChannelRead(httpObject2);
                return;
            }
            this.decoder.pipeline().addLast(this.forwarder);
            if (httpHeaders.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                httpHeaders.remove(HttpHeaderNames.CONTENT_LENGTH);
                httpHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            if (HttpHeaderValues.IDENTITY.contentEquals((CharSequence)(object = this.getTargetContentEncoding((String)object2)))) {
                httpHeaders.remove(HttpHeaderNames.CONTENT_ENCODING);
            } else {
                httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, object);
            }
            if (httpObject2 instanceof HttpContent) {
                DefaultHttpMessage defaultHttpMessage;
                if (httpObject2 instanceof HttpRequest) {
                    HttpRequest httpRequest = (HttpRequest)httpObject2;
                    defaultHttpMessage = new DefaultHttpRequest(httpRequest.protocolVersion(), httpRequest.method(), httpRequest.uri());
                } else if (httpObject2 instanceof HttpResponse) {
                    HttpResponse httpResponse = (HttpResponse)httpObject2;
                    defaultHttpMessage = new DefaultHttpResponse(httpResponse.protocolVersion(), httpResponse.status());
                } else {
                    throw new CodecException("Object of class " + httpObject2.getClass().getName() + " is not an HttpRequest or HttpResponse");
                }
                defaultHttpMessage.headers().set(httpObject2.headers());
                defaultHttpMessage.setDecoderResult(httpObject2.decoderResult());
                this.needRead = false;
                channelHandlerContext.fireChannelRead(defaultHttpMessage);
            } else {
                this.needRead = false;
                channelHandlerContext.fireChannelRead(httpObject2);
            }
        }
        if (httpObject instanceof HttpContent) {
            httpObject2 = (HttpContent)httpObject;
            if (this.decoder == null) {
                this.needRead = false;
                channelHandlerContext.fireChannelRead(httpObject2.retain());
            } else {
                this.decoder.writeInbound(httpObject2.content().retain());
                if (httpObject2 instanceof LastHttpContent) {
                    boolean bl2 = this.decoder.finish();
                    this.decoder = null;
                    assert (!bl2);
                    object2 = (LastHttpContent)httpObject2;
                    object = object2.trailingHeaders();
                    this.needRead = false;
                    if (((HttpHeaders)object).isEmpty()) {
                        channelHandlerContext.fireChannelRead(LastHttpContent.EMPTY_LAST_CONTENT);
                    } else {
                        channelHandlerContext.fireChannelRead(new ComposedLastHttpContent((HttpHeaders)object, DecoderResult.SUCCESS));
                    }
                }
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        boolean bl2 = this.needRead;
        this.needRead = true;
        try {
            channelHandlerContext.fireChannelReadComplete();
        }
        finally {
            if (bl2 && !channelHandlerContext.channel().config().isAutoRead()) {
                channelHandlerContext.read();
            }
        }
    }

    protected abstract EmbeddedChannel newContentDecoder(String var1) throws Exception;

    protected String getTargetContentEncoding(String string) throws Exception {
        return IDENTITY;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.cleanupSafely(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.cleanupSafely(channelHandlerContext);
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
        this.forwarder = new ByteBufForwarder(channelHandlerContext);
        super.handlerAdded(channelHandlerContext);
    }

    private void cleanup() {
        if (this.decoder != null) {
            boolean bl2 = this.decoder.finishAndReleaseAll();
            this.decoder = null;
            assert (!bl2);
        }
    }

    private void cleanupSafely(ChannelHandlerContext channelHandlerContext) {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }

    private final class ByteBufForwarder
    extends ChannelInboundHandlerAdapter {
        private final ChannelHandlerContext targetCtx;

        ByteBufForwarder(ChannelHandlerContext channelHandlerContext) {
            this.targetCtx = channelHandlerContext;
        }

        @Override
        public boolean isSharable() {
            return true;
        }

        @Override
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                return;
            }
            HttpContentDecoder.this.needRead = false;
            this.targetCtx.fireChannelRead(new DefaultHttpContent(byteBuf));
        }
    }
}

