/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.internal;

import com.gradle.maven.extension.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;

public abstract class ReferenceCountUpdater<T extends ReferenceCounted> {
    protected ReferenceCountUpdater() {
    }

    protected abstract void safeInitializeRawRefCnt(T var1, int var2);

    protected abstract int getAndAddRawRefCnt(T var1, int var2);

    protected abstract int getRawRefCnt(T var1);

    protected abstract int getAcquireRawRefCnt(T var1);

    protected abstract void setReleaseRawRefCnt(T var1, int var2);

    protected abstract boolean casRawRefCnt(T var1, int var2, int var3);

    public final int initialValue() {
        return 2;
    }

    public final void setInitialValue(T t2) {
        this.safeInitializeRawRefCnt(t2, this.initialValue());
    }

    private static int realRefCnt(int n2) {
        return n2 != 2 && n2 != 4 && (n2 & 1) != 0 ? 0 : n2 >>> 1;
    }

    private static int toLiveRealRefCnt(int n2, int n3) {
        if (n2 == 2 || n2 == 4 || (n2 & 1) == 0) {
            return n2 >>> 1;
        }
        throw new IllegalReferenceCountException(0, -n3);
    }

    public final int refCnt(T t2) {
        return ReferenceCountUpdater.realRefCnt(this.getAcquireRawRefCnt(t2));
    }

    public final boolean isLiveNonVolatile(T t2) {
        int n2 = this.getRawRefCnt(t2);
        return n2 == 2 || n2 == 4 || n2 == 6 || n2 == 8 || (n2 & 1) == 0;
    }

    public final void resetRefCnt(T t2) {
        this.setReleaseRawRefCnt(t2, this.initialValue());
    }

    public final T retain(T t2) {
        return this.retain0(t2, 1, 2);
    }

    private T retain0(T t2, int n2, int n3) {
        int n4 = this.getAndAddRawRefCnt(t2, n3);
        if (n4 != 2 && n4 != 4 && (n4 & 1) != 0) {
            throw new IllegalReferenceCountException(0, n2);
        }
        if (n4 <= 0 && n4 + n3 >= 0 || n4 >= 0 && n4 + n3 < n4) {
            this.getAndAddRawRefCnt(t2, -n3);
            throw new IllegalReferenceCountException(ReferenceCountUpdater.realRefCnt(n4), n2);
        }
        return t2;
    }

    public final boolean release(T t2) {
        int n2 = this.getRawRefCnt(t2);
        return n2 == 2 ? this.tryFinalRelease0(t2, 2) || this.retryRelease0(t2, 1) : this.nonFinalRelease0(t2, 1, n2, ReferenceCountUpdater.toLiveRealRefCnt(n2, 1));
    }

    public final boolean release(T t2, int n2) {
        int n3 = this.getRawRefCnt(t2);
        int n4 = ReferenceCountUpdater.toLiveRealRefCnt(n3, ObjectUtil.checkPositive(n2, "decrement"));
        return n2 == n4 ? this.tryFinalRelease0(t2, n3) || this.retryRelease0(t2, n2) : this.nonFinalRelease0(t2, n2, n3, n4);
    }

    private boolean tryFinalRelease0(T t2, int n2) {
        return this.casRawRefCnt(t2, n2, 1);
    }

    private boolean nonFinalRelease0(T t2, int n2, int n3, int n4) {
        if (n2 < n4 && this.casRawRefCnt(t2, n3, n3 - (n2 << 1))) {
            return false;
        }
        return this.retryRelease0(t2, n2);
    }

    private boolean retryRelease0(T t2, int n2) {
        while (true) {
            int n3;
            int n4;
            if (n2 == (n4 = ReferenceCountUpdater.toLiveRealRefCnt(n3 = this.getRawRefCnt(t2), n2))) {
                if (this.tryFinalRelease0(t2, n3)) {
                    return true;
                }
            } else if (n2 < n4) {
                if (this.casRawRefCnt(t2, n3, n3 - (n2 << 1))) {
                    return false;
                }
            } else {
                throw new IllegalReferenceCountException(n4, -n2);
            }
            Thread.yield();
        }
    }

    public static <T extends ReferenceCounted> UpdaterType updaterTypeOf(Class<T> clazz, String string) {
        long l2 = ReferenceCountUpdater.getUnsafeOffset(clazz, string);
        if (l2 >= 0L) {
            return UpdaterType.Unsafe;
        }
        if (PlatformDependent.hasVarHandle()) {
            return UpdaterType.VarHandle;
        }
        return UpdaterType.Atomic;
    }

    public static long getUnsafeOffset(Class<? extends ReferenceCounted> clazz, String string) {
        try {
            if (PlatformDependent.hasUnsafe()) {
                return PlatformDependent.objectFieldOffset(clazz.getDeclaredField(string));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    public static enum UpdaterType {
        Unsafe,
        VarHandle,
        Atomic;

    }
}

