/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Size64;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.AbstractDoubleList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleComparators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleSpliterators;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.DoubleUnaryOperator;
import java.util.function.UnaryOperator;

public interface DoubleList
extends DoubleCollection,
Comparable<List<? extends Double>>,
List<Double> {
    @Override
    public DoubleListIterator iterator();

    @Override
    default public DoubleSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractDoubleList.IndexBasedSpliterator(this, 0);
        }
        return DoubleSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public DoubleListIterator listIterator();

    public DoubleListIterator listIterator(int var1);

    public DoubleList subList(int var1, int var2);

    public void getElements(int var1, double[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(double[] dArray) {
        this.setElements(0, dArray);
    }

    default public void setElements(int n2, double[] dArray) {
        this.setElements(n2, dArray, 0, dArray.length);
    }

    default public void setElements(int n2, double[] dArray, int n3, int n4) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
        DoubleArrays.ensureOffsetLength(dArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        DoubleListIterator doubleListIterator = this.listIterator(n2);
        int n5 = 0;
        while (n5 < n4) {
            doubleListIterator.nextDouble();
            doubleListIterator.set(dArray[n3 + n5++]);
        }
    }

    @Override
    public boolean add(double var1);

    @Override
    public void add(int var1, double var2);

    @Override
    @Deprecated
    default public void add(int n2, Double d2) {
        this.add(n2, (double)d2);
    }

    @Override
    public double set(int var1, double var2);

    default public void replaceAll(DoubleUnaryOperator doubleUnaryOperator) {
        DoubleListIterator doubleListIterator = this.listIterator();
        while (doubleListIterator.hasNext()) {
            doubleListIterator.set(doubleUnaryOperator.applyAsDouble(doubleListIterator.nextDouble()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Double> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        this.replaceAll(unaryOperator instanceof DoubleUnaryOperator ? (DoubleUnaryOperator)((Object)unaryOperator) : unaryOperator::apply);
    }

    public double getDouble(int var1);

    public int indexOf(double var1);

    public int lastIndexOf(double var1);

    @Override
    @Deprecated
    default public boolean contains(Object object) {
        return DoubleCollection.super.contains(object);
    }

    @Override
    @Deprecated
    default public Double get(int n2) {
        return this.getDouble(n2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object object) {
        return this.indexOf((Double)object);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object object) {
        return this.lastIndexOf((Double)object);
    }

    @Override
    @Deprecated
    default public boolean add(Double d2) {
        return this.add((double)d2);
    }

    public double removeDouble(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object object) {
        return DoubleCollection.super.remove(object);
    }

    @Override
    @Deprecated
    default public Double remove(int n2) {
        return this.removeDouble(n2);
    }

    @Override
    @Deprecated
    default public Double set(int n2, Double d2) {
        return this.set(n2, (double)d2);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Double> comparator) {
        this.sort(DoubleComparators.asDoubleComparator(comparator));
    }

    default public void sort(DoubleComparator doubleComparator) {
        double[] dArray = this.toDoubleArray();
        if (doubleComparator == null) {
            DoubleArrays.stableSort(dArray);
        } else {
            DoubleArrays.stableSort(dArray, doubleComparator);
        }
        this.setElements(dArray);
    }
}

