/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.PathVisitor;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.IOFileFilter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;

public abstract class AbstractFileFilter
implements PathVisitor,
IOFileFilter {
    private final FileVisitResult onAccept;
    private final FileVisitResult onReject;

    static FileVisitResult toDefaultFileVisitResult(boolean bl2) {
        return bl2 ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    public AbstractFileFilter() {
        this(FileVisitResult.CONTINUE, FileVisitResult.TERMINATE);
    }

    protected AbstractFileFilter(FileVisitResult fileVisitResult, FileVisitResult fileVisitResult2) {
        this.onAccept = fileVisitResult;
        this.onReject = fileVisitResult2;
    }

    @Override
    public boolean accept(File file) {
        Objects.requireNonNull(file, "file");
        return this.accept(file.getParentFile(), file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        Objects.requireNonNull(string, "name");
        return this.accept(new File(file, string));
    }

    void append(List<?> list, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i2));
        }
    }

    void append(Object[] objectArray, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(objectArray[i2]);
        }
    }

    boolean isFile(File file) {
        return file != null && file.isFile();
    }

    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        return this.accept(path, basicFileAttributes);
    }

    FileVisitResult toFileVisitResult(boolean bl2) {
        return bl2 ? this.onAccept : this.onReject;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        return this.accept(path, basicFileAttributes);
    }

    public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

