/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ArrayUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect.MemberUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect.MethodUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class ConstructorUtils {
    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> constructor) {
        Objects.requireNonNull(constructor, "ctor");
        return MemberUtils.isAccessible(constructor) && ConstructorUtils.isAccessible(constructor.getDeclaringClass()) ? constructor : null;
    }

    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> clazz, Class<?> ... classArray) {
        Objects.requireNonNull(clazz, "cls");
        try {
            return MemberUtils.setAccessibleWorkaround(clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?>[] constructorArray;
            Constructor<?> constructor = null;
            for (Constructor<?> constructor2 : constructorArray = clazz.getConstructors()) {
                Constructor<?> constructor3;
                if (!MemberUtils.isMatchingConstructor(constructor2, classArray) || (constructor2 = ConstructorUtils.getAccessibleConstructor(constructor2)) == null) continue;
                MemberUtils.setAccessibleWorkaround(constructor2);
                if (constructor != null && MemberUtils.compareConstructorFit(constructor2, constructor, classArray) >= 0) continue;
                constructor = constructor3 = constructor2;
            }
            return constructor;
        }
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        return ConstructorUtils.invokeConstructor(clazz, objectArray2, ClassUtils.toClass(objectArray2));
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        Constructor<T> constructor = ConstructorUtils.getMatchingAccessibleConstructor(clazz, ArrayUtils.nullToEmpty(classArray));
        if (constructor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return constructor.newInstance(MethodUtils.toVarArgs(constructor, objectArray2));
    }

    private static boolean isAccessible(Class<?> clazz) {
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getEnclosingClass()) {
            if (ClassUtils.isPublic(clazz2)) continue;
            return false;
        }
        return true;
    }
}

