/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogConfigurationException;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Hashtable;

public class LogFactoryImpl
extends LogFactory {
    private static final String LOGGING_IMPL_LOG4J_LOGGER = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.Log4JLogger";
    private static final String LOGGING_IMPL_JDK14_LOGGER = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.Jdk14Logger";
    private static final String LOGGING_IMPL_LUMBERJACK_LOGGER = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.Jdk13LumberjackLogger";
    private static final String LOGGING_IMPL_SIMPLE_LOGGER = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.SimpleLog";
    private static final String PKG_IMPL = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.";
    private static final int PKG_LEN = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.".length();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String LOG_PROPERTY = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log";
    protected static final String LOG_PROPERTY_OLD = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.log";
    public static final String ALLOW_FLAWED_CONTEXT_PROPERTY = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log.allowFlawedContext";
    public static final String ALLOW_FLAWED_DISCOVERY_PROPERTY = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log.allowFlawedDiscovery";
    public static final String ALLOW_FLAWED_HIERARCHY_PROPERTY = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log.allowFlawedHierarchy";
    private static final String[] classesToDiscover = new String[]{"com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.Jdk14Logger", "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.SimpleLog"};
    private boolean useTCCL = true;
    private String diagnosticPrefix;
    protected Hashtable<String, Object> attributes = new Hashtable();
    protected Hashtable<String, Log> instances = new Hashtable();
    private String logClassName;
    protected Constructor<?> logConstructor;
    protected Class<?>[] logConstructorSignature = new Class[]{String.class};
    protected Method logMethod;
    protected Class<?>[] logMethodSignature = new Class[]{LogFactory.class};
    private boolean allowFlawedContext;
    private boolean allowFlawedDiscovery;
    private boolean allowFlawedHierarchy;

    protected static ClassLoader getClassLoader(Class<?> clazz) {
        return LogFactory.getClassLoader(clazz);
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        return LogFactory.getContextClassLoader();
    }

    private static ClassLoader getContextClassLoaderInternal() throws LogConfigurationException {
        return AccessController.doPrivileged(() -> LogFactory.directGetContextClassLoader());
    }

    private static String getSystemProperty(String string, String string2) throws SecurityException {
        return AccessController.doPrivileged(() -> System.getProperty(string, string2));
    }

    protected static boolean isDiagnosticsEnabled() {
        return LogFactory.isDiagnosticsEnabled();
    }

    private static String trim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public LogFactoryImpl() {
        this.initDiagnostics();
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Instance created.");
        }
    }

    private Log createLogFromClass(String string, String string2, boolean bl2) throws LogConfigurationException {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Attempting to instantiate '" + string + "'");
        }
        Object[] objectArray = new Object[]{string2};
        Log log = null;
        Constructor<?> constructor = null;
        Serializable serializable = null;
        ClassLoader classLoader = this.getBaseClassLoader();
        while (true) {
            String string3;
            this.logDiagnostic("Trying to load '" + string + "' from class loader " + LogFactoryImpl.objectId(classLoader));
            try {
                Serializable serializable2;
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    string3 = string.replace('.', '/') + ".class";
                    serializable2 = classLoader != null ? classLoader.getResource(string3) : ClassLoader.getSystemResource(string3 + ".class");
                    if (serializable2 == null) {
                        this.logDiagnostic("Class '" + string + "' [" + string3 + "] cannot be found.");
                    } else {
                        this.logDiagnostic("Class '" + string + "' was found at '" + serializable2 + "'");
                    }
                }
                try {
                    serializable2 = Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string4 = classNotFoundException.getMessage();
                    this.logDiagnostic("The log adapter '" + string + "' is not available via class loader " + LogFactoryImpl.objectId(classLoader) + ": " + LogFactoryImpl.trim(string4));
                    try {
                        serializable2 = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        string4 = classNotFoundException2.getMessage();
                        this.logDiagnostic("The log adapter '" + string + "' is not available via the LogFactoryImpl class class loader: " + LogFactoryImpl.trim(string4));
                        break;
                    }
                }
                constructor = serializable2.getConstructor(this.logConstructorSignature);
                string3 = constructor.newInstance(objectArray);
                if (string3 instanceof Log) {
                    serializable = serializable2;
                    log = (Log)((Object)string3);
                    break;
                }
                this.handleFlawedHierarchy(classLoader, (Class<?>)serializable2);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                string3 = noClassDefFoundError.getMessage();
                this.logDiagnostic("The log adapter '" + string + "' is missing dependencies when loaded via class loader " + LogFactoryImpl.objectId(classLoader) + ": " + LogFactoryImpl.trim(string3));
                break;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                string3 = exceptionInInitializerError.getMessage();
                this.logDiagnostic("The log adapter '" + string + "' is unable to initialize itself when loaded via class loader " + LogFactoryImpl.objectId(classLoader) + ": " + LogFactoryImpl.trim(string3));
                break;
            }
            catch (LogConfigurationException logConfigurationException) {
                throw logConfigurationException;
            }
            catch (Throwable throwable) {
                LogFactoryImpl.handleThrowable(throwable);
                this.handleFlawedDiscovery(string, throwable);
            }
            if (classLoader == null) break;
            classLoader = this.getParentClassLoader(classLoader);
        }
        if (serializable != null && bl2) {
            this.logClassName = string;
            this.logConstructor = constructor;
            try {
                this.logMethod = ((Class)serializable).getMethod("setLogFactory", this.logMethodSignature);
                this.logDiagnostic("Found method setLogFactory(LogFactory) in '" + string + "'");
            }
            catch (Throwable throwable) {
                LogFactoryImpl.handleThrowable(throwable);
                this.logMethod = null;
                this.logDiagnostic("[INFO] '" + string + "' from class loader " + LogFactoryImpl.objectId(classLoader) + " does not declare optional method setLogFactory(LogFactory)");
            }
            this.logDiagnostic("Log adapter '" + string + "' from class loader " + LogFactoryImpl.objectId(((Class)serializable).getClassLoader()) + " has been selected for use.");
        }
        return log;
    }

    private Log discoverLogImplementation(String string) throws LogConfigurationException {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Discovering a Log implementation...");
        }
        this.initConfiguration();
        Log log = null;
        String string2 = this.findUserSpecifiedLogClassName();
        if (string2 != null) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Attempting to load user-specified log class '" + string2 + "'...");
            }
            if ((log = this.createLogFromClass(string2, string, true)) == null) {
                StringBuilder stringBuilder = new StringBuilder("User-specified log class '");
                stringBuilder.append(string2);
                stringBuilder.append("' cannot be found or is not useable.");
                this.informUponSimilarName(stringBuilder, string2, LOGGING_IMPL_LOG4J_LOGGER);
                this.informUponSimilarName(stringBuilder, string2, LOGGING_IMPL_JDK14_LOGGER);
                this.informUponSimilarName(stringBuilder, string2, LOGGING_IMPL_LUMBERJACK_LOGGER);
                this.informUponSimilarName(stringBuilder, string2, LOGGING_IMPL_SIMPLE_LOGGER);
                throw new LogConfigurationException(stringBuilder.toString());
            }
            return log;
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("No user-specified Log implementation; performing discovery using the standard supported logging implementations...");
        }
        for (int i2 = 0; i2 < classesToDiscover.length && log == null; ++i2) {
            log = this.createLogFromClass(classesToDiscover[i2], string, true);
        }
        if (log == null) {
            throw new LogConfigurationException("No suitable Log implementation");
        }
        return log;
    }

    private String findUserSpecifiedLogClassName() {
        String string;
        block13: {
            block12: {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Trying to get log class from attribute 'org.apache.commons.logging.Log'");
                }
                if ((string = (String)this.getAttribute(LOG_PROPERTY)) == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("Trying to get log class from attribute 'org.apache.commons.logging.log'");
                    }
                    string = (String)this.getAttribute(LOG_PROPERTY_OLD);
                }
                if (string == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("Trying to get log class from system property 'org.apache.commons.logging.Log'");
                    }
                    try {
                        string = LogFactoryImpl.getSystemProperty(LOG_PROPERTY, null);
                    }
                    catch (SecurityException securityException) {
                        if (!LogFactoryImpl.isDiagnosticsEnabled()) break block12;
                        this.logDiagnostic("No access allowed to system property 'org.apache.commons.logging.Log' - " + securityException.getMessage());
                    }
                }
            }
            if (string == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Trying to get log class from system property 'org.apache.commons.logging.log'");
                }
                try {
                    string = LogFactoryImpl.getSystemProperty(LOG_PROPERTY_OLD, null);
                }
                catch (SecurityException securityException) {
                    if (!LogFactoryImpl.isDiagnosticsEnabled()) break block13;
                    this.logDiagnostic("No access allowed to system property 'org.apache.commons.logging.log' - " + securityException.getMessage());
                }
            }
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    @Override
    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    private ClassLoader getBaseClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = LogFactoryImpl.getClassLoader(LogFactoryImpl.class);
        if (!this.useTCCL) {
            return classLoader;
        }
        ClassLoader classLoader2 = LogFactoryImpl.getContextClassLoaderInternal();
        ClassLoader classLoader3 = this.getLowestClassLoader(classLoader2, classLoader);
        if (classLoader3 == null) {
            if (!this.allowFlawedContext) {
                throw new LogConfigurationException("Bad class loader hierarchy; LogFactoryImpl was loaded via a class loader that is not related to the current context class loader.");
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[WARNING] the context class loader is not part of a parent-child relationship with the class loader that loaded LogFactoryImpl.");
            }
            return classLoader2;
        }
        if (classLoader3 != classLoader2) {
            if (!this.allowFlawedContext) {
                throw new LogConfigurationException("Bad class loader hierarchy; LogFactoryImpl was loaded via a class loader that is not related to the current context class loader.");
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Warning: the context class loader is an ancestor of the class loader that loaded LogFactoryImpl; it should be the same or a descendant. The application using commons-logging should ensure the context class loader is used correctly.");
            }
        }
        return classLoader3;
    }

    private boolean getBooleanConfiguration(String string, boolean bl2) {
        String string2 = this.getConfigurationValue(string);
        if (string2 == null) {
            return bl2;
        }
        return Boolean.parseBoolean(string2);
    }

    private String getConfigurationValue(String string) {
        block10: {
            Object object;
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[ENV] Trying to get configuration for item " + string);
            }
            if ((object = this.getAttribute(string)) != null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[ENV] Found LogFactory attribute [" + object + "] for " + string);
                }
                return object.toString();
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[ENV] No LogFactory attribute found for " + string);
            }
            try {
                String string2 = LogFactoryImpl.getSystemProperty(string, null);
                if (string2 != null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("[ENV] Found system property [" + string2 + "] for " + string);
                    }
                    return string2;
                }
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[ENV] No system property found for property " + string);
                }
            }
            catch (SecurityException securityException) {
                if (!LogFactoryImpl.isDiagnosticsEnabled()) break block10;
                this.logDiagnostic("[ENV] Security prevented reading system property " + string);
            }
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("[ENV] No configuration defined for item " + string);
        }
        return null;
    }

    @Override
    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    @Override
    public Log getInstance(String string) throws LogConfigurationException {
        return this.instances.computeIfAbsent(string, this::newInstance);
    }

    @Deprecated
    protected String getLogClassName() {
        if (this.logClassName == null) {
            this.discoverLogImplementation(this.getClass().getName());
        }
        return this.logClassName;
    }

    @Deprecated
    protected Constructor<?> getLogConstructor() throws LogConfigurationException {
        if (this.logConstructor == null) {
            this.discoverLogImplementation(this.getClass().getName());
        }
        return this.logConstructor;
    }

    private ClassLoader getLowestClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader == null) {
            return classLoader2;
        }
        if (classLoader2 == null) {
            return classLoader;
        }
        ClassLoader classLoader3 = classLoader;
        while (classLoader3 != null) {
            if (classLoader3 == classLoader2) {
                return classLoader;
            }
            classLoader3 = this.getParentClassLoader(classLoader3);
        }
        classLoader3 = classLoader2;
        while (classLoader3 != null) {
            if (classLoader3 == classLoader) {
                return classLoader2;
            }
            classLoader3 = this.getParentClassLoader(classLoader3);
        }
        return null;
    }

    private ClassLoader getParentClassLoader(ClassLoader classLoader) {
        try {
            return AccessController.doPrivileged(() -> classLoader.getParent());
        }
        catch (SecurityException securityException) {
            this.logDiagnostic("[SECURITY] Unable to obtain parent class loader");
            return null;
        }
    }

    private void handleFlawedDiscovery(String string, Throwable throwable) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            InvocationTargetException invocationTargetException;
            Throwable throwable2;
            this.logDiagnostic("Could not instantiate Log '" + string + "' -- " + throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
            if (throwable instanceof InvocationTargetException && (throwable2 = (invocationTargetException = (InvocationTargetException)throwable).getTargetException()) != null) {
                ExceptionInInitializerError exceptionInInitializerError;
                Throwable throwable3;
                this.logDiagnostic("... InvocationTargetException: " + throwable2.getClass().getName() + ": " + throwable2.getLocalizedMessage());
                if (throwable2 instanceof ExceptionInInitializerError && (throwable3 = (exceptionInInitializerError = (ExceptionInInitializerError)throwable2).getCause()) != null) {
                    StringWriter stringWriter = new StringWriter();
                    throwable3.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                    this.logDiagnostic("... ExceptionInInitializerError: " + stringWriter.toString());
                }
            }
        }
        if (!this.allowFlawedDiscovery) {
            throw new LogConfigurationException(throwable);
        }
    }

    private void handleFlawedHierarchy(ClassLoader classLoader, Class<?> clazz) throws LogConfigurationException {
        Object object;
        boolean bl2 = false;
        String string = Log.class.getName();
        Class<?>[] classArray = clazz.getInterfaces();
        for (Class<?> clazz2 : classArray) {
            if (!string.equals(clazz2.getName())) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                try {
                    object = LogFactoryImpl.getClassLoader(Log.class);
                    this.logDiagnostic("Class '" + clazz.getName() + "' was found in class loader " + LogFactoryImpl.objectId(classLoader) + ". It is bound to a Log interface which is not the one loaded from class loader " + LogFactoryImpl.objectId(object));
                }
                catch (Throwable throwable) {
                    LogFactoryImpl.handleThrowable(throwable);
                    this.logDiagnostic("Error while trying to output diagnostics about bad class '" + clazz + "'");
                }
            }
            if (!this.allowFlawedHierarchy) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Terminating logging for this context ");
                ((StringBuilder)object).append("due to bad log hierarchy. ");
                ((StringBuilder)object).append("You have more than one version of '");
                ((StringBuilder)object).append(Log.class.getName());
                ((StringBuilder)object).append("' visible.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(((StringBuilder)object).toString());
                }
                throw new LogConfigurationException(((StringBuilder)object).toString());
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Warning: bad log hierarchy. ");
                ((StringBuilder)object).append("You have more than one version of '");
                ((StringBuilder)object).append(Log.class.getName());
                ((StringBuilder)object).append("' visible.");
                this.logDiagnostic(((StringBuilder)object).toString());
            }
        } else {
            if (!this.allowFlawedDiscovery) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Terminating logging for this context. ");
                ((StringBuilder)object).append("Log class '");
                ((StringBuilder)object).append(clazz.getName());
                ((StringBuilder)object).append("' does not implement the Log interface.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(((StringBuilder)object).toString());
                }
                throw new LogConfigurationException(((StringBuilder)object).toString());
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                object = new StringBuilder();
                ((StringBuilder)object).append("[WARNING] Log class '");
                ((StringBuilder)object).append(clazz.getName());
                ((StringBuilder)object).append("' does not implement the Log interface.");
                this.logDiagnostic(((StringBuilder)object).toString());
            }
        }
    }

    private void informUponSimilarName(StringBuilder stringBuilder, String string, String string2) {
        if (string.equals(string2)) {
            return;
        }
        if (string.regionMatches(true, 0, string2, 0, PKG_LEN + 5)) {
            stringBuilder.append(" Did you mean '");
            stringBuilder.append(string2);
            stringBuilder.append("'?");
        }
    }

    private void initConfiguration() {
        this.allowFlawedContext = this.getBooleanConfiguration(ALLOW_FLAWED_CONTEXT_PROPERTY, true);
        this.allowFlawedDiscovery = this.getBooleanConfiguration(ALLOW_FLAWED_DISCOVERY_PROPERTY, true);
        this.allowFlawedHierarchy = this.getBooleanConfiguration(ALLOW_FLAWED_HIERARCHY_PROPERTY, true);
    }

    private void initDiagnostics() {
        String string;
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = LogFactoryImpl.getClassLoader(clazz);
        try {
            string = classLoader == null ? "BOOTLOADER" : LogFactoryImpl.objectId(classLoader);
        }
        catch (SecurityException securityException) {
            string = "UNKNOWN";
        }
        this.diagnosticPrefix = "[LogFactoryImpl@" + System.identityHashCode(this) + " from " + string + "] ";
    }

    @Deprecated
    protected boolean isJdk13LumberjackAvailable() {
        return this.isLogLibraryAvailable("Jdk13Lumberjack", LOGGING_IMPL_LUMBERJACK_LOGGER);
    }

    @Deprecated
    protected boolean isJdk14Available() {
        return this.isLogLibraryAvailable("Jdk14", LOGGING_IMPL_JDK14_LOGGER);
    }

    @Deprecated
    protected boolean isLog4JAvailable() {
        return this.isLogLibraryAvailable("Log4J", LOGGING_IMPL_LOG4J_LOGGER);
    }

    private boolean isLogLibraryAvailable(String string, String string2) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Checking for '" + string + "'.");
        }
        try {
            Log log = this.createLogFromClass(string2, this.getClass().getName(), false);
            if (log == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Did not find '" + string + "'.");
                }
                return false;
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Found '" + string + "'.");
            }
            return true;
        }
        catch (LogConfigurationException logConfigurationException) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Logging system '" + string + "' is available but not useable.");
            }
            return false;
        }
    }

    protected void logDiagnostic(String string) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            LogFactoryImpl.logRawDiagnostic(this.diagnosticPrefix + string);
        }
    }

    protected Log newInstance(String string) throws LogConfigurationException {
        try {
            Object[] objectArray;
            Log log;
            if (this.logConstructor == null) {
                log = this.discoverLogImplementation(string);
            } else {
                objectArray = new Object[]{string};
                log = (Log)this.logConstructor.newInstance(objectArray);
            }
            if (this.logMethod != null) {
                objectArray = new Object[]{this};
                this.logMethod.invoke((Object)log, objectArray);
            }
            return log;
        }
        catch (LogConfigurationException logConfigurationException) {
            throw logConfigurationException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new LogConfigurationException(throwable == null ? invocationTargetException : throwable);
        }
        catch (Throwable throwable) {
            LogFactoryImpl.handleThrowable(throwable);
            throw new LogConfigurationException(throwable);
        }
    }

    @Override
    public void release() {
        this.logDiagnostic("Releasing all known loggers");
        this.instances.clear();
    }

    @Override
    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.logConstructor != null) {
            this.logDiagnostic("setAttribute: call too late; configuration already performed.");
        }
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
        if (string.equals("use_tccl")) {
            this.useTCCL = object != null && Boolean.parseBoolean(object.toString());
        }
    }
}

