/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockOnDemandEagerReleaseCrossProcessCacheAccess
extends AbstractCrossProcessCacheAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockOnDemandEagerReleaseCrossProcessCacheAccess.class);
    private final String cacheDisplayName;
    private final File lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final Lock stateLock;
    private final Consumer<FileLock> onOpen;
    private final Consumer<FileLock> onClose;
    private final Runnable unlocker;
    private int lockCount;
    private FileLock fileLock;
    private final CacheInitializationAction initAction;

    public LockOnDemandEagerReleaseCrossProcessCacheAccess(String string, File file, LockOptions lockOptions, FileLockManager fileLockManager, Lock lock, CacheInitializationAction cacheInitializationAction, Consumer<FileLock> consumer, Consumer<FileLock> consumer2) {
        this.cacheDisplayName = string;
        this.lockTarget = file;
        this.lockOptions = lockOptions;
        this.lockManager = fileLockManager;
        this.stateLock = lock;
        this.initAction = cacheInitializationAction;
        this.onOpen = consumer;
        this.onClose = consumer2;
        this.unlocker = this::decrementLockCount;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        this.stateLock.lock();
        try {
            if (this.lockCount != 0) {
                throw new IllegalStateException(String.format("Cannot close cache access for %s as it is currently in use for %s operations.", this.cacheDisplayName, this.lockCount));
            }
            this.releaseLockIfHeld();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public <T> T withFileLock(Supplier<T> supplier) {
        this.incrementLockCount();
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            this.decrementLockCount();
        }
    }

    private void incrementLockCount() {
        this.stateLock.lock();
        try {
            if (this.fileLock == null) {
                if (this.lockCount != 0) {
                    throw new IllegalStateException("Mismatched lock count.");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Acquiring file lock for {}", (Object)this.cacheDisplayName);
                }
                this.fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName, "");
                try {
                    if (this.initAction.requiresInitialization(this.fileLock)) {
                        FileLock fileLock = this.fileLock;
                        this.fileLock.writeFile(() -> this.initAction.initialize(fileLock));
                    }
                    this.onOpen.accept(this.fileLock);
                }
                catch (Exception exception) {
                    this.fileLock.close();
                    this.fileLock = null;
                    throw UncheckedException.throwAsUncheckedException(exception);
                }
            }
            ++this.lockCount;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private void decrementLockCount() {
        this.stateLock.lock();
        try {
            if (this.lockCount <= 0 || this.fileLock == null) {
                throw new IllegalStateException("Mismatched lock count.");
            }
            --this.lockCount;
            if (this.lockCount == 0) {
                this.releaseLockIfHeld();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private void releaseLockIfHeld() {
        if (this.fileLock == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Releasing file lock for {}", (Object)this.cacheDisplayName);
        }
        try {
            this.onClose.accept(this.fileLock);
        }
        finally {
            this.fileLock.close();
            this.fileLock = null;
        }
    }

    @Override
    public Runnable acquireFileLock() {
        this.incrementLockCount();
        return this.unlocker;
    }
}

