/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.ValidationContext;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidationProblem;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.text.MessageFormat;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public final class DefaultAttrValue {
    public static final int DEF_DEFAULT = 1;
    public static final int DEF_IMPLIED = 2;
    public static final int DEF_REQUIRED = 3;
    public static final int DEF_FIXED = 4;
    static final DefaultAttrValue sImplied = new DefaultAttrValue(2);
    static final DefaultAttrValue sRequired = new DefaultAttrValue(3);
    final int mDefValueType;
    private String mValue = null;
    private UndeclaredEntity mUndeclaredEntity = null;

    private DefaultAttrValue(int n2) {
        this.mDefValueType = n2;
    }

    public static DefaultAttrValue constructImplied() {
        return sImplied;
    }

    public static DefaultAttrValue constructRequired() {
        return sRequired;
    }

    public static DefaultAttrValue constructFixed() {
        return new DefaultAttrValue(4);
    }

    public static DefaultAttrValue constructOptional() {
        return new DefaultAttrValue(1);
    }

    public void setValue(String string) {
        this.mValue = string;
    }

    public void addUndeclaredPE(String string, Location location) {
        this.addUndeclaredEntity(string, location, true);
    }

    public void addUndeclaredGE(String string, Location location) {
        this.addUndeclaredEntity(string, location, false);
    }

    public void reportUndeclared(ValidationContext validationContext, XMLValidator xMLValidator) throws XMLStreamException {
        this.mUndeclaredEntity.reportUndeclared(validationContext, xMLValidator);
    }

    public boolean hasUndeclaredEntities() {
        return this.mUndeclaredEntity != null;
    }

    public String getValue() {
        return this.mValue;
    }

    public String getValueIfOk() {
        return this.mUndeclaredEntity == null ? this.mValue : null;
    }

    public boolean isRequired() {
        return this == sRequired;
    }

    public boolean isFixed() {
        return this.mDefValueType == 4;
    }

    public boolean hasDefaultValue() {
        return this.mDefValueType == 1 || this.mDefValueType == 4;
    }

    public boolean isSpecial() {
        return this != sImplied;
    }

    private void addUndeclaredEntity(String string, Location location, boolean bl2) {
        if (this.mUndeclaredEntity == null) {
            this.mUndeclaredEntity = new UndeclaredEntity(string, location, bl2);
        }
    }

    static final class UndeclaredEntity {
        final String mName;
        final boolean mIsPe;
        final Location mLocation;

        UndeclaredEntity(String string, Location location, boolean bl2) {
            this.mName = string;
            this.mIsPe = bl2;
            this.mLocation = location;
        }

        public void reportUndeclared(ValidationContext validationContext, XMLValidator xMLValidator) throws XMLStreamException {
            String string = MessageFormat.format(ErrorConsts.ERR_DTD_UNDECLARED_ENTITY, this.mIsPe ? "parsed" : "general", this.mName);
            XMLValidationProblem xMLValidationProblem = new XMLValidationProblem(this.mLocation, string, 3);
            xMLValidationProblem.setReporter(xMLValidator);
            validationContext.reportProblem(xMLValidationProblem);
        }
    }
}

