/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.PropertyAccessor;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonAutoDetect {
    public Visibility getterVisibility() default Visibility.DEFAULT;

    public Visibility isGetterVisibility() default Visibility.DEFAULT;

    public Visibility setterVisibility() default Visibility.DEFAULT;

    public Visibility creatorVisibility() default Visibility.DEFAULT;

    public Visibility scalarConstructorVisibility() default Visibility.DEFAULT;

    public Visibility fieldVisibility() default Visibility.DEFAULT;

    public static class Value
    implements JacksonAnnotationValue<JsonAutoDetect>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Visibility DEFAULT_FIELD_VISIBILITY = Visibility.PUBLIC_ONLY;
        protected static final Value DEFAULT = new Value(DEFAULT_FIELD_VISIBILITY, Visibility.PUBLIC_ONLY, Visibility.PUBLIC_ONLY, Visibility.ANY, Visibility.PUBLIC_ONLY, Visibility.NON_PRIVATE);
        protected static final Value NO_OVERRIDES = new Value(Visibility.DEFAULT, Visibility.DEFAULT, Visibility.DEFAULT, Visibility.DEFAULT, Visibility.DEFAULT, Visibility.DEFAULT);
        protected final Visibility _fieldVisibility;
        protected final Visibility _getterVisibility;
        protected final Visibility _isGetterVisibility;
        protected final Visibility _setterVisibility;
        protected final Visibility _creatorVisibility;
        protected final Visibility _scalarConstructorVisibility;

        private Value(Visibility visibility, Visibility visibility2, Visibility visibility3, Visibility visibility4, Visibility visibility5, Visibility visibility6) {
            this._fieldVisibility = visibility;
            this._getterVisibility = visibility2;
            this._isGetterVisibility = visibility3;
            this._setterVisibility = visibility4;
            this._creatorVisibility = visibility5;
            this._scalarConstructorVisibility = visibility6;
        }

        public static Value defaultVisibility() {
            return DEFAULT;
        }

        public static Value noOverrides() {
            return NO_OVERRIDES;
        }

        public static Value from(JsonAutoDetect jsonAutoDetect) {
            return Value.construct(jsonAutoDetect.fieldVisibility(), jsonAutoDetect.getterVisibility(), jsonAutoDetect.isGetterVisibility(), jsonAutoDetect.setterVisibility(), jsonAutoDetect.creatorVisibility(), jsonAutoDetect.scalarConstructorVisibility());
        }

        public static Value construct(PropertyAccessor propertyAccessor, Visibility visibility) {
            Visibility visibility2 = Visibility.DEFAULT;
            Visibility visibility3 = Visibility.DEFAULT;
            Visibility visibility4 = Visibility.DEFAULT;
            Visibility visibility5 = Visibility.DEFAULT;
            Visibility visibility6 = Visibility.DEFAULT;
            Visibility visibility7 = Visibility.DEFAULT;
            switch (propertyAccessor) {
                case FIELD: {
                    visibility2 = visibility;
                    break;
                }
                case GETTER: {
                    visibility3 = visibility;
                    break;
                }
                case IS_GETTER: {
                    visibility4 = visibility;
                    break;
                }
                case SETTER: {
                    visibility5 = visibility;
                    break;
                }
                case CREATOR: {
                    visibility6 = visibility;
                    break;
                }
                case SCALAR_CONSTRUCTOR: {
                    visibility7 = visibility;
                    break;
                }
                case NONE: {
                    break;
                }
                case ALL: {
                    visibility6 = visibility7 = visibility;
                    visibility5 = visibility7;
                    visibility4 = visibility7;
                    visibility3 = visibility7;
                    visibility2 = visibility7;
                }
            }
            return Value.construct(visibility2, visibility3, visibility4, visibility5, visibility6, visibility7);
        }

        @Deprecated
        public static Value construct(Visibility visibility, Visibility visibility2, Visibility visibility3, Visibility visibility4, Visibility visibility5) {
            return Value.construct(visibility, visibility2, visibility3, visibility4, visibility5, Visibility.DEFAULT);
        }

        public static Value construct(Visibility visibility, Visibility visibility2, Visibility visibility3, Visibility visibility4, Visibility visibility5, Visibility visibility6) {
            Value value = Value._predefined(visibility, visibility2, visibility3, visibility4, visibility5, visibility6);
            if (value == null) {
                value = new Value(visibility, visibility2, visibility3, visibility4, visibility5, visibility6);
            }
            return value;
        }

        public Value withFieldVisibility(Visibility visibility) {
            return Value.construct(visibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility, this._scalarConstructorVisibility);
        }

        public Value withGetterVisibility(Visibility visibility) {
            return Value.construct(this._fieldVisibility, visibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility, this._scalarConstructorVisibility);
        }

        public Value withIsGetterVisibility(Visibility visibility) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, visibility, this._setterVisibility, this._creatorVisibility, this._scalarConstructorVisibility);
        }

        public Value withSetterVisibility(Visibility visibility) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, visibility, this._creatorVisibility, this._scalarConstructorVisibility);
        }

        public Value withCreatorVisibility(Visibility visibility) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, visibility, this._scalarConstructorVisibility);
        }

        public Value withScalarConstructorVisibility(Visibility visibility) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility, visibility);
        }

        public static Value merge(Value value, Value value2) {
            return value == null ? value2 : value.withOverrides(value2);
        }

        public Value withOverrides(Value value) {
            Visibility visibility;
            Visibility visibility2;
            Visibility visibility3;
            Visibility visibility4;
            Visibility visibility5;
            if (value == null || value == NO_OVERRIDES || value == this) {
                return this;
            }
            Visibility visibility6 = Value._override(this._fieldVisibility, value._fieldVisibility);
            if (Value._equals(this, visibility6, visibility5 = Value._override(this._getterVisibility, value._getterVisibility), visibility4 = Value._override(this._isGetterVisibility, value._isGetterVisibility), visibility3 = Value._override(this._setterVisibility, value._setterVisibility), visibility2 = Value._override(this._creatorVisibility, value._creatorVisibility), visibility = Value._override(this._scalarConstructorVisibility, value._scalarConstructorVisibility))) {
                return this;
            }
            return Value.construct(visibility6, visibility5, visibility4, visibility3, visibility2, visibility);
        }

        private static Visibility _override(Visibility visibility, Visibility visibility2) {
            return visibility2 == Visibility.DEFAULT ? visibility : visibility2;
        }

        @Override
        public Class<JsonAutoDetect> valueFor() {
            return JsonAutoDetect.class;
        }

        public Visibility getFieldVisibility() {
            return this._fieldVisibility;
        }

        public Visibility getGetterVisibility() {
            return this._getterVisibility;
        }

        public Visibility getIsGetterVisibility() {
            return this._isGetterVisibility;
        }

        public Visibility getSetterVisibility() {
            return this._setterVisibility;
        }

        public Visibility getCreatorVisibility() {
            return this._creatorVisibility;
        }

        public Visibility getScalarConstructorVisibility() {
            return this._scalarConstructorVisibility;
        }

        protected Object readResolve() {
            Value value = Value._predefined(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility, this._scalarConstructorVisibility);
            return value == null ? this : value;
        }

        public String toString() {
            return String.format("JsonAutoDetect.Value(fields=%s,getters=%s,isGetters=%s,setters=%s,creators=%s,scalarConstructors=%s)", new Object[]{this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility, this._scalarConstructorVisibility});
        }

        public int hashCode() {
            return 1 + this._fieldVisibility.ordinal() ^ 3 * this._getterVisibility.ordinal() - 7 * this._isGetterVisibility.ordinal() + 11 * this._setterVisibility.ordinal() ^ 13 * this._creatorVisibility.ordinal() + 17 * this._scalarConstructorVisibility.ordinal();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Value value = (Value)object;
            return Value._equals(this, value._fieldVisibility, value._getterVisibility, value._isGetterVisibility, value._setterVisibility, value._creatorVisibility, value._scalarConstructorVisibility);
        }

        private static Value _predefined(Visibility visibility, Visibility visibility2, Visibility visibility3, Visibility visibility4, Visibility visibility5, Visibility visibility6) {
            if (visibility == DEFAULT_FIELD_VISIBILITY) {
                if (visibility2 == Value.DEFAULT._getterVisibility && visibility3 == Value.DEFAULT._isGetterVisibility && visibility4 == Value.DEFAULT._setterVisibility && visibility5 == Value.DEFAULT._creatorVisibility && visibility6 == Value.DEFAULT._scalarConstructorVisibility) {
                    return DEFAULT;
                }
            } else if (visibility == Visibility.DEFAULT && visibility2 == Visibility.DEFAULT && visibility3 == Visibility.DEFAULT && visibility4 == Visibility.DEFAULT && visibility5 == Visibility.DEFAULT && visibility6 == Visibility.DEFAULT) {
                return NO_OVERRIDES;
            }
            return null;
        }

        private static boolean _equals(Value value, Visibility visibility, Visibility visibility2, Visibility visibility3, Visibility visibility4, Visibility visibility5, Visibility visibility6) {
            return value._fieldVisibility == visibility && value._getterVisibility == visibility2 && value._isGetterVisibility == visibility3 && value._setterVisibility == visibility4 && value._creatorVisibility == visibility5 && value._scalarConstructorVisibility == visibility6;
        }
    }

    public static enum Visibility {
        ANY,
        NON_PRIVATE,
        PROTECTED_AND_PUBLIC,
        PUBLIC_ONLY,
        NONE,
        DEFAULT;


        public boolean isVisible(Member member) {
            switch (this) {
                case ANY: {
                    return true;
                }
                case NONE: {
                    return false;
                }
                case NON_PRIVATE: {
                    return !Modifier.isPrivate(member.getModifiers());
                }
                case PROTECTED_AND_PUBLIC: {
                    if (Modifier.isProtected(member.getModifiers())) {
                        return true;
                    }
                }
                case PUBLIC_ONLY: {
                    return Modifier.isPublic(member.getModifiers());
                }
            }
            return false;
        }
    }
}

