/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.Multimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Multimaps;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.SetMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;

abstract class AbstractMultimap<K, V>
implements Multimap<K, V> {
    private transient Collection<Map.Entry<K, V>> entries;
    private transient Set<K> keySet;
    private transient Map<K, Collection<V>> asMap;

    AbstractMultimap() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsEntry(Object object, Object object2) {
        Collection<V> collection = this.asMap().get(object);
        return collection != null && collection.contains(object2);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        Collection<V> collection = this.asMap().get(object);
        return collection != null && collection.remove(object2);
    }

    @Override
    public boolean put(K k2, V v2) {
        return this.get(k2).add(v2);
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean bl2 = false;
        for (Map.Entry<K, V> entry : multimap.entries()) {
            bl2 |= this.put(entry.getKey(), entry.getValue());
        }
        return bl2;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> collection = this.entries;
        return collection == null ? (this.entries = this.createEntries()) : collection;
    }

    abstract Collection<Map.Entry<K, V>> createEntries();

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return Spliterators.spliterator(this.entryIterator(), (long)this.size(), this instanceof SetMultimap ? 1 : 0);
    }

    public Set<K> keySet() {
        Set<K> set = this.keySet;
        return set == null ? (this.keySet = this.createKeySet()) : set;
    }

    abstract Set<K> createKeySet();

    @Override
    public Map<K, Collection<V>> asMap() {
        Map<K, Collection<Collection<V>>> map = this.asMap;
        return map == null ? (this.asMap = this.createAsMap()) : map;
    }

    abstract Map<K, Collection<V>> createAsMap();

    public boolean equals(Object object) {
        return Multimaps.equalsImpl(this, object);
    }

    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    class EntrySet
    extends Entries
    implements Set<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        @Override
        public boolean equals(Object object) {
            return Sets.equalsImpl(this, object);
        }
    }

    class Entries
    extends Multimaps.Entries<K, V> {
        Entries() {
        }

        @Override
        Multimap<K, V> multimap() {
            return AbstractMultimap.this;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractMultimap.this.entryIterator();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return AbstractMultimap.this.entrySpliterator();
        }
    }
}

