/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.SwappedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledDuplicatedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledSlicedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.maven.extension.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakDetector;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakDetectorFactory;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.MathUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public abstract class AbstractByteBuf
extends ByteBuf {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractByteBuf.class);
    static final boolean checkAccessible = SystemPropertyUtil.contains("com.gradle.maven.extension.internal.dep.io.netty.buffer.checkAccessible") ? SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.buffer.checkAccessible", true) : SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.buffer.bytebuf.checkAccessible", true);
    private static final boolean checkBounds = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.buffer.checkBounds", true);
    static final ResourceLeakDetector<ByteBuf> leakDetector;
    int readerIndex;
    int writerIndex;
    private int markedReaderIndex;
    private int markedWriterIndex;
    private int maxCapacity;

    protected AbstractByteBuf(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "maxCapacity");
        this.maxCapacity = n2;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuf asReadOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return Unpooled.unmodifiableBuffer(this);
    }

    @Override
    public int maxCapacity() {
        return this.maxCapacity;
    }

    protected final void maxCapacity(int n2) {
        this.maxCapacity = n2;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    private static void checkIndexBounds(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > n3 || n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected: 0 <= readerIndex <= writerIndex <= capacity(%d))", n2, n3, n4));
        }
    }

    @Override
    public ByteBuf readerIndex(int n2) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(n2, this.writerIndex, this.capacity());
        }
        this.readerIndex = n2;
        return this;
    }

    @Override
    public int writerIndex() {
        return this.writerIndex;
    }

    @Override
    public ByteBuf writerIndex(int n2) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(this.readerIndex, n2, this.capacity());
        }
        this.writerIndex = n2;
        return this;
    }

    @Override
    public ByteBuf setIndex(int n2, int n3) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(n2, n3, this.capacity());
        }
        this.setIndex0(n2, n3);
        return this;
    }

    @Override
    public ByteBuf clear() {
        this.writerIndex = 0;
        this.readerIndex = 0;
        return this;
    }

    @Override
    public boolean isReadable() {
        return this.writerIndex > this.readerIndex;
    }

    @Override
    public boolean isWritable() {
        return this.capacity() > this.writerIndex;
    }

    @Override
    public boolean isWritable(int n2) {
        return this.capacity() - this.writerIndex >= n2;
    }

    @Override
    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    @Override
    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    @Override
    public int maxWritableBytes() {
        return this.maxCapacity() - this.writerIndex;
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.readerIndex(this.markedReaderIndex);
        return this;
    }

    public ByteBuf markWriterIndex() {
        this.markedWriterIndex = this.writerIndex;
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        if (this.readerIndex > 0) {
            if (this.readerIndex == this.writerIndex) {
                this.ensureAccessible();
                this.adjustMarkers(this.readerIndex);
                this.readerIndex = 0;
                this.writerIndex = 0;
                return this;
            }
            if (this.readerIndex >= this.capacity() >>> 1) {
                this.setBytes(0, this, this.readerIndex, this.writerIndex - this.readerIndex);
                this.writerIndex -= this.readerIndex;
                this.adjustMarkers(this.readerIndex);
                this.readerIndex = 0;
                return this;
            }
        }
        this.ensureAccessible();
        return this;
    }

    protected final void adjustMarkers(int n2) {
        if (this.markedReaderIndex <= n2) {
            this.markedReaderIndex = 0;
            this.markedWriterIndex = this.markedWriterIndex <= n2 ? 0 : (this.markedWriterIndex -= n2);
        } else {
            this.markedReaderIndex -= n2;
            this.markedWriterIndex -= n2;
        }
    }

    protected final void trimIndicesToCapacity(int n2) {
        if (this.writerIndex() > n2) {
            this.setIndex0(Math.min(this.readerIndex(), n2), n2);
        }
    }

    @Override
    public ByteBuf ensureWritable(int n2) {
        this.ensureWritable0(ObjectUtil.checkPositiveOrZero(n2, "minWritableBytes"));
        return this;
    }

    final void ensureWritable0(int n2) {
        int n3 = this.writerIndex();
        int n4 = n3 + n2;
        if (n4 >= 0 & n4 <= this.capacity()) {
            this.ensureAccessible();
            return;
        }
        if (checkBounds && (n4 < 0 || n4 > this.maxCapacity)) {
            this.ensureAccessible();
            throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + minWritableBytes(%d) exceeds maxCapacity(%d): %s", n3, n2, this.maxCapacity, this));
        }
        int n5 = this.maxFastWritableBytes();
        int n6 = n5 >= n2 ? n3 + n5 : this.alloc().calculateNewCapacity(n4, this.maxCapacity);
        this.capacity(n6);
    }

    @Override
    public int ensureWritable(int n2, boolean bl2) {
        int n3;
        this.ensureAccessible();
        ObjectUtil.checkPositiveOrZero(n2, "minWritableBytes");
        if (n2 <= this.writableBytes()) {
            return 0;
        }
        int n4 = this.maxCapacity();
        if (n2 > n4 - (n3 = this.writerIndex())) {
            if (!bl2 || this.capacity() == n4) {
                return 1;
            }
            this.capacity(n4);
            return 3;
        }
        int n5 = this.maxFastWritableBytes();
        int n6 = n5 >= n2 ? n3 + n5 : this.alloc().calculateNewCapacity(n3 + n2, n4);
        this.capacity(n6);
        return 2;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == this.order()) {
            return this;
        }
        ObjectUtil.checkNotNull(byteOrder, "endianness");
        return this.newSwappedByteBuf();
    }

    protected SwappedByteBuf newSwappedByteBuf() {
        return new SwappedByteBuf(this);
    }

    @Override
    public byte getByte(int n2) {
        this.checkIndex(n2);
        return this._getByte(n2);
    }

    protected abstract byte _getByte(int var1);

    @Override
    public short getUnsignedByte(int n2) {
        return (short)(this.getByte(n2) & 0xFF);
    }

    @Override
    public short getShort(int n2) {
        this.checkIndex(n2, 2);
        return this._getShort(n2);
    }

    protected abstract short _getShort(int var1);

    @Override
    public short getShortLE(int n2) {
        this.checkIndex(n2, 2);
        return this._getShortLE(n2);
    }

    protected abstract short _getShortLE(int var1);

    @Override
    public int getUnsignedShort(int n2) {
        return this.getShort(n2) & 0xFFFF;
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.checkIndex(n2, 3);
        return this._getUnsignedMedium(n2);
    }

    protected abstract int _getUnsignedMedium(int var1);

    @Override
    public int getUnsignedMediumLE(int n2) {
        this.checkIndex(n2, 3);
        return this._getUnsignedMediumLE(n2);
    }

    protected abstract int _getUnsignedMediumLE(int var1);

    @Override
    public int getMedium(int n2) {
        int n3 = this.getUnsignedMedium(n2);
        if ((n3 & 0x800000) != 0) {
            n3 |= 0xFF000000;
        }
        return n3;
    }

    @Override
    public int getMediumLE(int n2) {
        int n3 = this.getUnsignedMediumLE(n2);
        if ((n3 & 0x800000) != 0) {
            n3 |= 0xFF000000;
        }
        return n3;
    }

    @Override
    public int getInt(int n2) {
        this.checkIndex(n2, 4);
        return this._getInt(n2);
    }

    protected abstract int _getInt(int var1);

    @Override
    public int getIntLE(int n2) {
        this.checkIndex(n2, 4);
        return this._getIntLE(n2);
    }

    protected abstract int _getIntLE(int var1);

    @Override
    public long getUnsignedInt(int n2) {
        return (long)this.getInt(n2) & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedIntLE(int n2) {
        return (long)this.getIntLE(n2) & 0xFFFFFFFFL;
    }

    @Override
    public long getLong(int n2) {
        this.checkIndex(n2, 8);
        return this._getLong(n2);
    }

    protected abstract long _getLong(int var1);

    @Override
    public long getLongLE(int n2) {
        this.checkIndex(n2, 8);
        return this._getLongLE(n2);
    }

    protected abstract long _getLongLE(int var1);

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray) {
        this.getBytes(n2, byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        this.checkIndex(n2);
        this._setByte(n2, n3);
        return this;
    }

    protected abstract void _setByte(int var1, int var2);

    @Override
    public ByteBuf setShort(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShort(n2, n3);
        return this;
    }

    protected abstract void _setShort(int var1, int var2);

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMedium(n2, n3);
        return this;
    }

    protected abstract void _setMedium(int var1, int var2);

    @Override
    public ByteBuf setInt(int n2, int n3) {
        this.checkIndex(n2, 4);
        this._setInt(n2, n3);
        return this;
    }

    protected abstract void _setInt(int var1, int var2);

    @Override
    public ByteBuf setLong(int n2, long l2) {
        this.checkIndex(n2, 8);
        this._setLong(n2, l2);
        return this;
    }

    protected abstract void _setLong(int var1, long var2);

    public ByteBuf setBytes(int n2, byte[] byArray) {
        this.setBytes(n2, byArray, 0, byArray.length);
        return this;
    }

    private static void checkReadableBounds(ByteBuf byteBuf, int n2) {
        if (n2 > byteBuf.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", n2, byteBuf.readableBytes(), byteBuf));
        }
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return this;
        }
        this.checkIndex(n2, n3);
        int n5 = n3 >>> 3;
        int n6 = n3 & 7;
        for (n4 = n5; n4 > 0; --n4) {
            this._setLong(n2, 0L);
            n2 += 8;
        }
        if (n6 == 4) {
            this._setInt(n2, 0);
        } else if (n6 < 4) {
            for (n4 = n6; n4 > 0; --n4) {
                this._setByte(n2, 0);
                ++n2;
            }
        } else {
            this._setInt(n2, 0);
            n2 += 4;
            for (n4 = n6 - 4; n4 > 0; --n4) {
                this._setByte(n2, 0);
                ++n2;
            }
        }
        return this;
    }

    @Override
    public int setCharSequence(int n2, CharSequence charSequence, Charset charset) {
        return this.setCharSequence0(n2, charSequence, charset, false);
    }

    private int setCharSequence0(int n2, CharSequence charSequence, Charset charset, boolean bl2) {
        if (charset.equals(CharsetUtil.UTF_8)) {
            int n3 = ByteBufUtil.utf8MaxBytes(charSequence);
            if (bl2) {
                this.ensureWritable0(n3);
                this.checkIndex0(n2, n3);
            } else {
                this.checkIndex(n2, n3);
            }
            return ByteBufUtil.writeUtf8(this, n2, n3, charSequence, charSequence.length());
        }
        if (charset.equals(CharsetUtil.US_ASCII) || charset.equals(CharsetUtil.ISO_8859_1)) {
            int n4 = charSequence.length();
            if (bl2) {
                this.ensureWritable0(n4);
                this.checkIndex0(n2, n4);
            } else {
                this.checkIndex(n2, n4);
            }
            return ByteBufUtil.writeAscii(this, n2, charSequence, n4);
        }
        byte[] byArray = charSequence.toString().getBytes(charset);
        if (bl2) {
            this.ensureWritable0(byArray.length);
        }
        this.setBytes(n2, byArray);
        return byArray.length;
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes0(1);
        int n2 = this.readerIndex;
        byte by2 = this._getByte(n2);
        this.readerIndex = n2 + 1;
        return by2;
    }

    @Override
    public short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public short readShort() {
        this.checkReadableBytes0(2);
        short s2 = this._getShort(this.readerIndex);
        this.readerIndex += 2;
        return s2;
    }

    @Override
    public short readShortLE() {
        this.checkReadableBytes0(2);
        short s2 = this._getShortLE(this.readerIndex);
        this.readerIndex += 2;
        return s2;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShortLE() {
        return this.readShortLE() & 0xFFFF;
    }

    @Override
    public int readMediumLE() {
        int n2 = this.readUnsignedMediumLE();
        if ((n2 & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        return n2;
    }

    @Override
    public int readUnsignedMediumLE() {
        this.checkReadableBytes0(3);
        int n2 = this._getUnsignedMediumLE(this.readerIndex);
        this.readerIndex += 3;
        return n2;
    }

    @Override
    public int readInt() {
        this.checkReadableBytes0(4);
        int n2 = this._getInt(this.readerIndex);
        this.readerIndex += 4;
        return n2;
    }

    @Override
    public int readIntLE() {
        this.checkReadableBytes0(4);
        int n2 = this._getIntLE(this.readerIndex);
        this.readerIndex += 4;
        return n2;
    }

    @Override
    public long readUnsignedIntLE() {
        return (long)this.readIntLE() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        this.checkReadableBytes0(8);
        long l2 = this._getLong(this.readerIndex);
        this.readerIndex += 8;
        return l2;
    }

    @Override
    public ByteBuf readBytes(int n2) {
        this.checkReadableBytes(n2);
        if (n2 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf byteBuf = this.alloc().buffer(n2, this.maxCapacity);
        byteBuf.writeBytes(this, this.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    @Override
    public ByteBuf readSlice(int n2) {
        this.checkReadableBytes(n2);
        ByteBuf byteBuf = this.slice(this.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    @Override
    public ByteBuf readRetainedSlice(int n2) {
        this.checkReadableBytes(n2);
        ByteBuf byteBuf = this.retainedSlice(this.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.getBytes(this.readerIndex, byArray, n2, n3);
        this.readerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray) {
        this.readBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf) {
        this.readBytes(byteBuf, byteBuf.writableBytes());
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2) {
        if (checkBounds && n2 > byteBuf.writableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds dst.writableBytes(%d) where dst is: %s", n2, byteBuf.writableBytes(), byteBuf));
        }
        this.readBytes(byteBuf, byteBuf.writerIndex(), n2);
        byteBuf.writerIndex(byteBuf.writerIndex() + n2);
        return this;
    }

    public ByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.getBytes(this.readerIndex, byteBuf, n2, n3);
        this.readerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        this.getBytes(this.readerIndex, byteBuffer);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) throws IOException {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, gatheringByteChannel, n2);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public ByteBuf skipBytes(int n2) {
        this.checkReadableBytes(n2);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf writeBoolean(boolean bl2) {
        this.writeByte(bl2 ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf writeByte(int n2) {
        this.ensureWritable0(1);
        this._setByte(this.writerIndex++, n2);
        return this;
    }

    @Override
    public ByteBuf writeShort(int n2) {
        this.ensureWritable0(2);
        this._setShort(this.writerIndex, n2);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeMedium(int n2) {
        this.ensureWritable0(3);
        this._setMedium(this.writerIndex, n2);
        this.writerIndex += 3;
        return this;
    }

    @Override
    public ByteBuf writeInt(int n2) {
        this.ensureWritable0(4);
        this._setInt(this.writerIndex, n2);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long l2) {
        this.ensureWritable0(8);
        this._setLong(this.writerIndex, l2);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeChar(int n2) {
        this.writeShort(n2);
        return this;
    }

    @Override
    public ByteBuf writeFloat(float f2) {
        this.writeInt(Float.floatToRawIntBits(f2));
        return this;
    }

    @Override
    public ByteBuf writeDouble(double d2) {
        this.writeLong(Double.doubleToRawLongBits(d2));
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        this.ensureWritable(n3);
        this.setBytes(this.writerIndex, byArray, n2, n3);
        this.writerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray) {
        this.writeBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf) {
        this.writeBytes(byteBuf, byteBuf.readableBytes());
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        if (checkBounds) {
            AbstractByteBuf.checkReadableBounds(byteBuf, n2);
        }
        this.writeBytes(byteBuf, byteBuf.readerIndex(), n2);
        byteBuf.readerIndex(byteBuf.readerIndex() + n2);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        this.ensureWritable(n3);
        this.setBytes(this.writerIndex, byteBuf, n2, n3);
        this.writerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.ensureWritable0(n2);
        this.setBytes(this.writerIndex, byteBuffer);
        this.writerIndex += n2;
        return this;
    }

    @Override
    public int writeBytes(InputStream inputStream, int n2) throws IOException {
        this.ensureWritable(n2);
        int n3 = this.setBytes(this.writerIndex, inputStream, n2);
        if (n3 > 0) {
            this.writerIndex += n3;
        }
        return n3;
    }

    @Override
    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) throws IOException {
        this.ensureWritable(n2);
        int n3 = this.setBytes(this.writerIndex, scatteringByteChannel, n2);
        if (n3 > 0) {
            this.writerIndex += n3;
        }
        return n3;
    }

    @Override
    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        int n2 = this.setCharSequence0(this.writerIndex, charSequence, charset, true);
        this.writerIndex += n2;
        return n2;
    }

    @Override
    public ByteBuf duplicate() {
        this.ensureAccessible();
        return new UnpooledDuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.duplicate().retain();
    }

    @Override
    public ByteBuf slice() {
        return this.slice(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuf retainedSlice() {
        return this.slice().retain();
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        this.ensureAccessible();
        return new UnpooledSlicedByteBuf(this, n2, n3);
    }

    public ByteBuf retainedSlice(int n2, int n3) {
        return this.slice(n2, n3).retain();
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex, this.readableBytes());
    }

    @Override
    public String toString(Charset charset) {
        return this.toString(this.readerIndex, this.readableBytes(), charset);
    }

    @Override
    public String toString(int n2, int n3, Charset charset) {
        return ByteBufUtil.decodeString(this, n2, n3, charset);
    }

    @Override
    public int indexOf(int n2, int n3, byte by2) {
        if (n2 <= n3) {
            return ByteBufUtil.firstIndexOf(this, n2, n3, by2);
        }
        return ByteBufUtil.lastIndexOf(this, n2, n3, by2);
    }

    @Override
    public int forEachByte(ByteProcessor byteProcessor) {
        this.ensureAccessible();
        try {
            return this.forEachByteAsc0(this.readerIndex, this.writerIndex, byteProcessor);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    @Override
    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        this.checkIndex(n2, n3);
        try {
            return this.forEachByteAsc0(n2, n2 + n3, byteProcessor);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    int forEachByteAsc0(int n2, int n3, ByteProcessor byteProcessor) throws Exception {
        while (n2 < n3) {
            if (!byteProcessor.process(this._getByte(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return ByteBufUtil.hashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ByteBuf && ByteBufUtil.equals(this, (ByteBuf)object);
    }

    @Override
    public int compareTo(ByteBuf byteBuf) {
        return ByteBufUtil.compare(this, byteBuf);
    }

    @Override
    public String toString() {
        ByteBuf byteBuf;
        if (this.refCnt() == 0) {
            return StringUtil.simpleClassName(this) + "(freed)";
        }
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append("(ridx: ").append(this.readerIndex).append(", widx: ").append(this.writerIndex).append(", cap: ").append(this.capacity());
        if (this.maxCapacity != Integer.MAX_VALUE) {
            stringBuilder.append('/').append(this.maxCapacity);
        }
        if ((byteBuf = this.unwrap()) != null) {
            stringBuilder.append(", unwrapped: ").append(byteBuf);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    protected final void checkIndex(int n2) {
        this.checkIndex(n2, 1);
    }

    protected final void checkIndex(int n2, int n3) {
        this.ensureAccessible();
        this.checkIndex0(n2, n3);
    }

    private static void checkRangeBoundsTrustedCapacity(String string, int n2, int n3, int n4) {
        if (AbstractByteBuf.isOutOfBoundsTrustedCapacity(n2, n3, n4)) {
            AbstractByteBuf.rangeBoundsCheckFailed(string, n2, n3, n4);
        }
    }

    private static boolean isOutOfBoundsTrustedCapacity(int n2, int n3, int n4) {
        return n2 < 0 || n3 < 0 || n2 + n3 < 0 || n2 + n3 > n4;
    }

    private static void checkRangeBounds(String string, int n2, int n3, int n4) {
        if (MathUtil.isOutOfBounds(n2, n3, n4)) {
            AbstractByteBuf.rangeBoundsCheckFailed(string, n2, n3, n4);
        }
    }

    private static void rangeBoundsCheckFailed(String string, int n2, int n3, int n4) {
        throw new IndexOutOfBoundsException(String.format("%s: %d, length: %d (expected: range(0, %d))", string, n2, n3, n4));
    }

    final void checkIndex0(int n2, int n3) {
        if (checkBounds) {
            AbstractByteBuf.checkRangeBoundsTrustedCapacity("index", n2, n3, this.capacity());
        }
    }

    protected final void checkSrcIndex(int n2, int n3, int n4, int n5) {
        this.checkIndex(n2, n3);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("srcIndex", n4, n3, n5);
        }
    }

    protected final void checkDstIndex(int n2, int n3, int n4, int n5) {
        this.checkIndex(n2, n3);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("dstIndex", n4, n3, n5);
        }
    }

    protected final void checkDstIndex(int n2, int n3, int n4) {
        this.checkReadableBytes(n2);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("dstIndex", n3, n2, n4);
        }
    }

    protected final void checkReadableBytes(int n2) {
        this.checkReadableBytes0(ObjectUtil.checkPositiveOrZero(n2, "minimumReadableBytes"));
    }

    protected final void checkNewCapacity(int n2) {
        this.ensureAccessible();
        if (checkBounds && (n2 < 0 || n2 > this.maxCapacity())) {
            throw new IllegalArgumentException("newCapacity: " + n2 + " (expected: 0-" + this.maxCapacity() + ')');
        }
    }

    private void checkReadableBytes0(int n2) {
        this.ensureAccessible();
        if (checkBounds && this.readerIndex > this.writerIndex - n2) {
            throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d): %s", this.readerIndex, n2, this.writerIndex, this));
        }
    }

    protected final void ensureAccessible() {
        if (checkAccessible && !this.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
    }

    final void setIndex0(int n2, int n3) {
        this.readerIndex = n2;
        this.writerIndex = n3;
    }

    final void discardMarks() {
        this.markedWriterIndex = 0;
        this.markedReaderIndex = 0;
    }

    long _memoryAddress() {
        return this.isAccessible() && this.hasMemoryAddress() ? this.memoryAddress() : 0L;
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)"com.gradle.maven.extension.internal.dep.io.netty.buffer.checkAccessible", (Object)checkAccessible);
            logger.debug("-D{}: {}", (Object)"com.gradle.maven.extension.internal.dep.io.netty.buffer.checkBounds", (Object)checkBounds);
        }
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ByteBuf.class);
    }
}

