/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.VoidChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PromiseNotificationUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class DelegatingChannelPromiseNotifier
implements ChannelFutureListener,
ChannelPromise {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DelegatingChannelPromiseNotifier.class);
    private final ChannelPromise delegate;
    private final boolean logNotifyFailure;

    public DelegatingChannelPromiseNotifier(ChannelPromise channelPromise) {
        this(channelPromise, !(channelPromise instanceof VoidChannelPromise));
    }

    public DelegatingChannelPromiseNotifier(ChannelPromise channelPromise, boolean bl2) {
        this.delegate = ObjectUtil.checkNotNull(channelPromise, "delegate");
        this.logNotifyFailure = bl2;
    }

    @Override
    public void operationComplete(ChannelFuture channelFuture) throws Exception {
        InternalLogger internalLogger;
        InternalLogger internalLogger2 = internalLogger = this.logNotifyFailure ? logger : null;
        if (channelFuture.isSuccess()) {
            Void void_ = (Void)channelFuture.get();
            PromiseNotificationUtil.trySuccess(this.delegate, void_, internalLogger);
        } else if (channelFuture.isCancelled()) {
            PromiseNotificationUtil.tryCancel(this.delegate, internalLogger);
        } else {
            Throwable throwable = channelFuture.cause();
            PromiseNotificationUtil.tryFailure(this.delegate, throwable, internalLogger);
        }
    }

    @Override
    public Channel channel() {
        return this.delegate.channel();
    }

    @Override
    public ChannelPromise setSuccess(Void void_) {
        this.delegate.setSuccess(void_);
        return this;
    }

    @Override
    public ChannelPromise setSuccess() {
        this.delegate.setSuccess();
        return this;
    }

    @Override
    public boolean trySuccess() {
        return this.delegate.trySuccess();
    }

    @Override
    public boolean trySuccess(Void void_) {
        return this.delegate.trySuccess(void_);
    }

    @Override
    public ChannelPromise setFailure(Throwable throwable) {
        this.delegate.setFailure(throwable);
        return this;
    }

    @Override
    public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        this.delegate.addListener((GenericFutureListener)genericFutureListener);
        return this;
    }

    @Override
    public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        this.delegate.removeListener((GenericFutureListener)genericFutureListener);
        return this;
    }

    @Override
    public boolean tryFailure(Throwable throwable) {
        return this.delegate.tryFailure(throwable);
    }

    @Override
    public boolean setUncancellable() {
        return this.delegate.setUncancellable();
    }

    @Override
    public ChannelPromise await() throws InterruptedException {
        this.delegate.await();
        return this;
    }

    @Override
    public boolean isVoid() {
        return this.delegate.isVoid();
    }

    @Override
    public ChannelPromise unvoid() {
        return this.isVoid() ? new DelegatingChannelPromiseNotifier(this.delegate.unvoid()) : this;
    }

    @Override
    public boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.await(l2, timeUnit);
    }

    @Override
    public Void getNow() {
        return (Void)this.delegate.getNow();
    }

    @Override
    public boolean cancel(boolean bl2) {
        return this.delegate.cancel(bl2);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        return (Void)this.delegate.get();
    }

    @Override
    public Void get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return (Void)this.delegate.get(l2, timeUnit);
    }

    @Override
    public ChannelPromise syncUninterruptibly() {
        this.delegate.syncUninterruptibly();
        return this;
    }

    @Override
    public boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    @Override
    public Throwable cause() {
        return this.delegate.cause();
    }
}

