/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.DefaultHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.Headers;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.ValueConverter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaderNames;
import com.gradle.maven.extension.internal.dep.io.netty.util.AsciiString;
import com.gradle.maven.extension.internal.dep.io.netty.util.HashingStrategy;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CombinedHttpHeaders
extends DefaultHttpHeaders {
    CombinedHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
        super(new CombinedHttpHeadersImpl(AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(), ObjectUtil.checkNotNull(nameValidator, "nameValidator"), ObjectUtil.checkNotNull(valueValidator, "valueValidator")));
    }

    @Override
    public boolean containsValue(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        return super.containsValue(charSequence, StringUtil.trimOws(charSequence2), bl2);
    }

    private static final class CombinedHttpHeadersImpl
    extends DefaultHeaders<CharSequence, CharSequence, CombinedHttpHeadersImpl> {
        private CsvValueEscaper<Object> objectEscaper;
        private CsvValueEscaper<CharSequence> charSequenceEscaper;

        private CsvValueEscaper<Object> objectEscaper() {
            if (this.objectEscaper == null) {
                this.objectEscaper = new CsvValueEscaper<Object>(){

                    @Override
                    public CharSequence escape(CharSequence charSequence, Object object) {
                        CharSequence charSequence2;
                        try {
                            charSequence2 = (CharSequence)this.valueConverter().convertObject(object);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new IllegalArgumentException("Failed to convert object value for header '" + charSequence + '\'', illegalArgumentException);
                        }
                        return StringUtil.escapeCsv(charSequence2, true);
                    }
                };
            }
            return this.objectEscaper;
        }

        private CsvValueEscaper<CharSequence> charSequenceEscaper() {
            if (this.charSequenceEscaper == null) {
                this.charSequenceEscaper = new CsvValueEscaper<CharSequence>(){

                    @Override
                    public CharSequence escape(CharSequence charSequence, CharSequence charSequence2) {
                        return StringUtil.escapeCsv(charSequence2, true);
                    }
                };
            }
            return this.charSequenceEscaper;
        }

        CombinedHttpHeadersImpl(HashingStrategy<CharSequence> hashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
            this(hashingStrategy, valueConverter, nameValidator, valueValidator, 16);
        }

        CombinedHttpHeadersImpl(HashingStrategy<CharSequence> hashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, int n2) {
            super(hashingStrategy, valueConverter, nameValidator, n2, valueValidator);
        }

        @Override
        public Iterator<CharSequence> valueIterator(CharSequence charSequence) {
            Iterator<CharSequence> iterator = super.valueIterator(charSequence);
            if (!iterator.hasNext() || CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
                return iterator;
            }
            Iterator<CharSequence> iterator2 = StringUtil.unescapeCsvFields(iterator.next()).iterator();
            if (iterator.hasNext()) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return iterator2;
        }

        @Override
        public List<CharSequence> getAll(CharSequence charSequence) {
            List<CharSequence> list = super.getAll(charSequence);
            if (list.isEmpty() || CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
                return list;
            }
            if (list.size() != 1) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return StringUtil.unescapeCsvFields(list.get(0));
        }

        @Override
        public CombinedHttpHeadersImpl add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                throw new IllegalArgumentException("can't add to itself.");
            }
            if (headers instanceof CombinedHttpHeadersImpl) {
                if (this.isEmpty()) {
                    this.addImpl(headers);
                } else {
                    for (Map.Entry<CharSequence, CharSequence> entry : headers) {
                        this.addEscapedValue(entry.getKey(), entry.getValue());
                    }
                }
            } else {
                for (Map.Entry<CharSequence, CharSequence> entry : headers) {
                    this.add(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                return this;
            }
            this.clear();
            return this.add((Headers)headers);
        }

        @Override
        public CombinedHttpHeadersImpl add(CharSequence charSequence, CharSequence charSequence2) {
            return this.addEscapedValue(charSequence, this.charSequenceEscaper().escape(charSequence, charSequence2));
        }

        @Override
        public CombinedHttpHeadersImpl addObject(CharSequence charSequence, Object object) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), object));
        }

        @Override
        public CombinedHttpHeadersImpl setObject(CharSequence charSequence, Object object) {
            this.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), object));
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl setObject(CharSequence charSequence, Iterable<?> iterable) {
            this.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), iterable));
            return this;
        }

        private static boolean cannotBeCombined(CharSequence charSequence) {
            return HttpHeaderNames.SET_COOKIE.contentEqualsIgnoreCase(charSequence);
        }

        private CombinedHttpHeadersImpl addEscapedValue(CharSequence charSequence, CharSequence charSequence2) {
            CharSequence charSequence3 = (CharSequence)this.get(charSequence);
            if (charSequence3 == null || CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
                super.add(charSequence, charSequence2);
            } else {
                this.set(charSequence, CombinedHttpHeadersImpl.commaSeparateEscapedValues(charSequence3, charSequence2));
            }
            return this;
        }

        private static <T> CharSequence commaSeparate(CharSequence charSequence, CsvValueEscaper<T> csvValueEscaper, T ... TArray) {
            StringBuilder stringBuilder = new StringBuilder(TArray.length * 10);
            if (TArray.length > 0) {
                int n2 = TArray.length - 1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuilder.append(csvValueEscaper.escape(charSequence, TArray[i2])).append(',');
                }
                stringBuilder.append(csvValueEscaper.escape(charSequence, TArray[n2]));
            }
            return stringBuilder;
        }

        private static <T> CharSequence commaSeparate(CharSequence charSequence, CsvValueEscaper<T> csvValueEscaper, Iterable<? extends T> iterable) {
            StringBuilder stringBuilder = iterable instanceof Collection ? new StringBuilder(((Collection)iterable).size() * 10) : new StringBuilder();
            Iterator<T> iterator = iterable.iterator();
            if (iterator.hasNext()) {
                T t2 = iterator.next();
                while (iterator.hasNext()) {
                    stringBuilder.append(csvValueEscaper.escape(charSequence, t2)).append(',');
                    t2 = iterator.next();
                }
                stringBuilder.append(csvValueEscaper.escape(charSequence, t2));
            }
            return stringBuilder;
        }

        private static CharSequence commaSeparateEscapedValues(CharSequence charSequence, CharSequence charSequence2) {
            return new StringBuilder(charSequence.length() + 1 + charSequence2.length()).append(charSequence).append(',').append(charSequence2);
        }

        private static interface CsvValueEscaper<T> {
            public CharSequence escape(CharSequence var1, T var2);
        }
    }
}

