/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.FileRegion;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.EncoderException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.MessageToMessageEncoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.FullHttpMessage;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeadersEncoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpMessage;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpUtil;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.LastHttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.PromiseCombiner;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class HttpObjectEncoder<H extends HttpMessage>
extends MessageToMessageEncoder<Object> {
    private static final byte[] ZERO_CRLF_CRLF = new byte[]{48, 13, 10, 13, 10};
    private static final ByteBuf CRLF_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(2).writeByte(13).writeByte(10)).asReadOnly();
    private static final ByteBuf ZERO_CRLF_CRLF_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(ZERO_CRLF_CRLF.length).writeBytes(ZERO_CRLF_CRLF)).asReadOnly();
    private int state = 0;
    private float headersEncodedSizeAccumulator = 256.0f;
    private float trailersEncodedSizeAccumulator = 256.0f;
    private final List<Object> out = new ArrayList<Object>();

    private static boolean checkContentState(int n2) {
        return n2 == 2 || n2 == 1 || n2 == 3;
    }

    public HttpObjectEncoder() {
        super(Object.class);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        try {
            if (this.acceptOutboundMessage(object)) {
                this.encode(channelHandlerContext, object, this.out);
                if (this.out.isEmpty()) {
                    throw new EncoderException(StringUtil.simpleClassName(this) + " must produce at least one message.");
                }
            } else {
                channelHandlerContext.write(object, channelPromise);
            }
        }
        catch (EncoderException encoderException) {
            throw encoderException;
        }
        catch (Throwable throwable) {
            throw new EncoderException(throwable);
        }
        finally {
            HttpObjectEncoder.writeOutList(channelHandlerContext, this.out, channelPromise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOutList(ChannelHandlerContext channelHandlerContext, List<Object> list, ChannelPromise channelPromise) {
        int n2 = list.size();
        try {
            if (n2 == 1) {
                channelHandlerContext.write(list.get(0), channelPromise);
            } else if (n2 > 1) {
                if (channelPromise == channelHandlerContext.voidPromise()) {
                    HttpObjectEncoder.writeVoidPromise(channelHandlerContext, list);
                } else {
                    HttpObjectEncoder.writePromiseCombiner(channelHandlerContext, list, channelPromise);
                }
            }
        }
        finally {
            list.clear();
        }
    }

    private static void writeVoidPromise(ChannelHandlerContext channelHandlerContext, List<Object> list) {
        ChannelPromise channelPromise = channelHandlerContext.voidPromise();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            channelHandlerContext.write(list.get(i2), channelPromise);
        }
    }

    private static void writePromiseCombiner(ChannelHandlerContext channelHandlerContext, List<Object> list, ChannelPromise channelPromise) {
        PromiseCombiner promiseCombiner = new PromiseCombiner(channelHandlerContext.executor());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            promiseCombiner.add(channelHandlerContext.write(list.get(i2)));
        }
        promiseCombiner.finish(channelPromise);
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) throws Exception {
        if (object == Unpooled.EMPTY_BUFFER) {
            list.add(Unpooled.EMPTY_BUFFER);
            return;
        }
        if (object instanceof FullHttpMessage) {
            this.encodeFullHttpMessage(channelHandlerContext, object, list);
            return;
        }
        if (object instanceof HttpMessage) {
            HttpMessage httpMessage;
            try {
                httpMessage = (HttpMessage)object;
            }
            catch (Exception exception) {
                ReferenceCountUtil.release(object);
                throw exception;
            }
            if (httpMessage instanceof LastHttpContent) {
                this.encodeHttpMessageLastContent(channelHandlerContext, httpMessage, list);
            } else if (httpMessage instanceof HttpContent) {
                this.encodeHttpMessageNotLastContent(channelHandlerContext, httpMessage, list);
            } else {
                this.encodeJustHttpMessage(channelHandlerContext, httpMessage, list);
            }
        } else {
            this.encodeNotHttpMessageContentTypes(channelHandlerContext, object, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeJustHttpMessage(ChannelHandlerContext channelHandlerContext, H h2, List<Object> list) throws Exception {
        assert (!(h2 instanceof HttpContent));
        try {
            if (this.state != 0) {
                HttpObjectEncoder.throwUnexpectedMessageTypeEx(h2, this.state);
            }
            ByteBuf byteBuf = this.encodeInitHttpMessage(channelHandlerContext, h2);
            assert (HttpObjectEncoder.checkContentState(this.state));
            list.add(byteBuf);
        }
        finally {
            ReferenceCountUtil.release(h2);
        }
    }

    private void encodeByteBufHttpContent(int n2, ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2, HttpHeaders httpHeaders, List<Object> list) {
        switch (n2) {
            case 1: {
                if (HttpObjectEncoder.encodeContentNonChunk(list, byteBuf, byteBuf2)) break;
            }
            case 3: {
                list.add(byteBuf);
                break;
            }
            case 2: {
                list.add(byteBuf);
                this.encodeChunkedHttpContent(channelHandlerContext, byteBuf2, httpHeaders, list);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeHttpMessageNotLastContent(ChannelHandlerContext channelHandlerContext, H h2, List<Object> list) throws Exception {
        assert (h2 instanceof HttpContent);
        assert (!(h2 instanceof LastHttpContent));
        HttpContent httpContent = (HttpContent)h2;
        try {
            if (this.state != 0) {
                HttpObjectEncoder.throwUnexpectedMessageTypeEx(h2, this.state);
            }
            ByteBuf byteBuf = this.encodeInitHttpMessage(channelHandlerContext, h2);
            assert (HttpObjectEncoder.checkContentState(this.state));
            this.encodeByteBufHttpContent(this.state, channelHandlerContext, byteBuf, httpContent.content(), null, list);
        }
        finally {
            httpContent.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeHttpMessageLastContent(ChannelHandlerContext channelHandlerContext, H h2, List<Object> list) throws Exception {
        assert (h2 instanceof LastHttpContent);
        LastHttpContent lastHttpContent = (LastHttpContent)h2;
        try {
            if (this.state != 0) {
                HttpObjectEncoder.throwUnexpectedMessageTypeEx(h2, this.state);
            }
            ByteBuf byteBuf = this.encodeInitHttpMessage(channelHandlerContext, h2);
            assert (HttpObjectEncoder.checkContentState(this.state));
            this.encodeByteBufHttpContent(this.state, channelHandlerContext, byteBuf, lastHttpContent.content(), lastHttpContent.trailingHeaders(), list);
            this.state = 0;
        }
        finally {
            lastHttpContent.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeNotHttpMessageContentTypes(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) {
        assert (!(object instanceof HttpMessage));
        if (this.state == 0) {
            try {
                if (object instanceof ByteBuf && HttpObjectEncoder.bypassEncoderIfEmpty((ByteBuf)object, list)) {
                    return;
                }
                HttpObjectEncoder.throwUnexpectedMessageTypeEx(object, 0);
            }
            finally {
                ReferenceCountUtil.release(object);
            }
        }
        if (object == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.state = HttpObjectEncoder.encodeEmptyLastHttpContent(this.state, list);
            return;
        }
        if (object instanceof LastHttpContent) {
            this.encodeLastHttpContent(channelHandlerContext, (LastHttpContent)object, list);
            return;
        }
        if (object instanceof HttpContent) {
            this.encodeHttpContent(channelHandlerContext, (HttpContent)object, list);
            return;
        }
        if (object instanceof ByteBuf) {
            this.encodeByteBufContent(channelHandlerContext, (ByteBuf)object, list);
            return;
        }
        if (object instanceof FileRegion) {
            this.encodeFileRegionContent(channelHandlerContext, (FileRegion)object, list);
            return;
        }
        try {
            HttpObjectEncoder.throwUnexpectedMessageTypeEx(object, this.state);
        }
        finally {
            ReferenceCountUtil.release(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeFullHttpMessage(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) throws Exception {
        assert (object instanceof FullHttpMessage);
        FullHttpMessage fullHttpMessage = (FullHttpMessage)object;
        try {
            HttpMessage httpMessage;
            if (this.state != 0) {
                HttpObjectEncoder.throwUnexpectedMessageTypeEx(object, this.state);
            }
            int n2 = this.isContentAlwaysEmpty(httpMessage = (HttpMessage)object) ? 3 : (HttpUtil.isTransferEncodingChunked(httpMessage) ? 2 : 1);
            ByteBuf byteBuf = fullHttpMessage.content();
            boolean bl2 = byteBuf.readableBytes() > 0 && n2 == 1 && byteBuf.readableBytes() <= Math.max(128, (int)this.headersEncodedSizeAccumulator / 8);
            int n3 = (int)this.headersEncodedSizeAccumulator + (bl2 ? byteBuf.readableBytes() : 0);
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(n3);
            this.encodeInitialLine(byteBuf2, httpMessage);
            this.sanitizeHeadersBeforeEncode(httpMessage, n2 == 3);
            this.encodeHeaders(httpMessage.headers(), byteBuf2);
            ByteBufUtil.writeShortBE(byteBuf2, 3338);
            this.headersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(byteBuf2.readableBytes()) + 0.8f * this.headersEncodedSizeAccumulator;
            this.encodeByteBufHttpContent(n2, channelHandlerContext, byteBuf2, byteBuf, fullHttpMessage.trailingHeaders(), list);
        }
        finally {
            fullHttpMessage.release();
        }
    }

    private static boolean encodeContentNonChunk(List<Object> list, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2 = byteBuf2.readableBytes();
        if (n2 > 0) {
            if (byteBuf.maxFastWritableBytes() >= n2) {
                byteBuf.writeBytes(byteBuf2);
                list.add(byteBuf);
            } else {
                list.add(byteBuf);
                list.add(byteBuf2.retain());
            }
            return true;
        }
        return false;
    }

    private static void throwUnexpectedMessageTypeEx(Object object, int n2) {
        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(object) + ", state: " + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void encodeFileRegionContent(ChannelHandlerContext channelHandlerContext, FileRegion fileRegion, List<Object> list) {
        try {
            assert (this.state != 0);
            switch (this.state) {
                case 1: {
                    if (fileRegion.count() > 0L) {
                        list.add(fileRegion.retain());
                        return;
                    }
                }
                case 3: {
                    list.add(Unpooled.EMPTY_BUFFER);
                    return;
                }
                case 2: {
                    HttpObjectEncoder.encodedChunkedFileRegionContent(channelHandlerContext, fileRegion, list);
                    return;
                }
                default: {
                    throw new Error();
                }
            }
        }
        finally {
            fileRegion.release();
        }
    }

    private static boolean bypassEncoderIfEmpty(ByteBuf byteBuf, List<Object> list) {
        if (!byteBuf.isReadable()) {
            list.add(byteBuf.retain());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeByteBufContent(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            assert (this.state != 0);
            if (HttpObjectEncoder.bypassEncoderIfEmpty(byteBuf, list)) {
                return;
            }
            this.encodeByteBufAndTrailers(this.state, channelHandlerContext, list, byteBuf, null);
        }
        finally {
            byteBuf.release();
        }
    }

    private static int encodeEmptyLastHttpContent(int n2, List<Object> list) {
        assert (n2 != 0);
        switch (n2) {
            case 1: 
            case 3: {
                list.add(Unpooled.EMPTY_BUFFER);
                break;
            }
            case 2: {
                list.add(ZERO_CRLF_CRLF_BUF.duplicate());
                break;
            }
            default: {
                throw new Error();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeLastHttpContent(ChannelHandlerContext channelHandlerContext, LastHttpContent lastHttpContent, List<Object> list) {
        assert (this.state != 0);
        assert (!(lastHttpContent instanceof HttpMessage));
        try {
            this.encodeByteBufAndTrailers(this.state, channelHandlerContext, list, lastHttpContent.content(), lastHttpContent.trailingHeaders());
            this.state = 0;
        }
        finally {
            lastHttpContent.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeHttpContent(ChannelHandlerContext channelHandlerContext, HttpContent httpContent, List<Object> list) {
        assert (this.state != 0);
        assert (!(httpContent instanceof HttpMessage));
        assert (!(httpContent instanceof LastHttpContent));
        try {
            this.encodeByteBufAndTrailers(this.state, channelHandlerContext, list, httpContent.content(), null);
        }
        finally {
            httpContent.release();
        }
    }

    private void encodeByteBufAndTrailers(int n2, ChannelHandlerContext channelHandlerContext, List<Object> list, ByteBuf byteBuf, HttpHeaders httpHeaders) {
        switch (n2) {
            case 1: {
                if (byteBuf.isReadable()) {
                    list.add(byteBuf.retain());
                    break;
                }
            }
            case 3: {
                list.add(Unpooled.EMPTY_BUFFER);
                break;
            }
            case 2: {
                this.encodeChunkedHttpContent(channelHandlerContext, byteBuf, httpHeaders, list);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void encodeChunkedHttpContent(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, HttpHeaders httpHeaders, List<Object> list) {
        int n2 = byteBuf.readableBytes();
        if (n2 > 0) {
            HttpObjectEncoder.addEncodedLengthHex(channelHandlerContext, n2, list);
            list.add(byteBuf.retain());
            list.add(CRLF_BUF.duplicate());
        }
        if (httpHeaders != null) {
            this.encodeTrailingHeaders(channelHandlerContext, httpHeaders, list);
        } else if (n2 == 0) {
            list.add(byteBuf.retain());
        }
    }

    private void encodeTrailingHeaders(ChannelHandlerContext channelHandlerContext, HttpHeaders httpHeaders, List<Object> list) {
        if (httpHeaders.isEmpty()) {
            list.add(ZERO_CRLF_CRLF_BUF.duplicate());
        } else {
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer((int)this.trailersEncodedSizeAccumulator);
            ByteBufUtil.writeMediumBE(byteBuf, 3149066);
            this.encodeHeaders(httpHeaders, byteBuf);
            ByteBufUtil.writeShortBE(byteBuf, 3338);
            this.trailersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(byteBuf.readableBytes()) + 0.8f * this.trailersEncodedSizeAccumulator;
            list.add(byteBuf);
        }
    }

    private ByteBuf encodeInitHttpMessage(ChannelHandlerContext channelHandlerContext, H h2) throws Exception {
        assert (this.state == 0);
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer((int)this.headersEncodedSizeAccumulator);
        this.encodeInitialLine(byteBuf, h2);
        this.state = this.isContentAlwaysEmpty(h2) ? 3 : (HttpUtil.isTransferEncodingChunked(h2) ? 2 : 1);
        this.sanitizeHeadersBeforeEncode(h2, this.state == 3);
        this.encodeHeaders(h2.headers(), byteBuf);
        ByteBufUtil.writeShortBE(byteBuf, 3338);
        this.headersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(byteBuf.readableBytes()) + 0.8f * this.headersEncodedSizeAccumulator;
        return byteBuf;
    }

    protected void encodeHeaders(HttpHeaders httpHeaders, ByteBuf byteBuf) {
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = httpHeaders.iteratorCharSequence();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            HttpHeadersEncoder.encoderHeader(entry.getKey(), entry.getValue(), byteBuf);
        }
    }

    private static void encodedChunkedFileRegionContent(ChannelHandlerContext channelHandlerContext, FileRegion fileRegion, List<Object> list) {
        long l2 = fileRegion.count();
        if (l2 > 0L) {
            HttpObjectEncoder.addEncodedLengthHex(channelHandlerContext, l2, list);
            list.add(fileRegion.retain());
            list.add(CRLF_BUF.duplicate());
        } else if (l2 == 0L) {
            list.add(fileRegion.retain());
        }
    }

    private static void addEncodedLengthHex(ChannelHandlerContext channelHandlerContext, long l2, List<Object> list) {
        String string = Long.toHexString(l2);
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer(string.length() + 2);
        byteBuf.writeCharSequence(string, CharsetUtil.US_ASCII);
        ByteBufUtil.writeShortBE(byteBuf, 3338);
        list.add(byteBuf);
    }

    protected void sanitizeHeadersBeforeEncode(H h2, boolean bl2) {
    }

    protected boolean isContentAlwaysEmpty(H h2) {
        return false;
    }

    @Override
    public boolean acceptOutboundMessage(Object object) throws Exception {
        return object == Unpooled.EMPTY_BUFFER || object == LastHttpContent.EMPTY_LAST_CONTENT || object instanceof FullHttpMessage || object instanceof HttpMessage || object instanceof LastHttpContent || object instanceof HttpContent || object instanceof ByteBuf || object instanceof FileRegion;
    }

    private static int padSizeForAccumulation(int n2) {
        return (n2 << 2) / 3;
    }

    protected abstract void encodeInitialLine(ByteBuf var1, H var2) throws Exception;
}

