/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util;

import com.gradle.maven.extension.internal.dep.io.netty.util.AsciiStringUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.HashingStrategy;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.MathUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;

public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = AsciiString.cached("");
    private final byte[] value;
    private final int offset;
    private final int length;
    private int hash;
    private String string;
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence charSequence) {
            return AsciiString.hashCode(charSequence);
        }

        @Override
        public boolean equals(CharSequence charSequence, CharSequence charSequence2) {
            return AsciiString.contentEqualsIgnoreCase(charSequence, charSequence2);
        }
    };
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence charSequence) {
            return AsciiString.hashCode(charSequence);
        }

        @Override
        public boolean equals(CharSequence charSequence, CharSequence charSequence2) {
            return AsciiString.contentEquals(charSequence, charSequence2);
        }
    };

    public AsciiString(byte[] byArray, int n2, int n3, boolean bl2) {
        if (bl2) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            this.value = byArray2;
            this.offset = 0;
        } else {
            if (MathUtil.isOutOfBounds(n2, n3, byArray.length)) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= value.length(" + byArray.length + ')');
            }
            this.value = byArray;
            this.offset = n2;
        }
        this.length = n3;
    }

    public AsciiString(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
    }

    public AsciiString(CharSequence charSequence, int n2, int n3) {
        if (MathUtil.isOutOfBounds(n2, n3, charSequence.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= value.length(" + charSequence.length() + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(n3);
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.value[n4] = AsciiString.c2b(charSequence.charAt(n5));
            ++n4;
            ++n5;
        }
        this.offset = 0;
        this.length = n3;
    }

    public byte byteAt(int n2) {
        if (n2 < 0 || n2 >= this.length) {
            throw new IndexOutOfBoundsException("index: " + n2 + " must be in the range [0," + this.length + ")");
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte(this.value, n2 + this.offset);
        }
        return this.value[n2 + this.offset];
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public byte[] array() {
        return this.value;
    }

    public int arrayOffset() {
        return this.offset;
    }

    @Override
    public char charAt(int n2) {
        return AsciiString.b2c(this.byteAt(n2));
    }

    @Override
    public int compareTo(CharSequence charSequence) {
        if (this == charSequence) {
            return 0;
        }
        int n2 = this.length();
        int n3 = charSequence.length();
        int n4 = Math.min(n2, n3);
        int n5 = 0;
        int n6 = this.arrayOffset();
        while (n5 < n4) {
            int n7 = AsciiString.b2c(this.value[n6]) - charSequence.charAt(n5);
            if (n7 != 0) {
                return n7;
            }
            ++n5;
            ++n6;
        }
        return n2 - n3;
    }

    public boolean contentEqualsIgnoreCase(CharSequence charSequence) {
        if (this == charSequence) {
            return true;
        }
        if (charSequence == null || charSequence.length() != this.length()) {
            return false;
        }
        if (charSequence instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)charSequence;
            byte[] byArray = this.value;
            if (this.offset == 0 && asciiString.offset == 0 && this.length == byArray.length) {
                byte[] byArray2 = asciiString.value;
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    if (AsciiString.equalsIgnoreCase(byArray[i2], byArray2[i2])) continue;
                    return false;
                }
                return true;
            }
            return this.misalignedEqualsIgnoreCase(asciiString);
        }
        byte[] byArray = this.value;
        int n2 = this.offset;
        for (int i3 = 0; i3 < charSequence.length(); ++i3) {
            if (!AsciiString.equalsIgnoreCase(AsciiString.b2c(byArray[n2]), charSequence.charAt(i3))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean misalignedEqualsIgnoreCase(AsciiString asciiString) {
        byte[] byArray = this.value;
        byte[] byArray2 = asciiString.value;
        int n2 = this.offset;
        int n3 = asciiString.offset;
        int n4 = this.offset + this.length;
        while (n2 < n4) {
            if (!AsciiString.equalsIgnoreCase(byArray[n2], byArray2[n3])) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    @Override
    public AsciiString subSequence(int n2, int n3) {
        return this.subSequence(n2, n3, true);
    }

    public AsciiString subSequence(int n2, int n3, boolean bl2) {
        if (MathUtil.isOutOfBounds(n2, n3 - n2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= end (" + n3 + ") <= length(" + this.length() + ')');
        }
        if (n2 == 0 && n3 == this.length()) {
            return this;
        }
        if (n3 == n2) {
            return EMPTY_STRING;
        }
        return new AsciiString(this.value, n2 + this.offset, n3 - n2, bl2);
    }

    public int indexOf(char c2, int n2) {
        if (c2 > '\u00ff') {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        byte by2 = AsciiString.c2b0(c2);
        int n3 = this.offset + this.length;
        for (int i2 = n2 + this.offset; i2 < n3; ++i2) {
            if (this.value[i2] != by2) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public boolean regionMatches(int n2, CharSequence charSequence, int n3, int n4) {
        ObjectUtil.checkNotNull(charSequence, "string");
        if (n3 < 0 || charSequence.length() - n3 < n4) {
            return false;
        }
        int n5 = this.length();
        if (n2 < 0 || n5 - n2 < n4) {
            return false;
        }
        if (n4 <= 0) {
            return true;
        }
        if (charSequence instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)charSequence;
            return PlatformDependent.equals(this.value, n2 + this.offset, asciiString.value, n3 + asciiString.offset, n4);
        }
        int n6 = n3 + n4;
        int n7 = n3;
        int n8 = n2 + this.arrayOffset();
        while (n7 < n6) {
            if (AsciiString.b2c(this.value[n8]) != charSequence.charAt(n7)) {
                return false;
            }
            ++n7;
            ++n8;
        }
        return true;
    }

    public boolean regionMatches(boolean bl2, int n2, CharSequence charSequence, int n3, int n4) {
        if (!bl2) {
            return this.regionMatches(n2, charSequence, n3, n4);
        }
        ObjectUtil.checkNotNull(charSequence, "string");
        int n5 = this.length();
        if (n2 < 0 || n4 > n5 - n2) {
            return false;
        }
        if (n3 < 0 || n4 > charSequence.length() - n3) {
            return false;
        }
        int n6 = (n2 += this.arrayOffset()) + n4;
        if (charSequence instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)charSequence;
            byte[] byArray = this.value;
            byte[] byArray2 = asciiString.value;
            n3 += asciiString.offset;
            while (n2 < n6) {
                if (AsciiString.equalsIgnoreCase(byArray[n2++], byArray2[n3++])) continue;
                return false;
            }
            return true;
        }
        while (n2 < n6) {
            if (AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[n2++]), charSequence.charAt(n3++))) continue;
            return false;
        }
        return true;
    }

    public static CharSequence trim(CharSequence charSequence) {
        int n2;
        int n3;
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).trim();
        }
        if (charSequence instanceof String) {
            return ((String)charSequence).trim();
        }
        int n4 = n3 = charSequence.length() - 1;
        for (n2 = 0; n2 <= n4 && charSequence.charAt(n2) <= ' '; ++n2) {
        }
        while (n4 >= n2 && charSequence.charAt(n4) <= ' ') {
            --n4;
        }
        if (n2 == 0 && n4 == n3) {
            return charSequence;
        }
        return charSequence.subSequence(n2, n4);
    }

    public AsciiString trim() {
        int n2;
        int n3;
        int n4 = n3 = this.arrayOffset() + this.length() - 1;
        for (n2 = this.arrayOffset(); n2 <= n4 && this.value[n2] <= 32; ++n2) {
        }
        while (n4 >= n2 && this.value[n4] <= 32) {
            --n4;
        }
        if (n2 == 0 && n4 == n3) {
            return this;
        }
        return new AsciiString(this.value, n2, n4 - n2 + 1, false);
    }

    public boolean contentEquals(CharSequence charSequence) {
        if (this == charSequence) {
            return true;
        }
        if (charSequence == null || charSequence.length() != this.length()) {
            return false;
        }
        if (charSequence instanceof AsciiString) {
            return this.equals(charSequence);
        }
        int n2 = this.arrayOffset();
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (AsciiString.b2c(this.value[n2]) != charSequence.charAt(i2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            this.hash = n2 = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != AsciiString.class) {
            return false;
        }
        if (this == object) {
            return true;
        }
        AsciiString asciiString = (AsciiString)object;
        return this.length() == asciiString.length() && this.hashCode() == asciiString.hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), asciiString.array(), asciiString.arrayOffset(), this.length());
    }

    @Override
    public String toString() {
        String string = this.string;
        if (string == null) {
            this.string = string = this.toString(0);
        }
        return string;
    }

    public String toString(int n2) {
        return this.toString(n2, this.length());
    }

    public String toString(int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(n2, n4, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= srcIdx + length(" + n4 + ") <= srcLen(" + this.length() + ')');
        }
        String string = new String(this.value, 0, n2 + this.offset, n4);
        return string;
    }

    public static AsciiString of(CharSequence charSequence) {
        return charSequence instanceof AsciiString ? (AsciiString)charSequence : new AsciiString(charSequence);
    }

    public static AsciiString cached(String string) {
        AsciiString asciiString = new AsciiString(string);
        asciiString.string = string;
        return asciiString;
    }

    public static int hashCode(CharSequence charSequence) {
        if (charSequence == null) {
            return 0;
        }
        if (charSequence instanceof AsciiString) {
            return charSequence.hashCode();
        }
        return PlatformDependent.hashCodeAscii(charSequence);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).contentEqualsIgnoreCase(charSequence2);
        }
        if (charSequence2 instanceof AsciiString) {
            return ((AsciiString)charSequence2).contentEqualsIgnoreCase(charSequence);
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (AsciiString.equalsIgnoreCase(charSequence.charAt(i2), charSequence2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).contentEquals(charSequence2);
        }
        if (charSequence2 instanceof AsciiString) {
            return ((AsciiString)charSequence2).contentEquals(charSequence);
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (charSequence.charAt(i2) == charSequence2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    private static boolean regionMatchesCharSequences(CharSequence charSequence, int n2, CharSequence charSequence2, int n3, int n4, CharEqualityComparator charEqualityComparator) {
        if (n2 < 0 || n4 > charSequence.length() - n2) {
            return false;
        }
        if (n3 < 0 || n4 > charSequence2.length() - n3) {
            return false;
        }
        int n5 = n2;
        int n6 = n5 + n4;
        int n7 = n3;
        while (n5 < n6) {
            char c2;
            char c3;
            if (charEqualityComparator.equals(c3 = charSequence.charAt(n5++), c2 = charSequence2.charAt(n7++))) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatchesAscii(CharSequence charSequence, boolean bl2, int n2, CharSequence charSequence2, int n3, int n4) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (!bl2 && charSequence instanceof String && charSequence2 instanceof String) {
            return ((String)charSequence).regionMatches(false, n2, (String)charSequence2, n3, n4);
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).regionMatches(bl2, n2, charSequence2, n3, n4);
        }
        return AsciiString.regionMatchesCharSequences(charSequence, n2, charSequence2, n3, n4, bl2 ? AsciiCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    public static int indexOfIgnoreCaseAscii(CharSequence charSequence, CharSequence charSequence2, int n2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = charSequence2.length();
        int n4 = charSequence.length() - n3 + 1;
        if (n2 > n4) {
            return -1;
        }
        if (n3 == 0) {
            return n2;
        }
        for (int i2 = n2; i2 < n4; ++i2) {
            if (!AsciiString.regionMatchesAscii(charSequence, true, i2, charSequence2, 0, n3)) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(CharSequence charSequence, char c2, int n2) {
        int n3;
        if (charSequence instanceof String) {
            return ((String)charSequence).indexOf(c2, n2);
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).indexOf(c2, n2);
        }
        if (charSequence == null) {
            return -1;
        }
        int n4 = charSequence.length();
        int n5 = n3 = n2 < 0 ? 0 : n2;
        while (n3 < n4) {
            if (charSequence.charAt(n3) == c2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static boolean equalsIgnoreCase(byte by2, byte by3) {
        return by2 == by3 || AsciiStringUtil.toLowerCase(by2) == AsciiStringUtil.toLowerCase(by3);
    }

    private static boolean equalsIgnoreCase(char c2, char c3) {
        return c2 == c3 || AsciiString.toLowerCase(c2) == AsciiString.toLowerCase(c3);
    }

    public static char toLowerCase(char c2) {
        return AsciiString.isUpperCase(c2) ? (char)(c2 + 32) : c2;
    }

    public static boolean isUpperCase(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }

    public static byte c2b(char c2) {
        return (byte)(c2 > '\u00ff' ? 63 : (int)c2);
    }

    private static byte c2b0(char c2) {
        return (byte)c2;
    }

    public static char b2c(byte by2) {
        return (char)(by2 & 0xFF);
    }

    private static final class AsciiCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final AsciiCaseInsensitiveCharEqualityComparator INSTANCE = new AsciiCaseInsensitiveCharEqualityComparator();

        private AsciiCaseInsensitiveCharEqualityComparator() {
        }

        @Override
        public boolean equals(char c2, char c3) {
            return AsciiString.equalsIgnoreCase(c2, c3);
        }
    }

    private static final class DefaultCharEqualityComparator
    implements CharEqualityComparator {
        static final DefaultCharEqualityComparator INSTANCE = new DefaultCharEqualityComparator();

        private DefaultCharEqualityComparator() {
        }

        @Override
        public boolean equals(char c2, char c3) {
            return c2 == c3;
        }
    }

    private static interface CharEqualityComparator {
        public boolean equals(char var1, char var2);
    }
}

