/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.internal;

import com.gradle.maven.extension.internal.dep.io.netty.util.internal.CleanableDirectBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.Cleaner;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent0;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;

final class CleanerJava6
implements Cleaner {
    private static final MethodHandle CLEAN_METHOD;
    private static final InternalLogger logger;

    CleanerJava6() {
    }

    static boolean isSupported() {
        return CLEAN_METHOD != null;
    }

    @Override
    public CleanableDirectBuffer allocate(int n2) {
        return new CleanableDirectBufferImpl(ByteBuffer.allocateDirect(n2));
    }

    @Override
    @Deprecated
    public void freeDirectBuffer(ByteBuffer byteBuffer) {
        CleanerJava6.freeDirectBufferStatic(byteBuffer);
    }

    private static void freeDirectBufferStatic(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            return;
        }
        if (System.getSecurityManager() == null) {
            try {
                CleanerJava6.freeDirectBuffer0(byteBuffer);
            }
            catch (Throwable throwable) {
                PlatformDependent0.throwException(throwable);
            }
        } else {
            CleanerJava6.freeDirectBufferPrivileged(byteBuffer);
        }
    }

    private static void freeDirectBufferPrivileged(final ByteBuffer byteBuffer) {
        Throwable throwable = AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

            @Override
            public Throwable run() {
                try {
                    CleanerJava6.freeDirectBuffer0(byteBuffer);
                    return null;
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }
        });
        if (throwable != null) {
            PlatformDependent0.throwException(throwable);
        }
    }

    private static void freeDirectBuffer0(ByteBuffer byteBuffer) throws Throwable {
        CLEAN_METHOD.invokeExact(byteBuffer);
    }

    static {
        MethodHandle methodHandle;
        logger = InternalLoggerFactory.getInstance(CleanerJava6.class);
        Throwable throwable = null;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        try {
            Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Class<?> clazz = Class.forName("sun.misc.Cleaner");
                        Class<?> clazz2 = Class.forName("sun.nio.ch.DirectBuffer");
                        MethodHandles.Lookup lookup = MethodHandles.lookup();
                        MethodHandle methodHandle = lookup.findVirtual(clazz, "clean", MethodType.methodType(Void.TYPE));
                        MethodHandle methodHandle2 = lookup.findStatic(Objects.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class));
                        methodHandle = MethodHandles.guardWithTest(methodHandle2.asType(MethodType.methodType(Boolean.TYPE, clazz)), methodHandle, methodHandle2.asType(MethodType.methodType(Void.TYPE, clazz)));
                        methodHandle = MethodHandles.filterArguments(methodHandle, 0, lookup.findVirtual(clazz2, "cleaner", MethodType.methodType(clazz)));
                        methodHandle = MethodHandles.explicitCastArguments(methodHandle, MethodType.methodType(Void.TYPE, ByteBuffer.class));
                        return methodHandle;
                    }
                    catch (Throwable throwable) {
                        return throwable;
                    }
                }
            });
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            methodHandle = (MethodHandle)object;
            methodHandle.invokeExact(byteBuffer);
        }
        catch (Throwable throwable2) {
            methodHandle = null;
            throwable = throwable2;
        }
        if (throwable == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", throwable);
        }
        CLEAN_METHOD = methodHandle;
    }

    private static final class CleanableDirectBufferImpl
    implements CleanableDirectBuffer {
        private final ByteBuffer buffer;

        private CleanableDirectBufferImpl(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        @Override
        public ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public void clean() {
            CleanerJava6.freeDirectBufferStatic(this.buffer);
        }
    }
}

