/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Arrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Hash;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteComparator;
import java.io.Serializable;

public final class ByteArrays {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static final byte[] DEFAULT_EMPTY_ARRAY = new byte[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<byte[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(byte[] byArray, int n2, int n3) {
        Arrays.ensureOffsetLength(byArray.length, n2, n3);
    }

    public static void swap(byte[] byArray, int n2, int n3) {
        byte by2 = byArray[n2];
        byArray[n2] = byArray[n3];
        byArray[n3] = by2;
    }

    public static void swap(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            ByteArrays.swap(byArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(byte[] byArray, int n2, int n3, int n4, ByteComparator byteComparator) {
        int n5 = byteComparator.compare(byArray[n2], byArray[n3]);
        int n6 = byteComparator.compare(byArray[n2], byArray[n4]);
        int n7 = byteComparator.compare(byArray[n3], byArray[n4]);
        return n5 < 0 ? (n7 < 0 ? n3 : (n6 < 0 ? n4 : n2)) : (n7 > 0 ? n3 : (n6 > 0 ? n4 : n2));
    }

    private static void selectionSort(byte[] byArray, int n2, int n3, ByteComparator byteComparator) {
        for (int i2 = n2; i2 < n3 - 1; ++i2) {
            int n4;
            int n5 = i2;
            for (n4 = i2 + 1; n4 < n3; ++n4) {
                if (byteComparator.compare(byArray[n4], byArray[n5]) >= 0) continue;
                n5 = n4;
            }
            if (n5 == i2) continue;
            n4 = byArray[i2];
            byArray[i2] = byArray[n5];
            byArray[n5] = n4;
        }
    }

    private static void insertionSort(byte[] byArray, int n2, int n3, ByteComparator byteComparator) {
        int n4 = n2;
        while (++n4 < n3) {
            byte by2 = byArray[n4];
            int n5 = n4;
            byte by3 = byArray[n5 - 1];
            while (byteComparator.compare(by2, by3) < 0) {
                byArray[n5] = by3;
                if (n2 == n5 - 1) {
                    --n5;
                    break;
                }
                by3 = byArray[--n5 - 1];
            }
            byArray[n5] = by2;
        }
    }

    public static void quickSort(byte[] byArray, int n2, int n3, ByteComparator byteComparator) {
        int n4;
        int n5;
        int n6;
        byte by2;
        int n7 = n3 - n2;
        if (n7 < 16) {
            ByteArrays.selectionSort(byArray, n2, n3, byteComparator);
            return;
        }
        int n8 = n2 + n7 / 2;
        int n9 = n2;
        int n10 = n3 - 1;
        if (n7 > 128) {
            by2 = n7 / 8;
            n9 = ByteArrays.med3(byArray, n9, n9 + by2, n9 + 2 * by2, byteComparator);
            n8 = ByteArrays.med3(byArray, n8 - by2, n8, n8 + by2, byteComparator);
            n10 = ByteArrays.med3(byArray, n10 - 2 * by2, n10 - by2, n10, byteComparator);
        }
        n8 = ByteArrays.med3(byArray, n9, n8, n10, byteComparator);
        by2 = byArray[n8];
        int n11 = n6 = n2;
        int n12 = n5 = n3 - 1;
        while (true) {
            if (n11 <= n5 && (n4 = byteComparator.compare(byArray[n11], by2)) <= 0) {
                if (n4 == 0) {
                    ByteArrays.swap(byArray, n6++, n11);
                }
                ++n11;
                continue;
            }
            while (n5 >= n11 && (n4 = byteComparator.compare(byArray[n5], by2)) >= 0) {
                if (n4 == 0) {
                    ByteArrays.swap(byArray, n5, n12--);
                }
                --n5;
            }
            if (n11 > n5) break;
            ByteArrays.swap(byArray, n11++, n5--);
        }
        n4 = Math.min(n6 - n2, n11 - n6);
        ByteArrays.swap(byArray, n2, n11 - n4, n4);
        n4 = Math.min(n12 - n5, n3 - n12 - 1);
        ByteArrays.swap(byArray, n11, n3 - n4, n4);
        n4 = n11 - n6;
        if (n4 > 1) {
            ByteArrays.quickSort(byArray, n2, n2 + n4, byteComparator);
        }
        if ((n4 = n12 - n5) > 1) {
            ByteArrays.quickSort(byArray, n3 - n4, n3, byteComparator);
        }
    }

    public static void unstableSort(byte[] byArray, int n2, int n3) {
        java.util.Arrays.sort(byArray, n2, n3);
    }

    public static void unstableSort(byte[] byArray) {
        ByteArrays.unstableSort(byArray, 0, byArray.length);
    }

    public static void unstableSort(byte[] byArray, int n2, int n3, ByteComparator byteComparator) {
        ByteArrays.quickSort(byArray, n2, n3, byteComparator);
    }

    public static void unstableSort(byte[] byArray, ByteComparator byteComparator) {
        ByteArrays.unstableSort(byArray, 0, byArray.length, byteComparator);
    }

    public static void mergeSort(byte[] byArray, int n2, int n3, ByteComparator byteComparator, byte[] byArray2) {
        int n4 = n3 - n2;
        if (n4 < 16) {
            ByteArrays.insertionSort(byArray, n2, n3, byteComparator);
            return;
        }
        if (byArray2 == null) {
            byArray2 = java.util.Arrays.copyOf(byArray, n3);
        }
        int n5 = n2 + n3 >>> 1;
        ByteArrays.mergeSort(byArray2, n2, n5, byteComparator, byArray);
        ByteArrays.mergeSort(byArray2, n5, n3, byteComparator, byArray);
        if (byteComparator.compare(byArray2[n5 - 1], byArray2[n5]) <= 0) {
            System.arraycopy(byArray2, n2, byArray, n2, n4);
            return;
        }
        int n6 = n2;
        int n7 = n5;
        for (int i2 = n2; i2 < n3; ++i2) {
            byArray[i2] = n7 >= n3 || n6 < n5 && byteComparator.compare(byArray2[n6], byArray2[n7]) <= 0 ? byArray2[n6++] : byArray2[n7++];
        }
    }

    public static void mergeSort(byte[] byArray, int n2, int n3, ByteComparator byteComparator) {
        ByteArrays.mergeSort(byArray, n2, n3, byteComparator, null);
    }

    public static void stableSort(byte[] byArray, int n2, int n3, ByteComparator byteComparator) {
        ByteArrays.mergeSort(byArray, n2, n3, byteComparator);
    }

    public static void stableSort(byte[] byArray, ByteComparator byteComparator) {
        ByteArrays.stableSort(byArray, 0, byArray.length, byteComparator);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int n2, int n3, int n4) {
            this.offset = n2;
            this.length = n3;
            this.level = n4;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<byte[]>,
    Serializable {
        private ArrayHashStrategy() {
        }
    }
}

