/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Arrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Hash;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortComparator;
import java.io.Serializable;

public final class ShortArrays {
    public static final short[] EMPTY_ARRAY = new short[0];
    public static final short[] DEFAULT_EMPTY_ARRAY = new short[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<short[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(short[] sArray, int n2, int n3) {
        Arrays.ensureOffsetLength(sArray.length, n2, n3);
    }

    public static void swap(short[] sArray, int n2, int n3) {
        short s2 = sArray[n2];
        sArray[n2] = sArray[n3];
        sArray[n3] = s2;
    }

    public static void swap(short[] sArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            ShortArrays.swap(sArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(short[] sArray, int n2, int n3, int n4, ShortComparator shortComparator) {
        int n5 = shortComparator.compare(sArray[n2], sArray[n3]);
        int n6 = shortComparator.compare(sArray[n2], sArray[n4]);
        int n7 = shortComparator.compare(sArray[n3], sArray[n4]);
        return n5 < 0 ? (n7 < 0 ? n3 : (n6 < 0 ? n4 : n2)) : (n7 > 0 ? n3 : (n6 > 0 ? n4 : n2));
    }

    private static void selectionSort(short[] sArray, int n2, int n3, ShortComparator shortComparator) {
        for (int i2 = n2; i2 < n3 - 1; ++i2) {
            int n4;
            int n5 = i2;
            for (n4 = i2 + 1; n4 < n3; ++n4) {
                if (shortComparator.compare(sArray[n4], sArray[n5]) >= 0) continue;
                n5 = n4;
            }
            if (n5 == i2) continue;
            n4 = sArray[i2];
            sArray[i2] = sArray[n5];
            sArray[n5] = n4;
        }
    }

    private static void insertionSort(short[] sArray, int n2, int n3, ShortComparator shortComparator) {
        int n4 = n2;
        while (++n4 < n3) {
            short s2 = sArray[n4];
            int n5 = n4;
            short s3 = sArray[n5 - 1];
            while (shortComparator.compare(s2, s3) < 0) {
                sArray[n5] = s3;
                if (n2 == n5 - 1) {
                    --n5;
                    break;
                }
                s3 = sArray[--n5 - 1];
            }
            sArray[n5] = s2;
        }
    }

    public static void quickSort(short[] sArray, int n2, int n3, ShortComparator shortComparator) {
        int n4;
        int n5;
        int n6;
        short s2;
        int n7 = n3 - n2;
        if (n7 < 16) {
            ShortArrays.selectionSort(sArray, n2, n3, shortComparator);
            return;
        }
        int n8 = n2 + n7 / 2;
        int n9 = n2;
        int n10 = n3 - 1;
        if (n7 > 128) {
            s2 = n7 / 8;
            n9 = ShortArrays.med3(sArray, n9, n9 + s2, n9 + 2 * s2, shortComparator);
            n8 = ShortArrays.med3(sArray, n8 - s2, n8, n8 + s2, shortComparator);
            n10 = ShortArrays.med3(sArray, n10 - 2 * s2, n10 - s2, n10, shortComparator);
        }
        n8 = ShortArrays.med3(sArray, n9, n8, n10, shortComparator);
        s2 = sArray[n8];
        int n11 = n6 = n2;
        int n12 = n5 = n3 - 1;
        while (true) {
            if (n11 <= n5 && (n4 = shortComparator.compare(sArray[n11], s2)) <= 0) {
                if (n4 == 0) {
                    ShortArrays.swap(sArray, n6++, n11);
                }
                ++n11;
                continue;
            }
            while (n5 >= n11 && (n4 = shortComparator.compare(sArray[n5], s2)) >= 0) {
                if (n4 == 0) {
                    ShortArrays.swap(sArray, n5, n12--);
                }
                --n5;
            }
            if (n11 > n5) break;
            ShortArrays.swap(sArray, n11++, n5--);
        }
        n4 = Math.min(n6 - n2, n11 - n6);
        ShortArrays.swap(sArray, n2, n11 - n4, n4);
        n4 = Math.min(n12 - n5, n3 - n12 - 1);
        ShortArrays.swap(sArray, n11, n3 - n4, n4);
        n4 = n11 - n6;
        if (n4 > 1) {
            ShortArrays.quickSort(sArray, n2, n2 + n4, shortComparator);
        }
        if ((n4 = n12 - n5) > 1) {
            ShortArrays.quickSort(sArray, n3 - n4, n3, shortComparator);
        }
    }

    private static int med3(short[] sArray, int n2, int n3, int n4) {
        int n5 = Short.compare(sArray[n2], sArray[n3]);
        int n6 = Short.compare(sArray[n2], sArray[n4]);
        int n7 = Short.compare(sArray[n3], sArray[n4]);
        return n5 < 0 ? (n7 < 0 ? n3 : (n6 < 0 ? n4 : n2)) : (n7 > 0 ? n3 : (n6 > 0 ? n4 : n2));
    }

    private static void selectionSort(short[] sArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3 - 1; ++i2) {
            int n4;
            int n5 = i2;
            for (n4 = i2 + 1; n4 < n3; ++n4) {
                if (sArray[n4] >= sArray[n5]) continue;
                n5 = n4;
            }
            if (n5 == i2) continue;
            n4 = sArray[i2];
            sArray[i2] = sArray[n5];
            sArray[n5] = n4;
        }
    }

    public static void quickSort(short[] sArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        short s2;
        int n7 = n3 - n2;
        if (n7 < 16) {
            ShortArrays.selectionSort(sArray, n2, n3);
            return;
        }
        int n8 = n2 + n7 / 2;
        int n9 = n2;
        int n10 = n3 - 1;
        if (n7 > 128) {
            s2 = n7 / 8;
            n9 = ShortArrays.med3(sArray, n9, n9 + s2, n9 + 2 * s2);
            n8 = ShortArrays.med3(sArray, n8 - s2, n8, n8 + s2);
            n10 = ShortArrays.med3(sArray, n10 - 2 * s2, n10 - s2, n10);
        }
        n8 = ShortArrays.med3(sArray, n9, n8, n10);
        s2 = sArray[n8];
        int n11 = n6 = n2;
        int n12 = n5 = n3 - 1;
        while (true) {
            if (n11 <= n5 && (n4 = Short.compare(sArray[n11], s2)) <= 0) {
                if (n4 == 0) {
                    ShortArrays.swap(sArray, n6++, n11);
                }
                ++n11;
                continue;
            }
            while (n5 >= n11 && (n4 = Short.compare(sArray[n5], s2)) >= 0) {
                if (n4 == 0) {
                    ShortArrays.swap(sArray, n5, n12--);
                }
                --n5;
            }
            if (n11 > n5) break;
            ShortArrays.swap(sArray, n11++, n5--);
        }
        n4 = Math.min(n6 - n2, n11 - n6);
        ShortArrays.swap(sArray, n2, n11 - n4, n4);
        n4 = Math.min(n12 - n5, n3 - n12 - 1);
        ShortArrays.swap(sArray, n11, n3 - n4, n4);
        n4 = n11 - n6;
        if (n4 > 1) {
            ShortArrays.quickSort(sArray, n2, n2 + n4);
        }
        if ((n4 = n12 - n5) > 1) {
            ShortArrays.quickSort(sArray, n3 - n4, n3);
        }
    }

    public static void unstableSort(short[] sArray, int n2, int n3) {
        if (n3 - n2 >= 1000) {
            ShortArrays.radixSort(sArray, n2, n3);
        } else {
            ShortArrays.quickSort(sArray, n2, n3);
        }
    }

    public static void unstableSort(short[] sArray) {
        ShortArrays.unstableSort(sArray, 0, sArray.length);
    }

    public static void unstableSort(short[] sArray, int n2, int n3, ShortComparator shortComparator) {
        ShortArrays.quickSort(sArray, n2, n3, shortComparator);
    }

    public static void unstableSort(short[] sArray, ShortComparator shortComparator) {
        ShortArrays.unstableSort(sArray, 0, sArray.length, shortComparator);
    }

    public static void mergeSort(short[] sArray, int n2, int n3, ShortComparator shortComparator, short[] sArray2) {
        int n4 = n3 - n2;
        if (n4 < 16) {
            ShortArrays.insertionSort(sArray, n2, n3, shortComparator);
            return;
        }
        if (sArray2 == null) {
            sArray2 = java.util.Arrays.copyOf(sArray, n3);
        }
        int n5 = n2 + n3 >>> 1;
        ShortArrays.mergeSort(sArray2, n2, n5, shortComparator, sArray);
        ShortArrays.mergeSort(sArray2, n5, n3, shortComparator, sArray);
        if (shortComparator.compare(sArray2[n5 - 1], sArray2[n5]) <= 0) {
            System.arraycopy(sArray2, n2, sArray, n2, n4);
            return;
        }
        int n6 = n2;
        int n7 = n5;
        for (int i2 = n2; i2 < n3; ++i2) {
            sArray[i2] = n7 >= n3 || n6 < n5 && shortComparator.compare(sArray2[n6], sArray2[n7]) <= 0 ? sArray2[n6++] : sArray2[n7++];
        }
    }

    public static void mergeSort(short[] sArray, int n2, int n3, ShortComparator shortComparator) {
        ShortArrays.mergeSort(sArray, n2, n3, shortComparator, null);
    }

    public static void stableSort(short[] sArray, int n2, int n3, ShortComparator shortComparator) {
        ShortArrays.mergeSort(sArray, n2, n3, shortComparator);
    }

    public static void stableSort(short[] sArray, ShortComparator shortComparator) {
        ShortArrays.stableSort(sArray, 0, sArray.length, shortComparator);
    }

    public static void radixSort(short[] sArray, int n2, int n3) {
        if (n3 - n2 < 1024) {
            ShortArrays.quickSort(sArray, n2, n3);
            return;
        }
        boolean bl2 = true;
        int n4 = 256;
        int n5 = 0;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        nArray[n5] = n2;
        nArray2[n5] = n3 - n2;
        nArray3[n5++] = 0;
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        while (n5 > 0) {
            int n6;
            int n7 = nArray[--n5];
            int n8 = nArray2[n5];
            int n9 = nArray3[n5];
            int n10 = n9 % 2 == 0 ? 128 : 0;
            int n11 = (1 - n9 % 2) * 8;
            int n12 = n7 + n8;
            while (n12-- != n7) {
                int n13 = sArray[n12] >>> n11 & 0xFF ^ n10;
                nArray4[n13] = nArray4[n13] + 1;
            }
            n12 = -1;
            int n14 = n7;
            for (n6 = 0; n6 < 256; ++n6) {
                if (nArray4[n6] != 0) {
                    n12 = n6;
                }
                nArray5[n6] = n14 += nArray4[n6];
            }
            n6 = n7 + n8 - nArray4[n12];
            int n15 = -1;
            for (n14 = n7; n14 <= n6; n14 += nArray4[n15]) {
                short s2 = sArray[n14];
                n15 = s2 >>> n11 & 0xFF ^ n10;
                if (n14 < n6) {
                    while (true) {
                        int n16 = n15;
                        int n17 = nArray5[n16] - 1;
                        nArray5[n16] = n17;
                        int n18 = n17;
                        if (n17 <= n14) break;
                        short s3 = s2;
                        s2 = sArray[n18];
                        sArray[n18] = s3;
                        n15 = s2 >>> n11 & 0xFF ^ n10;
                    }
                    sArray[n14] = s2;
                }
                if (n9 < 1 && nArray4[n15] > 1) {
                    if (nArray4[n15] < 1024) {
                        ShortArrays.quickSort(sArray, n14, n14 + nArray4[n15]);
                    } else {
                        nArray[n5] = n14;
                        nArray2[n5] = nArray4[n15];
                        nArray3[n5++] = n9 + 1;
                    }
                }
                nArray4[n15] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int n2, int n3, int n4) {
            this.offset = n2;
            this.length = n3;
            this.level = n4;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<short[]>,
    Serializable {
        private ArrayHashStrategy() {
        }
    }
}

