/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.serialization;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.build.AbstractStreamBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.serialization.ObjectStreamClassPredicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ValidatingObjectInputStream
extends ObjectInputStream {
    private final ObjectStreamClassPredicate predicate;

    public static Builder builder() {
        return new Builder();
    }

    private ValidatingObjectInputStream(Builder builder) throws IOException {
        this(builder.getInputStream(), builder.predicate);
    }

    private ValidatingObjectInputStream(InputStream inputStream, ObjectStreamClassPredicate objectStreamClassPredicate) throws IOException {
        super(inputStream);
        this.predicate = objectStreamClassPredicate;
    }

    private void checkClassName(String string) throws InvalidClassException {
        if (!this.predicate.test(string)) {
            this.invalidClassNameFound(string);
        }
    }

    protected void invalidClassNameFound(String string) throws InvalidClassException {
        throw new InvalidClassException("Class name not accepted: " + string);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        this.checkClassName(objectStreamClass.getName());
        return super.resolveClass(objectStreamClass);
    }

    public static class Builder
    extends AbstractStreamBuilder<ValidatingObjectInputStream, Builder> {
        private ObjectStreamClassPredicate predicate = new ObjectStreamClassPredicate();

        @Deprecated
        public Builder() {
        }

        public Builder accept(Class<?> ... classArray) {
            this.predicate.accept(classArray);
            return this;
        }

        public ValidatingObjectInputStream get() throws IOException {
            return new ValidatingObjectInputStream(this);
        }
    }
}

