/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.BooleanTypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.util.NumberUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class OpGT
extends Operator {
    public OpGT(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super(">", n2, n3, spelNodeImplArray);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        Object object = this.getLeftOperand().getValueInternal(expressionState).getValue();
        Object object2 = this.getRightOperand().getValueInternal(expressionState).getValue();
        this.leftActualDescriptor = CodeFlow.toDescriptorFromObject(object);
        this.rightActualDescriptor = CodeFlow.toDescriptorFromObject(object2);
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            if (number instanceof BigDecimal || number2 instanceof BigDecimal) {
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2 = NumberUtils.convertNumberToTargetClass(number, BigDecimal.class);
                return BooleanTypedValue.forValue(bigDecimal2.compareTo(bigDecimal = NumberUtils.convertNumberToTargetClass(number2, BigDecimal.class)) > 0);
            }
            if (number instanceof Double || number2 instanceof Double) {
                return BooleanTypedValue.forValue(number.doubleValue() > number2.doubleValue());
            }
            if (number instanceof Float || number2 instanceof Float) {
                return BooleanTypedValue.forValue(number.floatValue() > number2.floatValue());
            }
            if (number instanceof BigInteger || number2 instanceof BigInteger) {
                BigInteger bigInteger;
                BigInteger bigInteger2 = NumberUtils.convertNumberToTargetClass(number, BigInteger.class);
                return BooleanTypedValue.forValue(bigInteger2.compareTo(bigInteger = NumberUtils.convertNumberToTargetClass(number2, BigInteger.class)) > 0);
            }
            if (number instanceof Long || number2 instanceof Long) {
                return BooleanTypedValue.forValue(number.longValue() > number2.longValue());
            }
            if (number instanceof Integer || number2 instanceof Integer) {
                return BooleanTypedValue.forValue(number.intValue() > number2.intValue());
            }
            if (number instanceof Short || number2 instanceof Short) {
                return BooleanTypedValue.forValue(number.shortValue() > number2.shortValue());
            }
            if (number instanceof Byte || number2 instanceof Byte) {
                return BooleanTypedValue.forValue(number.byteValue() > number2.byteValue());
            }
            return BooleanTypedValue.forValue(number.doubleValue() > number2.doubleValue());
        }
        if (object instanceof CharSequence && object2 instanceof CharSequence) {
            object = object.toString();
            object2 = object2.toString();
        }
        return BooleanTypedValue.forValue(expressionState.getTypeComparator().compare(object, object2) > 0);
    }

    @Override
    public boolean isCompilable() {
        return this.isCompilableOperatorUsingNumerics();
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        this.generateComparisonCode(methodVisitor, codeFlow, 158, 164);
    }
}

