/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.io;

import java.io.IOException;
import java.util.function.Supplier;
import org.gradle.internal.UncheckedException;

@FunctionalInterface
public interface IoSupplier<T> {
    public T get() throws IOException;

    public static <T> Supplier<T> wrap(IoSupplier<T> ioSupplier) {
        return () -> {
            try {
                return ioSupplier.get();
            }
            catch (IOException iOException) {
                throw UncheckedException.throwAsUncheckedException(iOException);
            }
        };
    }
}

