/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectCollectors;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectSpliterators;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Hashing;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableAsList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableEnumSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ObjectArrays;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.RegularImmutableAsList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.RegularImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.SingletonImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collector;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private transient ImmutableList<E> asList;

    public static <E> Collector<E, ?, ImmutableSet<E>> toImmutableSet() {
        return CollectCollectors.toImmutableSet();
    }

    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E element) {
        return new SingletonImmutableSet<E>(element);
    }

    @SafeVarargs
    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        int paramCount = 6;
        Object[] elements = new Object[6 + others.length];
        elements[0] = e1;
        elements[1] = e2;
        elements[2] = e3;
        elements[3] = e4;
        elements[4] = e5;
        elements[5] = e6;
        System.arraycopy(others, 0, elements, 6, others.length);
        return ImmutableSet.construct(elements.length, elements);
    }

    private static <E> ImmutableSet<E> construct(int n2, Object ... elements) {
        switch (n2) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object elem = elements[0];
                return ImmutableSet.of(elem);
            }
        }
        int tableSize = ImmutableSet.chooseTableSize(n2);
        Object[] table = new Object[tableSize];
        int mask = tableSize - 1;
        int hashCode = 0;
        int uniques = 0;
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            Object element = ObjectArrays.checkElementNotNull(elements[i2], i2);
            int hash = element.hashCode();
            int j2 = Hashing.smear(hash);
            while (true) {
                int index;
                Object value;
                if ((value = table[index = j2 & mask]) == null) {
                    elements[uniques++] = element;
                    table[index] = element;
                    hashCode += hash;
                    continue block4;
                }
                if (value.equals(element)) continue block4;
                ++j2;
            }
        }
        Arrays.fill(elements, uniques, n2, null);
        if (uniques == 1) {
            Object element = elements[0];
            return new SingletonImmutableSet<Object>(element, hashCode);
        }
        if (tableSize != ImmutableSet.chooseTableSize(uniques)) {
            return ImmutableSet.construct(uniques, elements);
        }
        Object[] uniqueElements = uniques < elements.length ? Arrays.copyOf(elements, uniques) : elements;
        return new RegularImmutableSet(uniqueElements, hashCode, table, mask);
    }

    static int chooseTableSize(int setSize) {
        if ((setSize = Math.max(setSize, 2)) < 0x2CCCCCCC) {
            int tableSize = Integer.highestOneBit(setSize - 1) << 1;
            while ((double)tableSize * 0.7 < (double)setSize) {
                tableSize <<= 1;
            }
            return tableSize;
        }
        Preconditions.checkArgument(setSize < 0x40000000, "collection too large");
        return 0x40000000;
    }

    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> elements) {
        if (elements instanceof ImmutableSet && !(elements instanceof SortedSet)) {
            ImmutableSet set = (ImmutableSet)elements;
            if (!set.isPartialView()) {
                return set;
            }
        } else if (elements instanceof EnumSet) {
            return ImmutableSet.copyOfEnumSet((EnumSet)elements);
        }
        Object[] array = elements.toArray();
        return ImmutableSet.construct(array.length, array);
    }

    public static <E> ImmutableSet<E> copyOf(E[] elements) {
        switch (elements.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(elements[0]);
            }
        }
        return ImmutableSet.construct(elements.length, (Object[])elements.clone());
    }

    private static ImmutableSet copyOfEnumSet(EnumSet enumSet) {
        return ImmutableEnumSet.asImmutable(EnumSet.copyOf(enumSet));
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableList<E> asList() {
        ImmutableList<E> result = this.asList;
        return result == null ? (this.asList = this.createAsList()) : result;
    }

    ImmutableList<E> createAsList() {
        return new RegularImmutableAsList(this, this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static class Builder<E>
    extends ImmutableCollection.ArrayBasedBuilder<E> {
        Object[] hashTable;
        private int hashCode;

        public Builder() {
            super(4);
        }

        @Override
        public Builder<E> add(E element) {
            Preconditions.checkNotNull(element);
            if (this.hashTable != null && ImmutableSet.chooseTableSize(this.size) <= this.hashTable.length) {
                this.addDeduping(element);
                return this;
            }
            this.hashTable = null;
            super.add((Object)element);
            return this;
        }

        private void addDeduping(E element) {
            int mask = this.hashTable.length - 1;
            int hash = element.hashCode();
            int i2 = Hashing.smear(hash);
            while (true) {
                Object previous;
                if ((previous = this.hashTable[i2 &= mask]) == null) {
                    this.hashTable[i2] = element;
                    this.hashCode += hash;
                    super.add((Object)element);
                    return;
                }
                if (previous.equals(element)) {
                    return;
                }
                ++i2;
            }
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> elements) {
            Preconditions.checkNotNull(elements);
            if (this.hashTable != null) {
                for (E e2 : elements) {
                    this.add((Object)e2);
                }
            } else {
                super.addAll(elements);
            }
            return this;
        }

        @Override
        Builder<E> combine(ImmutableCollection.ArrayBasedBuilder<E> builder) {
            if (this.hashTable != null && builder instanceof Builder) {
                for (int i2 = 0; i2 < builder.size; ++i2) {
                    this.addDeduping(builder.contents[i2]);
                }
            } else {
                super.combine(builder);
            }
            return this;
        }

        public ImmutableSet<E> build() {
            RegularImmutableSet result;
            switch (this.size) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(this.contents[0]);
                }
            }
            if (this.hashTable != null && this.size == this.contents.length) {
                result = new RegularImmutableSet(this.contents, this.hashCode, this.hashTable, this.hashTable.length - 1);
            } else {
                result = ImmutableSet.construct(this.size, this.contents);
                this.size = ((AbstractCollection)result).size();
            }
            this.forceCopy = true;
            this.hashTable = null;
            return result;
        }
    }

    static abstract class Indexed<E>
    extends ImmutableSet<E> {
        Indexed() {
        }

        abstract E get(int var1);

        @Override
        public UnmodifiableIterator<E> iterator() {
            return this.asList().iterator();
        }

        @Override
        public Spliterator<E> spliterator() {
            return CollectSpliterators.indexed(this.size(), 1297, this::get);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            Preconditions.checkNotNull(consumer);
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                consumer.accept(this.get(i2));
            }
        }

        @Override
        ImmutableList<E> createAsList() {
            return new ImmutableAsList<E>(){

                @Override
                public E get(int index) {
                    return this.get(index);
                }

                @Override
                Indexed<E> delegateCollection() {
                    return this;
                }
            };
        }
    }
}

